/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.DateFormatter;
import com.gemstone.gemfire.internal.logging.GemFireHandler;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.process.StartupStatusListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;

public abstract class LogWriterImpl
implements InternalLogWriter {
    private static final int LOGGING_FLAGS_MASK = 0xFFFFFF;
    protected static final int SECURITY_LOGGING_FLAG = 0x40000000;
    private static volatile StartupStatusListener startupListener;
    private final DateFormat timeFormatter = DateFormatter.createDateFormat();

    protected LogWriterImpl() {
    }

    @Override
    public abstract int getLogWriterLevel();

    @Override
    public boolean isSecure() {
        return false;
    }

    public static String allowedLogLevels() {
        StringBuffer b = new StringBuffer(64);
        for (int i = 0; i < levelNames.length; ++i) {
            if (i != 0) {
                b.append('|');
            }
            b.append(levelNames[i]);
        }
        return b.toString();
    }

    public static String levelToString(int level) {
        switch (level) {
            case -2147483648: {
                return "all";
            }
            case 300: {
                return "finest";
            }
            case 400: {
                return "finer";
            }
            case 500: {
                return "fine";
            }
            case 700: {
                return "config";
            }
            case 800: {
                return "info";
            }
            case 900: {
                return "warning";
            }
            case 950: {
                return "error";
            }
            case 1000: {
                return "severe";
            }
            case 0x7FFFFFFF: {
                return "none";
            }
        }
        return LogWriterImpl.levelToStringSpecialCase(level);
    }

    private static String levelToStringSpecialCase(int levelWithFlags) {
        if ((levelWithFlags & 0x40000000) != 0) {
            int level = levelWithFlags ^ 0x40000000;
            return "security-" + LogWriterImpl.levelToString(level);
        }
        return "level-" + String.valueOf(levelWithFlags);
    }

    protected static int getRealLogLevel(int levelWithFlags) {
        if (levelWithFlags == Integer.MAX_VALUE) {
            return levelWithFlags;
        }
        return levelWithFlags & 0xFFFFFF;
    }

    public static String join(Object[] a) {
        return LogWriterImpl.join(a, " ");
    }

    public static String join(Object[] a, String joinString) {
        return LogWriterImpl.join(Arrays.asList(a), joinString);
    }

    public static String join(List l) {
        return LogWriterImpl.join(l, " ");
    }

    public static String join(List l, String joinString) {
        StringBuffer result = new StringBuffer(80);
        boolean firstTime = true;
        Iterator it = l.iterator();
        while (it.hasNext()) {
            if (firstTime) {
                firstTime = false;
            } else {
                result.append(joinString);
            }
            result.append(it.next());
        }
        return result.toString();
    }

    public static int levelNameToCode(String levelName) {
        if ("all".equalsIgnoreCase(levelName)) {
            return Integer.MIN_VALUE;
        }
        if ("finest".equalsIgnoreCase(levelName) || "trace".equalsIgnoreCase(levelName)) {
            return 300;
        }
        if ("finer".equalsIgnoreCase(levelName)) {
            return 400;
        }
        if ("fine".equalsIgnoreCase(levelName) || "debug".equalsIgnoreCase(levelName)) {
            return 500;
        }
        if ("config".equalsIgnoreCase(levelName)) {
            return 700;
        }
        if ("info".equalsIgnoreCase(levelName)) {
            return 800;
        }
        if ("warning".equalsIgnoreCase(levelName) || "warn".equalsIgnoreCase(levelName)) {
            return 900;
        }
        if ("error".equalsIgnoreCase(levelName)) {
            return 950;
        }
        if ("severe".equalsIgnoreCase(levelName) || "fatal".equalsIgnoreCase(levelName)) {
            return 1000;
        }
        if ("none".equalsIgnoreCase(levelName)) {
            return Integer.MAX_VALUE;
        }
        try {
            if (levelName.startsWith("level-")) {
                String levelValue = levelName.substring("level-".length());
                return Integer.parseInt(levelValue);
            }
        }
        catch (NumberFormatException ignore) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Unknown log-level \"" + levelName + "\". Valid levels are: " + LogWriterImpl.join(levelNames) + ".");
    }

    protected String getTimeStamp() {
        return this.formatDate(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatDate(Date d) {
        try {
            DateFormat dateFormat = this.timeFormatter;
            synchronized (dateFormat) {
                return this.timeFormatter.format(d);
            }
        }
        catch (Exception e1) {
            try {
                return d.toString();
            }
            catch (Exception e2) {
                try {
                    return Long.toString(d.getTime());
                }
                catch (Exception e3) {
                    return "timestampFormatFailed";
                }
            }
        }
    }

    @Override
    public boolean severeEnabled() {
        return this.getLogWriterLevel() <= 1000;
    }

    @Override
    public void severe(String msg, Throwable ex) {
        if (this.severeEnabled()) {
            this.put(1000, msg, ex);
        }
    }

    @Override
    public void severe(String msg) {
        this.severe(msg, null);
    }

    @Override
    public void severe(Throwable ex) {
        this.severe(LocalizedStrings.EMPTY, ex);
    }

    @Override
    public void severe(StringId msgID, Object[] params, Throwable ex) {
        if (this.severeEnabled()) {
            this.put(1000, msgID, params, ex);
        }
    }

    @Override
    public void severe(StringId msgID, Object param, Throwable ex) {
        if (this.severeEnabled()) {
            this.put(1000, msgID, new Object[]{param}, ex);
        }
    }

    @Override
    public void severe(StringId msgID, Throwable ex) {
        this.severe(msgID, null, ex);
    }

    @Override
    public void severe(StringId msgID, Object[] params) {
        this.severe(msgID, params, (Throwable)null);
    }

    @Override
    public void severe(StringId msgID, Object param) {
        this.severe(msgID, param, null);
    }

    @Override
    public void severe(StringId msgID) {
        this.severe(msgID, null, null);
    }

    @Override
    public boolean errorEnabled() {
        return this.getLogWriterLevel() <= 950;
    }

    @Override
    public void error(String msg, Throwable ex) {
        if (this.errorEnabled()) {
            this.put(950, msg, ex);
        }
    }

    @Override
    public void error(String msg) {
        this.error(msg, null);
    }

    @Override
    public void error(Throwable ex) {
        this.error(LocalizedStrings.EMPTY, ex);
    }

    @Override
    public void error(StringId msgID, Object[] params, Throwable ex) {
        if (this.errorEnabled()) {
            this.put(950, msgID, params, ex);
        }
    }

    @Override
    public void error(StringId msgID, Object param, Throwable ex) {
        if (this.errorEnabled()) {
            this.put(950, msgID, new Object[]{param}, ex);
        }
    }

    @Override
    public void error(StringId msgID, Throwable ex) {
        this.error(msgID, null, ex);
    }

    @Override
    public void error(StringId msgID, Object[] params) {
        this.error(msgID, params, (Throwable)null);
    }

    @Override
    public void error(StringId msgID, Object param) {
        this.error(msgID, param, null);
    }

    @Override
    public void error(StringId msgID) {
        this.error(msgID, null, null);
    }

    @Override
    public boolean warningEnabled() {
        return this.getLogWriterLevel() <= 900;
    }

    @Override
    public void warning(String msg, Throwable ex) {
        if (this.warningEnabled()) {
            this.put(900, msg, ex);
        }
    }

    @Override
    public void warning(String msg) {
        this.warning(msg, null);
    }

    @Override
    public void warning(Throwable ex) {
        this.warning(LocalizedStrings.EMPTY, ex);
    }

    @Override
    public void warning(StringId msgID, Object[] params, Throwable ex) {
        if (this.warningEnabled()) {
            this.put(900, msgID, params, ex);
        }
    }

    @Override
    public void warning(StringId msgID, Object param, Throwable ex) {
        if (this.warningEnabled()) {
            this.put(900, msgID, new Object[]{param}, ex);
        }
    }

    @Override
    public void warning(StringId msgID, Throwable ex) {
        this.warning(msgID, null, ex);
    }

    @Override
    public void warning(StringId msgID, Object[] params) {
        this.warning(msgID, params, (Throwable)null);
    }

    @Override
    public void warning(StringId msgID, Object param) {
        this.warning(msgID, param, null);
    }

    @Override
    public void warning(StringId msgID) {
        this.warning(msgID, null, null);
    }

    @Override
    public boolean infoEnabled() {
        return this.getLogWriterLevel() <= 800;
    }

    @Override
    public void info(String msg, Throwable ex) {
        if (this.infoEnabled()) {
            this.put(800, msg, ex);
        }
    }

    @Override
    public void info(String msg) {
        this.info(msg, null);
    }

    @Override
    public void info(Throwable ex) {
        this.info(LocalizedStrings.EMPTY, ex);
    }

    @Override
    public void info(StringId msgID, Object[] params, Throwable ex) {
        if (this.infoEnabled()) {
            this.put(800, msgID, params, ex);
        }
    }

    @Override
    public void info(StringId msgID, Object param, Throwable ex) {
        if (this.infoEnabled()) {
            this.put(800, msgID, new Object[]{param}, ex);
        }
    }

    @Override
    public void info(StringId msgID, Throwable ex) {
        this.info(msgID, null, ex);
    }

    @Override
    public void info(StringId msgID, Object[] params) {
        this.info(msgID, params, (Throwable)null);
    }

    @Override
    public void info(StringId msgID, Object param) {
        this.info(msgID, param, null);
    }

    @Override
    public void info(StringId msgID) {
        this.info(msgID, null, null);
    }

    @Override
    public boolean configEnabled() {
        return this.getLogWriterLevel() <= 700;
    }

    @Override
    public void config(String msg, Throwable ex) {
        if (this.configEnabled()) {
            this.put(700, msg, ex);
        }
    }

    @Override
    public void config(String msg) {
        this.config(msg, null);
    }

    @Override
    public void config(Throwable ex) {
        this.config(LocalizedStrings.EMPTY, ex);
    }

    @Override
    public void config(StringId msgID, Object[] params, Throwable ex) {
        if (this.configEnabled()) {
            this.put(700, msgID, params, ex);
        }
    }

    @Override
    public void config(StringId msgID, Object param, Throwable ex) {
        if (this.configEnabled()) {
            this.put(700, msgID, new Object[]{param}, ex);
        }
    }

    @Override
    public void config(StringId msgID, Throwable ex) {
        this.config(msgID, null, ex);
    }

    @Override
    public void config(StringId msgID, Object[] params) {
        this.config(msgID, params, (Throwable)null);
    }

    @Override
    public void config(StringId msgID, Object param) {
        this.config(msgID, param, null);
    }

    @Override
    public void config(StringId msgID) {
        this.config(msgID, null, null);
    }

    @Override
    public boolean fineEnabled() {
        return this.getLogWriterLevel() <= 500;
    }

    @Override
    public void fine(String msg, Throwable ex) {
        if (this.fineEnabled()) {
            this.put(500, msg, ex);
        }
    }

    @Override
    public void fine(String msg) {
        this.fine(msg, null);
    }

    @Override
    public void fine(Throwable ex) {
        this.fine(null, ex);
    }

    @Override
    public boolean finerEnabled() {
        return this.getLogWriterLevel() <= 400;
    }

    @Override
    public void finer(String msg, Throwable ex) {
        if (this.finerEnabled()) {
            this.put(400, msg, ex);
        }
    }

    @Override
    public void finer(String msg) {
        this.finer(msg, null);
    }

    @Override
    public void finer(Throwable ex) {
        this.finer(null, ex);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (this.finerEnabled()) {
            this.finer("ENTRY " + sourceClass + ":" + sourceMethod);
        }
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (this.finerEnabled()) {
            this.finer("RETURN " + sourceClass + ":" + sourceMethod);
        }
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.finerEnabled()) {
            this.finer("THROW " + sourceClass + ":" + sourceMethod, thrown);
        }
    }

    @Override
    public boolean finestEnabled() {
        return this.getLogWriterLevel() <= 300;
    }

    @Override
    public void finest(String msg, Throwable ex) {
        if (this.finestEnabled()) {
            this.put(300, msg, ex);
        }
    }

    @Override
    public void finest(String msg) {
        this.finest(msg, null);
    }

    @Override
    public void finest(Throwable ex) {
        this.finest(null, ex);
    }

    public void startup(StringId msgID, Object[] params) {
        String message = msgID.toLocalizedString(params);
        StartupStatusListener listener = startupListener;
        if (listener != null) {
            listener.setStatus(message);
        }
        if (this.infoEnabled()) {
            this.put(800, message, null);
        }
    }

    @Override
    public abstract void put(int var1, String var2, Throwable var3);

    @Override
    public abstract void put(int var1, StringId var2, Object[] var3, Throwable var4);

    static void formatText(PrintWriter writer, String target, int initialLength) {
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(target);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = initialLength;
        while (end != -1) {
            char endChar = target.charAt(end - 1);
            while (!Character.isWhitespace(endChar)) {
                int lastEnd = end;
                end = boundary.next();
                if (end == -1) {
                    end = lastEnd;
                    break;
                }
                endChar = target.charAt(end - 1);
            }
            int wordEnd = end;
            if (endChar == '\n') {
                if (--wordEnd > 0 && target.charAt(wordEnd - 1) == '\r') {
                    --wordEnd;
                }
            } else if (endChar == '\t') {
                lineLength += 7;
            }
            String word = target.substring(start, wordEnd);
            lineLength += word.length();
            writer.print(word);
            if (endChar == '\n' || endChar == '\r') {
                writer.println();
                writer.print("  ");
                lineLength = 2;
            }
            start = end;
            end = boundary.next();
        }
        if (lineLength != 0) {
            writer.println();
        }
    }

    public boolean isLoggable(int level) {
        return this.getLogWriterLevel() <= level;
    }

    public void log(int level, String message, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.put(level, message, thrown);
        }
    }

    public void log(int level, String message) {
        if (this.isLoggable(level)) {
            this.put(level, message, null);
        }
    }

    @Override
    public Handler getHandler() {
        return new GemFireHandler(this);
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter sw = new StringWriter();
        aThrowable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public void logTraces(final boolean toStdout, final Thread targetThread, int interval, final AtomicBoolean done) {
        if (targetThread == null) {
            return;
        }
        Thread watcherThread = new Thread("Stack Tracer for '" + targetThread.getName() + "'"){

            @Override
            public void run() {
                while (!done.get()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (done.get() || !targetThread.isAlive()) continue;
                    StringBuffer sb = new StringBuffer(500);
                    if (toStdout) {
                        sb.append("[trace ").append(LogWriterImpl.this.getTimeStamp()).append("] ");
                    }
                    StackTraceElement[] els = targetThread.getStackTrace();
                    sb.append("Stack trace for '").append(targetThread.toString()).append("'\n");
                    if (els.length > 0) {
                        for (int i = 0; i < els.length; ++i) {
                            sb.append("\tat ").append(els[i].toString()).append("\n");
                        }
                    } else {
                        sb.append("    no stack\n");
                    }
                    if (toStdout) {
                        System.out.println(sb.toString());
                        continue;
                    }
                    LogWriterImpl.this.info(LocalizedStrings.DEBUG, sb.toString());
                }
            }
        };
        watcherThread.start();
    }

    public static StringBuffer getStackTrace(Thread targetThread) {
        StringBuffer sb = new StringBuffer(500);
        StackTraceElement[] els = targetThread.getStackTrace();
        sb.append("Stack trace for '").append(targetThread.toString()).append("'\n");
        if (els.length > 0) {
            for (int i = 0; i < els.length; ++i) {
                sb.append("\tat ").append(els[i].toString()).append("\n");
            }
        } else {
            sb.append("    no stack\n");
        }
        return sb;
    }

    @Override
    public LogWriter convertToLogWriter() {
        return this;
    }

    @Override
    public LogWriterI18n convertToLogWriterI18n() {
        return this;
    }

    public static void setStartupListener(StartupStatusListener mainListener) {
        startupListener = mainListener;
    }

    public static StartupStatusListener getStartupListener() {
        return startupListener;
    }

    static {
        Assert.assertTrue(Integer.MIN_VALUE == Level.ALL.intValue());
        Assert.assertTrue(Integer.MAX_VALUE == Level.OFF.intValue());
        Assert.assertTrue(300 == Level.FINEST.intValue());
        Assert.assertTrue(400 == Level.FINER.intValue());
        Assert.assertTrue(500 == Level.FINE.intValue());
        Assert.assertTrue(700 == Level.CONFIG.intValue());
        Assert.assertTrue(800 == Level.INFO.intValue());
        Assert.assertTrue(900 == Level.WARNING.intValue());
        Assert.assertTrue(1000 == Level.SEVERE.intValue());
        int logLevels = 1020;
        Assert.assertTrue(logLevels == (logLevels & 0xFFFFFF));
        Assert.assertTrue(0 == (logLevels & 0x40000000));
    }
}

