/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging.log4j;

import com.gemstone.gemfire.internal.logging.LogConfig;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.ManagerLogWriter;
import com.gemstone.gemfire.internal.logging.PureLogWriter;
import com.gemstone.gemfire.internal.logging.log4j.AppenderContext;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogWriterAppender
extends AbstractAppender
implements PropertyChangeListener {
    private static final Logger logger = LogService.getLogger();
    private static final ThreadLocal<Boolean> appending = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final PureLogWriter logWriter;
    private final FileOutputStream fos;
    private final AppenderContext[] appenderContexts;
    private final String appenderName;
    private final String logWriterLoggerName;

    private LogWriterAppender(AppenderContext[] appenderContexts, String name, PureLogWriter logWriter, FileOutputStream fos) {
        super(LogWriterAppender.class.getName() + "-" + name, null, PatternLayout.createDefaultLayout());
        this.appenderContexts = appenderContexts;
        this.appenderName = LogWriterAppender.class.getName() + "-" + name;
        this.logWriterLoggerName = name;
        this.logWriter = logWriter;
        this.fos = fos;
    }

    static final LogWriterAppender create(AppenderContext[] contexts, String name, PureLogWriter logWriter, FileOutputStream fos) {
        LogWriterAppender appender = new LogWriterAppender(contexts, name, logWriter, fos);
        for (AppenderContext context : appender.appenderContexts) {
            context.getLoggerContext().addPropertyChangeListener(appender);
        }
        appender.start();
        for (AppenderContext context : appender.appenderContexts) {
            context.getLoggerConfig().addAppender(appender, Level.ALL, null);
        }
        return appender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LogEvent event) {
        if (appending.get().booleanValue()) {
            return;
        }
        appending.set(Boolean.TRUE);
        try {
            this.logWriter.put(LogWriterLogger.log4jLevelToLogWriterLevel(event.getLevel()), event.getMessage().getFormattedMessage(), event.getThrown());
        }
        finally {
            appending.set(Boolean.FALSE);
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug("Responding to a property change event. Property name is {}.", evt.getPropertyName());
        }
        if (evt.getPropertyName().equals("config")) {
            for (AppenderContext context : this.appenderContexts) {
                LoggerConfig loggerConfig = context.getLoggerConfig();
                if (loggerConfig.getAppenders().containsKey(this.appenderName)) continue;
                loggerConfig.addAppender(this, Level.ALL, null);
            }
        }
    }

    protected void destroy() {
        if ("com.gemstone.gemfire".equals(this.logWriterLoggerName) && LogService.isUsingGemFireDefaultConfig()) {
            LogService.restoreConsoleAppender();
        }
        for (AppenderContext context : this.appenderContexts) {
            context.getLoggerContext().removePropertyChangeListener(this);
            context.getLoggerConfig().removeAppender(this.appenderName);
            context.getLoggerContext().updateLoggers();
        }
        this.stop();
        this.cleanUp();
        if (logger.isDebugEnabled()) {
            logger.debug("A LogWriterAppender has been destroyed and cleanup is finished.");
        }
    }

    private void cleanUp() {
        if (this.logWriter instanceof ManagerLogWriter) {
            ((ManagerLogWriter)this.logWriter).closingLogFile();
        }
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        try {
            if (this.logWriter instanceof ManagerLogWriter) {
                ((ManagerLogWriter)this.logWriter).shuttingDown();
            }
        }
        catch (RuntimeException e) {
            logger.warn("RuntimeException encountered while shuttingDown LogWriterAppender", (Throwable)e);
        }
        super.stop();
    }

    protected void startupComplete() {
        if (this.logWriter instanceof ManagerLogWriter) {
            ((ManagerLogWriter)this.logWriter).startupComplete();
        }
    }

    protected void setConfig(LogConfig cfg) {
        if (this.logWriter instanceof ManagerLogWriter) {
            ((ManagerLogWriter)this.logWriter).setConfig(cfg);
        }
    }

    public File getChildLogFile() {
        if (this.logWriter instanceof ManagerLogWriter) {
            return ((ManagerLogWriter)this.logWriter).getChildLogFile();
        }
        return null;
    }

    public File getLogDir() {
        if (this.logWriter instanceof ManagerLogWriter) {
            return ((ManagerLogWriter)this.logWriter).getLogDir();
        }
        return null;
    }

    public int getMainLogId() {
        if (this.logWriter instanceof ManagerLogWriter) {
            return ((ManagerLogWriter)this.logWriter).getMainLogId();
        }
        return -1;
    }

    public boolean useChildLogging() {
        if (this.logWriter instanceof ManagerLogWriter) {
            return ((ManagerLogWriter)this.logWriter).useChildLogging();
        }
        return false;
    }

    protected void configChanged() {
        if (this.logWriter instanceof ManagerLogWriter) {
            ((ManagerLogWriter)this.logWriter).configChanged();
        }
    }
}

