/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached;

import com.gemstone.gemfire.internal.memcached.Command;
import com.gemstone.gemfire.internal.memcached.ConnectionHandler;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.commands.ClientError;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class RequestReader {
    private static final Charset charsetASCII = Charset.forName("US-ASCII");
    private static final ThreadLocal<CharsetDecoder> asciiDecoder = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return charsetASCII.newDecoder();
        }
    };
    private ByteBuffer buffer;
    private ByteBuffer response;
    private static final int RESPONSE_HEADER_LENGTH = 24;
    private static final byte RESPONSE_MAGIC = -127;
    private static final int HEADER_LENGTH = 24;
    private static final byte REQUEST_MAGIC = -128;
    private static final int POSITION_OPCODE = 1;
    private static final int POSITION_OPAQUE = 12;
    private Socket socket;
    private final GemFireMemcachedServer.Protocol protocol;
    private CharBuffer commandBuffer = CharBuffer.allocate(11);
    private static byte[] cleanByteArray;

    public RequestReader(Socket socket, GemFireMemcachedServer.Protocol protocol) {
        this.buffer = ByteBuffer.allocate(this.getBufferSize(socket.getChannel()));
        this.buffer.position(this.buffer.limit());
        this.socket = socket;
        this.protocol = protocol;
    }

    public Command readCommand() throws IOException {
        if (this.protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.readAsciiCommand();
        }
        return this.readBinaryCommand();
    }

    private Command readBinaryCommand() throws IOException {
        SocketChannel channel = this.socket.getChannel();
        if (channel == null || !channel.isOpen()) {
            throw new IllegalStateException("cannot read from channel");
        }
        Command cmd = null;
        boolean done = false;
        boolean read = false;
        while (!done) {
            int bodyLength;
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                read = true;
            } else if (!read) {
                this.buffer.compact();
                this.buffer.limit(this.buffer.position());
                this.buffer.position(0);
            }
            if (read) {
                int bytesRead = channel.read(this.buffer);
                if (bytesRead == -1) {
                    throw new IOException("EOF");
                }
                this.buffer.flip();
            }
            if (this.buffer.limit() < 24) {
                this.buffer.compact();
                read = true;
                continue;
            }
            int requestLength = this.buffer.remaining();
            byte magic = this.buffer.get();
            if (magic != -128) {
                throw new IllegalStateException("Not a valid request, magic byte incorrect");
            }
            byte opCode = this.buffer.get();
            if (ConnectionHandler.getLogger().finerEnabled()) {
                String str = Command.buffertoString(this.buffer);
                ConnectionHandler.getLogger().finer("Request:" + this.buffer + str.toString());
            }
            if (24 + (bodyLength = this.buffer.getInt(8)) > requestLength) {
                this.buffer.position(this.buffer.position() - 2);
                this.buffer.compact();
                if (this.buffer.capacity() < 24 + bodyLength) {
                    ByteBuffer oldBuffer = this.buffer;
                    oldBuffer.position(0);
                    this.buffer = ByteBuffer.allocate(24 + bodyLength);
                    this.buffer.put(oldBuffer);
                }
                read = true;
                continue;
            }
            cmd = Command.getCommandFromOpCode(opCode);
            done = true;
        }
        if (ConnectionHandler.getLogger().fineEnabled()) {
            ConnectionHandler.getLogger().fine("read command " + cmd);
        }
        return cmd;
    }

    private Command readAsciiCommand() throws IOException {
        SocketChannel channel = this.socket.getChannel();
        if (channel == null || !channel.isOpen()) {
            throw new IllegalStateException("cannot read from channel");
        }
        this.buffer.clear();
        int bytesRead = channel.read(this.buffer);
        if (bytesRead == -1) {
            throw new IOException("EOF");
        }
        this.buffer.flip();
        return Command.valueOf(this.readCommand(this.buffer));
    }

    private String readCommand(ByteBuffer buffer) throws CharacterCodingException {
        this.commandBuffer.clear();
        asciiDecoder.get().decode(buffer, this.commandBuffer, false);
        this.commandBuffer.flip();
        return this.trimCommand(this.commandBuffer.toString()).toUpperCase();
    }

    private String trimCommand(String str) {
        int indexOfR;
        int indexOfSpace = str.indexOf(32);
        String retVal = str;
        if (indexOfSpace != -1) {
            retVal = str.substring(0, indexOfSpace);
        }
        if ((indexOfR = retVal.indexOf("\r")) != -1) {
            retVal = retVal.substring(0, indexOfR);
        }
        if (retVal.equals("")) {
            if (ConnectionHandler.getLogger().infoEnabled()) {
                ConnectionHandler.getLogger().info("Unknown command. ensure client protocol is ASCII");
            }
            throw new IllegalArgumentException("Unknown command. ensure client protocol is ASCII");
        }
        return retVal;
    }

    private int getBufferSize(SocketChannel channel) {
        int size2 = 1024;
        try {
            size2 = channel.socket().getReceiveBufferSize();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return size2;
    }

    public ByteBuffer getRequest() {
        this.buffer.rewind();
        return this.buffer;
    }

    public ByteBuffer getResponse() {
        return this.getResponse(24);
    }

    public ByteBuffer getResponse(int size2) {
        if (this.response == null || this.response.capacity() < size2) {
            this.response = ByteBuffer.allocate(size2);
        }
        this.clear(this.response);
        this.response.put((byte)-127);
        this.response.rewind();
        this.response.limit(size2);
        return this.response;
    }

    private void clear(ByteBuffer response) {
        response.position(0);
        response.limit(response.capacity());
        response.put(this.getCleanByteArray());
        while (response.remaining() > this.getCleanByteArray().length) {
            response.put(this.getCleanByteArray());
        }
        while (response.remaining() > 0) {
            response.put((byte)0);
        }
        response.clear();
    }

    private byte[] getCleanByteArray() {
        if (cleanByteArray != null) {
            return cleanByteArray;
        }
        cleanByteArray = new byte[24];
        for (int i = 0; i < cleanByteArray.length; ++i) {
            RequestReader.cleanByteArray[i] = 0;
        }
        return cleanByteArray;
    }

    public void sendReply(ByteBuffer reply) throws IOException {
        SocketChannel channel;
        if (this.protocol == GemFireMemcachedServer.Protocol.BINARY) {
            reply.rewind();
            reply.put(1, this.buffer.get(1));
            reply.putInt(12, this.buffer.getInt(12));
            if (ConnectionHandler.getLogger().finerEnabled()) {
                ConnectionHandler.getLogger().finer("sending reply:" + reply + " " + Command.buffertoString(reply));
            }
        }
        if ((channel = this.socket.getChannel()) == null || !channel.isOpen()) {
            throw new IllegalStateException("cannot write to channel");
        }
        channel.write(reply);
    }

    public void sendException(Exception e) {
        SocketChannel channel = this.socket.getChannel();
        if (channel == null || !channel.isOpen()) {
            throw new IllegalStateException("cannot write to channel");
        }
        try {
            if (e instanceof ClientError) {
                channel.write(charsetASCII.encode(Reply.CLIENT_ERROR.toString()));
            } else {
                channel.write(charsetASCII.encode(Reply.ERROR.toString()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

