/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.internal.memcached.CommandProcessor;
import com.gemstone.gemfire.internal.memcached.KeyWrapper;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.ClientError;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

public abstract class AbstractCommand
implements CommandProcessor {
    protected static final char N = '\n';
    protected static final Charset asciiCharset = Charset.forName("US-ASCII");
    protected static final int POSITION_RESPONSE_STATUS = 6;
    protected static final int POSITION_CAS = 16;
    private final ThreadLocal<CharsetDecoder> asciiDecoder = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return asciiCharset.newDecoder();
        }
    };
    private final ThreadLocal<CharsetEncoder> asciiEncoder = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return asciiCharset.newEncoder();
        }
    };
    private LogWriter logger;
    protected static ThreadLocal<CharBuffer> firstLineBuffer = new ThreadLocal();
    public static final int KEY_LENGTH_INDEX = 2;
    public static final int EXTRAS_LENGTH_INDEX = 4;
    public static final int TOTAL_BODY_LENGTH_INDEX = 8;
    public static final int HEADER_LENGTH = 24;

    @Override
    public abstract ByteBuffer processCommand(RequestReader var1, GemFireMemcachedServer.Protocol var2, Cache var3);

    protected KeyWrapper getKey(ByteBuffer buffer, int keyStartIndex) {
        short keyLength = buffer.getShort(2);
        if (this.getLogger().finerEnabled()) {
            this.getLogger().finer("keyLength:" + keyLength);
        }
        byte[] key2 = new byte[keyLength];
        buffer.position(keyStartIndex);
        buffer.get(key2);
        if (this.getLogger().finerEnabled()) {
            this.getLogger().finer("key:" + Arrays.toString(key2));
        }
        return KeyWrapper.getWrappedKey(key2);
    }

    protected byte[] getValue(ByteBuffer buffer) {
        byte extrasLength = buffer.get(4);
        int totalBodyLength = buffer.getInt(8);
        short keyLength = buffer.getShort(2);
        int valueLength = totalBodyLength - (keyLength + extrasLength);
        byte[] value2 = new byte[valueLength];
        buffer.position(24 + totalBodyLength - valueLength);
        if (this.getLogger().finerEnabled()) {
            this.getLogger().finer("val: totalBody:" + totalBodyLength + " valLen:" + valueLength);
        }
        buffer.get(value2);
        if (this.getLogger().finerEnabled()) {
            this.getLogger().finer("val:" + Arrays.toString(value2) + " totalBody:" + totalBodyLength + " valLen:" + valueLength);
        }
        return value2;
    }

    protected String getFirstLine() {
        CharBuffer buffer = firstLineBuffer.get();
        StringBuilder builder = new StringBuilder();
        try {
            char c = buffer.get();
            while (true) {
                builder.append(c);
                if (c != '\n') {
                    c = buffer.get();
                    continue;
                }
                break;
            }
        }
        catch (BufferUnderflowException e) {
            throw new ClientError("error reading command:" + builder.toString());
        }
        String firstLine = builder.toString();
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("gemcached command:" + firstLine);
        }
        return firstLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Region<Object, ValueWrapper> getMemcachedRegion(Cache cache) {
        Region<Object, ValueWrapper> r = cache.getRegion("gemcached");
        if (r != null) return r;
        Class<AbstractCommand> clazz = AbstractCommand.class;
        synchronized (AbstractCommand.class) {
            r = cache.getRegion("gemcached");
            if (r != null) return r;
            RegionFactory rf = cache.createRegionFactory(RegionShortcut.PARTITION);
            return rf.create("gemcached");
        }
    }

    protected CharBuffer getFirstLineBuffer() {
        CharBuffer buffer = firstLineBuffer.get();
        if (buffer == null) {
            buffer = CharBuffer.allocate(256);
            firstLineBuffer.set(buffer);
        }
        buffer.clear();
        return buffer;
    }

    protected String stripNewline(String str) {
        int indexOfR = str.indexOf("\r");
        if (indexOfR != -1) {
            return str.substring(0, indexOfR);
        }
        return str;
    }

    protected long getLongFromByteArray(byte[] bytes) {
        long value2 = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            value2 = (value2 << 8) + (long)(bytes[i] & 0xFF);
        }
        return value2;
    }

    protected LogWriter getLogger() {
        if (this.logger == null) {
            Cache cache = CacheFactory.getAnyInstance();
            if (cache != null) {
                this.logger = cache.getLogger();
            } else {
                throw new IllegalStateException("Could not initialize logger");
            }
        }
        return this.logger;
    }

    protected CharsetDecoder getAsciiDecoder() {
        return this.asciiDecoder.get();
    }

    protected CharsetEncoder getAsciiEncoder() {
        return this.asciiEncoder.get();
    }

    protected ByteBuffer handleBinaryException(Object key2, RequestReader request, ByteBuffer response, String operation, Exception e) {
        this.getLogger().info("Exception occurred while processing " + operation + " :" + key2, e);
        String errStr = e.getMessage() == null ? "SERVER ERROR" : e.getMessage();
        byte[] errMsg = errStr.getBytes(asciiCharset);
        int responseLength = 24 + errMsg.length;
        if (response.capacity() < responseLength) {
            response = request.getResponse(responseLength);
        }
        response.limit(responseLength);
        response.putShort(6, ResponseStatus.INTERNAL_ERROR.asShort());
        response.putInt(8, errMsg.length);
        response.position(24);
        response.put(errMsg);
        return response;
    }
}

