/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import java.nio.ByteBuffer;

public class AppendCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key2, byte[] value2, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = AppendCommand.getMemcachedRegion(cache);
        ValueWrapper oldValWrapper = r.get(key2);
        String retVal = Reply.NOT_FOUND.toString();
        if (oldValWrapper != null) {
            byte[] appendVal = value2;
            byte[] oldVal = oldValWrapper.getValue();
            byte[] newVal = new byte[oldVal.length + appendVal.length];
            System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
            System.arraycopy(appendVal, 0, newVal, oldVal.length, appendVal.length);
            r.put(key2, ValueWrapper.getWrappedValue(newVal, flags));
            retVal = Reply.STORED.toString();
        }
        return asciiCharset.encode(retVal);
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key2, byte[] value2, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = AppendCommand.getMemcachedRegion(cache);
        try {
            ValueWrapper oldValWrapper = r.get(key2);
            if (oldValWrapper != null) {
                byte[] appendVal = value2;
                byte[] oldVal = oldValWrapper.getValue();
                byte[] newVal = new byte[oldVal.length + appendVal.length];
                System.arraycopy(oldVal, 0, newVal, 0, oldVal.length);
                System.arraycopy(appendVal, 0, newVal, oldVal.length, appendVal.length);
                ValueWrapper val = ValueWrapper.getWrappedValue(newVal, flags);
                try {
                    r.put(key2, val);
                    if (this.isQuiet()) {
                        return null;
                    }
                    response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                    response.putLong(16, val.getVersion());
                }
                catch (Exception e) {
                    response = this.handleBinaryException(key2, request, response, "append", e);
                }
            } else {
                response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key2, request, response, "append", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

