/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.KeyWrapper;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.AbstractCommand;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.TimeUnit;

public class DecrementCommand
extends AbstractCommand {
    private static final int LONG_LENGTH = 8;

    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request.getRequest(), cache);
        }
        return this.processBinaryProtocol(request, cache);
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        ValueWrapper oldValWrapper;
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        assert ("decr".equals(firstLineElements[0]));
        String key2 = firstLineElements[1];
        String decrByStr = this.stripNewline(firstLineElements[2]);
        Long decrBy = Long.parseLong(decrByStr);
        boolean noReply = firstLineElements.length > 3;
        Region<Object, ValueWrapper> r = DecrementCommand.getMemcachedRegion(cache);
        String reply = Reply.NOT_FOUND.toString();
        ByteBuffer newVal = ByteBuffer.allocate(8);
        while ((oldValWrapper = r.get(key2)) != null) {
            newVal.clear();
            byte[] oldVal = oldValWrapper.getValue();
            long oldLong = this.getLongFromByteArray(oldVal);
            long newLong = oldLong - decrBy;
            newVal.putLong(newLong);
            ValueWrapper newValWrapper = ValueWrapper.getWrappedValue(newVal.array(), 0);
            if (!r.replace(key2, oldValWrapper, newValWrapper)) continue;
            reply = newLong + "\r\n";
            break;
        }
        return noReply ? null : asciiCharset.encode(reply);
    }

    private ByteBuffer processBinaryProtocol(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        byte extrasLength = buffer.get(4);
        final KeyWrapper key2 = this.getKey(buffer, 24 + extrasLength);
        long decrBy = buffer.getLong(24);
        long initialVal = buffer.getLong(32);
        int expiration = buffer.getInt(40);
        final Region<Object, ValueWrapper> r = DecrementCommand.getMemcachedRegion(cache);
        ByteBuffer newVal = ByteBuffer.allocate(8);
        boolean notFound = false;
        ValueWrapper newValWrapper = null;
        try {
            ValueWrapper oldValWrapper;
            do {
                if ((oldValWrapper = r.get(key2)) == null) {
                    if (expiration == -1) {
                        notFound = true;
                    } else {
                        newVal.putLong(0, initialVal);
                        newValWrapper = ValueWrapper.getWrappedValue(newVal.array(), 0);
                        r.put(key2, newValWrapper);
                    }
                    break;
                }
                byte[] oldVal = oldValWrapper.getValue();
                long oldLong = this.getLongFromByteArray(oldVal);
                long newLong = oldLong - decrBy;
                if (newLong < 0L) {
                    newLong = 0L;
                }
                newVal.putLong(0, newLong);
            } while (!r.replace(key2, oldValWrapper, newValWrapper = ValueWrapper.getWrappedValue(newVal.array(), 0)));
        }
        catch (Exception e) {
            return this.handleBinaryException(key2, request, request.getResponse(), "decrement", e);
        }
        if (expiration > 0) {
            StorageCommand.getExpiryExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    r.destroy(key2);
                }
            }, (long)expiration, TimeUnit.SECONDS);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("decr:key:" + key2 + " decrBy:" + decrBy + " initVal:" + initialVal + " exp:" + expiration + " notFound:" + notFound);
        }
        ByteBuffer response = null;
        if (notFound) {
            response = request.getResponse();
            response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
        } else {
            if (this.isQuiet()) {
                return null;
            }
            response = request.getResponse(32);
            response.putInt(8, 8);
            response.putLong(24, newVal.getLong(0));
            response.putLong(16, newValWrapper.getVersion());
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

