/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.KeyWrapper;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.AbstractCommand;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class DeleteCommand
extends AbstractCommand {
    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        if (protocol == GemFireMemcachedServer.Protocol.ASCII) {
            return this.processAsciiCommand(request.getRequest(), cache);
        }
        return this.processBinaryCommand(request, cache);
    }

    private ByteBuffer processAsciiCommand(ByteBuffer buffer, Cache cache) {
        CharBuffer flb = this.getFirstLineBuffer();
        this.getAsciiDecoder().reset();
        this.getAsciiDecoder().decode(buffer, flb, false);
        flb.flip();
        String firstLine = this.getFirstLine();
        String[] firstLineElements = firstLine.split(" ");
        assert ("delete".equals(firstLineElements[0]));
        String key2 = this.stripNewline(firstLineElements[1]);
        boolean noReply = firstLineElements.length > 2;
        Region<Object, ValueWrapper> r = DeleteCommand.getMemcachedRegion(cache);
        String reply = null;
        try {
            r.destroy(key2);
            reply = Reply.DELETED.toString();
        }
        catch (EntryNotFoundException e) {
            reply = Reply.NOT_FOUND.toString();
        }
        return noReply ? null : asciiCharset.encode(reply);
    }

    private ByteBuffer processBinaryCommand(RequestReader request, Cache cache) {
        ByteBuffer buffer = request.getRequest();
        ByteBuffer response = request.getResponse();
        KeyWrapper key2 = this.getKey(buffer, 24);
        Region<Object, ValueWrapper> r = DeleteCommand.getMemcachedRegion(cache);
        try {
            r.destroy(key2);
            if (this.isQuiet()) {
                return null;
            }
            response.putShort(6, ResponseStatus.NO_ERROR.asShort());
        }
        catch (EntryNotFoundException e) {
            response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
        }
        catch (Exception e) {
            response = this.handleBinaryException(key2, request, response, "delete", e);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("delete:key:" + key2);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

