/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import java.nio.ByteBuffer;

public class SetCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key2, byte[] value2, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = SetCommand.getMemcachedRegion(cache);
        r.put(key2, ValueWrapper.getWrappedValue(value2, flags));
        return asciiCharset.encode(Reply.STORED.toString());
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key2, byte[] value2, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = SetCommand.getMemcachedRegion(cache);
        ValueWrapper val = ValueWrapper.getWrappedValue(value2, flags);
        boolean success = true;
        try {
            if (cas != 0L) {
                ValueWrapper expected = ValueWrapper.getDummyValue(cas);
                success = r.replace(key2, expected, val);
            } else {
                r.put(key2, val);
            }
            if (this.getLogger().fineEnabled()) {
                this.getLogger().fine("set key:" + key2 + " succedded:" + success);
            }
            if (success) {
                if (this.isQuiet()) {
                    return null;
                }
                response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                response.putLong(16, val.getVersion());
            } else {
                response.putShort(6, ResponseStatus.KEY_EXISTS.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key2, request, response, "set", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

