/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.KeyWrapper;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.AbstractCommand;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.nio.ByteBuffer;

public class TouchCommand
extends AbstractCommand {
    private static final int EXTRAS_LENGTH = 4;

    @Override
    public ByteBuffer processCommand(RequestReader request, GemFireMemcachedServer.Protocol protocol, Cache cache) {
        assert (protocol == GemFireMemcachedServer.Protocol.BINARY);
        int newExpTime = 0;
        ByteBuffer buffer = request.getRequest();
        ByteBuffer response = null;
        byte extrasLength = buffer.get(4);
        buffer.position(24);
        if (extrasLength > 0) {
            assert (extrasLength == 4);
            newExpTime = buffer.getInt();
        }
        KeyWrapper key2 = this.getKey(buffer, 24 + extrasLength);
        if (newExpTime > 0) {
            StorageCommand.rescheduleExpiration(cache, key2, newExpTime);
        }
        if (this.sendValue()) {
            Region<Object, ValueWrapper> r = TouchCommand.getMemcachedRegion(cache);
            ValueWrapper val = null;
            try {
                val = r.get(key2);
            }
            catch (Exception e) {
                return this.handleBinaryException(key2, request, response, "touch", e);
            }
            if (val == null) {
                response = request.getResponse();
                response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
            } else {
                if (this.isQuiet()) {
                    return null;
                }
                byte[] realValue = val.getValue();
                int responseLength = 24 + realValue.length;
                response = request.getResponse(responseLength);
                response.limit(responseLength);
                response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                response.put(4, (byte)4);
                response.putInt(8, 4 + realValue.length);
                response.putLong(16, val.getVersion());
                response.position(24);
                response.putInt(val.getFlags());
                response.put(realValue);
                response.flip();
            }
        }
        return response;
    }

    protected boolean sendValue() {
        return false;
    }

    protected boolean isQuiet() {
        return false;
    }
}

