/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.process.ControlFileWatchdog;
import com.gemstone.gemfire.internal.process.FileControllerParameters;
import com.gemstone.gemfire.internal.process.ProcessController;
import com.gemstone.gemfire.internal.process.UnableToControlProcessException;
import com.gemstone.gemfire.lang.AttachAPINotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public final class FileProcessController
implements ProcessController {
    private static final Logger logger = LogService.getLogger();
    public static final String STATUS_TIMEOUT_PROPERTY = "gemfire.FileProcessController.STATUS_TIMEOUT";
    private final long statusTimeout = Long.getLong("gemfire.FileProcessController.STATUS_TIMEOUT", 60000L);
    private final FileControllerParameters arguments;
    private final int pid;

    public FileProcessController(FileControllerParameters arguments, int pid) {
        if (pid < 1) {
            throw new IllegalArgumentException("Invalid pid '" + pid + "' specified");
        }
        this.pid = pid;
        this.arguments = arguments;
    }

    @Override
    public int getProcessId() {
        return this.pid;
    }

    @Override
    public String status() throws UnableToControlProcessException, IOException, InterruptedException, TimeoutException {
        return this.status(this.arguments.getWorkingDirectory(), this.arguments.getProcessType().getStatusRequestFileName(), this.arguments.getProcessType().getStatusFileName());
    }

    @Override
    public void stop() throws UnableToControlProcessException, IOException {
        this.stop(this.arguments.getWorkingDirectory(), this.arguments.getProcessType().getStopRequestFileName());
    }

    @Override
    public void checkPidSupport() {
        throw new AttachAPINotFoundException(LocalizedStrings.Launcher_ATTACH_API_NOT_FOUND_ERROR_MESSAGE.toLocalizedString());
    }

    private void stop(File workingDir, String stopRequestFileName) throws UnableToControlProcessException, IOException {
        File stopRequestFile = new File(workingDir, stopRequestFileName);
        if (!stopRequestFile.exists()) {
            stopRequestFile.createNewFile();
        }
    }

    private String status(File workingDir, String statusRequestFileName, String statusFileName) throws UnableToControlProcessException, IOException, InterruptedException, TimeoutException {
        final File statusFile = new File(workingDir, statusFileName);
        final AtomicReference statusRef = new AtomicReference();
        ControlFileWatchdog.ControlRequestHandler statusHandler = new ControlFileWatchdog.ControlRequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRequest() throws IOException {
                try (BufferedReader reader = new BufferedReader(new FileReader(statusFile));){
                    StringBuilder lines = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        lines.append(line);
                    }
                    statusRef.set(lines.toString());
                }
            }
        };
        ControlFileWatchdog statusFileWatchdog = new ControlFileWatchdog(workingDir, statusFileName, statusHandler, true);
        statusFileWatchdog.start();
        File statusRequestFile = new File(workingDir, statusRequestFileName);
        if (!statusRequestFile.exists()) {
            statusRequestFile.createNewFile();
        }
        long start = System.currentTimeMillis();
        while (statusFileWatchdog.isAlive()) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() < start + this.statusTimeout) continue;
            TimeoutException te = new TimeoutException("Timed out waiting for process to create " + statusFile);
            try {
                statusFileWatchdog.stop();
            }
            catch (InterruptedException e) {
                logger.info("Interrupted while stopping status file watchdog.", (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.info("Unexpected failure while stopping status file watchdog.", (Throwable)e);
            }
            throw te;
        }
        assert (statusRef.get() != null);
        return (String)statusRef.get();
    }
}

