/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.process.ConnectionFailedException;
import com.gemstone.gemfire.internal.process.MBeanControllerParameters;
import com.gemstone.gemfire.internal.process.MBeanInvocationFailedException;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessController;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.gemfire.internal.process.UnableToControlProcessException;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class MBeanProcessController
implements ProcessController {
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    private final MBeanControllerParameters arguments;
    private final int pid;
    protected JMXConnector jmxc;
    protected MBeanServerConnection server;

    public MBeanProcessController(MBeanControllerParameters arguments, int pid) {
        if (pid < 1) {
            throw new IllegalArgumentException("Invalid pid '" + pid + "' specified");
        }
        this.pid = pid;
        this.arguments = arguments;
    }

    @Override
    public int getProcessId() {
        return this.pid;
    }

    @Override
    public String status() throws UnableToControlProcessException, ConnectionFailedException, IOException, MBeanInvocationFailedException {
        return this.status(this.arguments.getNamePattern(), this.arguments.getPidAttribute(), this.arguments.getStatusMethod(), this.arguments.getAttributes(), this.arguments.getValues());
    }

    @Override
    public void stop() throws UnableToControlProcessException, ConnectionFailedException, IOException, MBeanInvocationFailedException {
        this.stop(this.arguments.getNamePattern(), this.arguments.getPidAttribute(), this.arguments.getStopMethod(), this.arguments.getAttributes(), this.arguments.getValues());
    }

    @Override
    public void checkPidSupport() {
    }

    private void stop(ObjectName namePattern, String pidAttribute, String stopMethod, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException {
        this.invokeOperationOnTargetMBean(namePattern, pidAttribute, stopMethod, attributes, values);
    }

    private String status(ObjectName namePattern, String pidAttribute, String statusMethod, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException {
        return this.invokeOperationOnTargetMBean(namePattern, pidAttribute, statusMethod, attributes, values).toString();
    }

    private Object invokeOperationOnTargetMBean(ObjectName namePattern, String pidAttribute, String methodName, String[] attributes, Object[] values) throws ConnectionFailedException, IOException, MBeanInvocationFailedException {
        ObjectName objectName = namePattern;
        this.connect();
        try {
            QueryExp constraint = this.buildQueryExp(pidAttribute, attributes, values);
            Set<ObjectName> mbeanNames = this.server.queryNames(namePattern, constraint);
            if (mbeanNames.isEmpty()) {
                throw new MBeanInvocationFailedException("Failed to find mbean matching '" + namePattern + "' with attribute '" + pidAttribute + "' of value '" + this.pid + "'");
            }
            if (mbeanNames.size() > 1) {
                throw new MBeanInvocationFailedException("Found more than one mbean matching '" + namePattern + "' with attribute '" + pidAttribute + "' of value '" + this.pid + "'");
            }
            objectName = mbeanNames.iterator().next();
            Object object = this.invoke(objectName, methodName);
            return object;
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + objectName, e);
        }
        catch (MBeanException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + objectName, e);
        }
        catch (ReflectionException e) {
            throw new MBeanInvocationFailedException("Failed to invoke " + methodName + " on " + objectName, e);
        }
        finally {
            this.disconnect();
        }
    }

    private void connect() throws ConnectionFailedException, IOException {
        try {
            JMXServiceURL jmxUrl = this.getJMXServiceURL();
            this.jmxc = JMXConnectorFactory.connect(jmxUrl);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (AttachNotSupportedException e) {
            throw new ConnectionFailedException("Failed to connect to process '" + this.pid + "'", e);
        }
    }

    private void disconnect() {
        this.server = null;
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.jmxc = null;
    }

    boolean checkPidMatches() throws IllegalStateException, IOException, PidUnavailableException {
        RuntimeMXBean proxy = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Runtime", RuntimeMXBean.class);
        int remotePid = ProcessUtils.identifyPid(proxy.getName());
        if (remotePid != this.pid) {
            throw new IllegalStateException("Process has different pid '" + remotePid + "' than expected pid '" + this.pid + "'");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXServiceURL getJMXServiceURL() throws AttachNotSupportedException, IOException {
        String connectorAddress;
        block8: {
            connectorAddress = null;
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(this.pid));
            try {
                Properties agentProps = vm.getAgentProperties();
                connectorAddress = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                if (connectorAddress != null) break block8;
                String javaHome = vm.getSystemProperties().getProperty("java.home");
                String managementAgentPath = javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
                File managementAgent = new File(managementAgentPath);
                if (!managementAgent.exists() && !(managementAgent = new File(managementAgentPath = javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                    throw new IOException("JDK management agent not found");
                }
                managementAgentPath = managementAgent.getCanonicalPath();
                try {
                    vm.loadAgent(managementAgentPath, "com.sun.management.jmxremote");
                }
                catch (AgentLoadException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                catch (AgentInitializationException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                agentProps = vm.getAgentProperties();
                connectorAddress = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
            }
            finally {
                vm.detach();
            }
        }
        if (connectorAddress == null) {
            throw new IOException("Failed to find address to attach to process");
        }
        return new JMXServiceURL(connectorAddress);
    }

    private QueryExp buildQueryExp(String pidAttribute, String[] attributes, Object[] values) {
        QueryExp optionalAttributes = this.buildOptionalQueryExp(attributes, values);
        QueryExp constraint = optionalAttributes != null ? Query.and(optionalAttributes, Query.eq(Query.attr(pidAttribute), Query.value(this.pid))) : Query.eq(Query.attr(pidAttribute), Query.value(this.pid));
        return constraint;
    }

    private QueryExp buildOptionalQueryExp(String[] attributes, Object[] values) {
        QueryExp queryExp = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (values[i] instanceof Boolean) {
                if (queryExp == null) {
                    queryExp = Query.eq(Query.attr(attributes[i]), Query.value((Boolean)values[i]));
                    continue;
                }
                queryExp = Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((Boolean)values[i])));
                continue;
            }
            if (values[i] instanceof Number) {
                if (queryExp == null) {
                    queryExp = Query.eq(Query.attr(attributes[i]), Query.value((Number)values[i]));
                    continue;
                }
                queryExp = Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((Number)values[i])));
                continue;
            }
            if (!(values[i] instanceof String)) continue;
            queryExp = queryExp == null ? Query.eq(Query.attr(attributes[i]), Query.value((String)values[i])) : Query.and(queryExp, Query.eq(Query.attr(attributes[i]), Query.value((String)values[i])));
        }
        return queryExp;
    }

    private Object invoke(ObjectName objectName, String method) throws InstanceNotFoundException, IOException, MBeanException, ReflectionException {
        return this.server.invoke(objectName, method, new Object[0], new String[0]);
    }
}

