/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.process.AttachProcessUtils;
import com.gemstone.gemfire.internal.process.NativeProcessUtils;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;

public final class ProcessUtils {
    private static InternalProcessUtils internal = ProcessUtils.initializeInternalProcessUtils();

    private ProcessUtils() {
    }

    public static int identifyPid() throws PidUnavailableException {
        return ProcessUtils.identifyPid(ManagementFactory.getRuntimeMXBean().getName());
    }

    public static int identifyPid(String name) throws PidUnavailableException {
        try {
            int index2 = name.indexOf("@");
            if (index2 < 0) {
                throw new PidUnavailableException("Unable to parse pid from " + name);
            }
            return Integer.valueOf(name.substring(0, index2));
        }
        catch (NumberFormatException e) {
            throw new PidUnavailableException("Unable to parse pid from " + name, e);
        }
    }

    public static boolean isProcessAlive(int pid) {
        return internal.isProcessAlive(pid);
    }

    public static boolean killProcess(int pid) {
        return internal.killProcess(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readPid(File pidFile) throws IOException {
        int n;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(pidFile));
            n = Integer.parseInt(reader.readLine());
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return n;
    }

    private static InternalProcessUtils initializeInternalProcessUtils() {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            Class.forName("com.sun.tools.attach.VirtualMachineDescriptor");
            return new AttachProcessUtils();
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        try {
            Class.forName("com.gemstone.gemfire.internal.shared.NativeCalls");
            NativeProcessUtils inst = new NativeProcessUtils();
            boolean result = inst.isProcessAlive(ProcessUtils.identifyPid());
            if (result) {
                return inst;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError e) {
        }
        catch (PidUnavailableException e) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new InternalProcessUtils(){

            @Override
            public boolean isProcessAlive(int pid) {
                return false;
            }

            @Override
            public boolean killProcess(int pid) {
                return false;
            }
        };
    }

    static interface InternalProcessUtils {
        public boolean isProcessAlive(int var1);

        public boolean killProcess(int var1);
    }
}

