/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.sequencelog;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.sequencelog.GraphType;
import com.gemstone.gemfire.internal.sequencelog.SequenceLogger;
import com.gemstone.gemfire.internal.sequencelog.SequenceLoggerImpl;
import java.util.regex.Pattern;

public class RegionLogger {
    private static final SequenceLogger GRAPH_LOGGER = SequenceLoggerImpl.getInstance();

    public static void logCreate(String regionName, InternalDistributedMember source) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "create", "created", source, source);
    }

    public static void logGII(String regionName, InternalDistributedMember source, InternalDistributedMember dest, PersistentMemberID persistentMemberID) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "GII", "created", source, dest);
        if (persistentMemberID != null) {
            GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "persist", "persisted", dest, persistentMemberID.diskStoreId);
        }
    }

    public static void logPersistence(String regionName, InternalDistributedMember source, PersistentMemberID disk) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "persist", "persisted", source, disk.diskStoreId);
    }

    public static void logRecovery(String regionName, PersistentMemberID disk, InternalDistributedMember memberId) {
        GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "recover", "created", disk.diskStoreId, memberId);
    }

    public static void logDestroy(String regionName, InternalDistributedMember memberId, PersistentMemberID persistentID, boolean isClose) {
        if (RegionLogger.isEnabled()) {
            Pattern ALL_REGION_KEYS = Pattern.compile(regionName + ".*");
            GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "destroy", "destroyed", memberId, memberId);
            GRAPH_LOGGER.logTransition(GraphType.KEY, ALL_REGION_KEYS, "destroy", "destroyed", memberId, memberId);
            if (!isClose && persistentID != null) {
                GRAPH_LOGGER.logTransition(GraphType.REGION, regionName, "destroy", "destroyed", memberId, persistentID.diskStoreId);
                GRAPH_LOGGER.logTransition(GraphType.KEY, ALL_REGION_KEYS, "destroy", "destroyed", memberId, persistentID.diskStoreId);
            }
        }
    }

    public static boolean isEnabled() {
        return GRAPH_LOGGER.isEnabled(GraphType.REGION);
    }
}

