/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.size.ObjectGraphSizer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class ReflectionObjectSizer
implements ObjectSizer,
Serializable {
    private static final ReflectionObjectSizer INSTANCE = new ReflectionObjectSizer();
    private static final ObjectGraphSizer.ObjectFilter FILTER = new ObjectGraphSizer.ObjectFilter(){

        @Override
        public boolean accept(Object parent, Object object) {
            return !(object instanceof Region) && !(object instanceof Cache) && !(object instanceof PlaceHolderDiskRegion);
        }
    };

    @Override
    public int sizeof(Object o) {
        try {
            return (int)ObjectGraphSizer.size(o, FILTER, false);
        }
        catch (IllegalArgumentException e) {
            throw new InternalGemFireError(e);
        }
        catch (IllegalAccessException e) {
            throw new InternalGemFireError(e);
        }
    }

    public static ReflectionObjectSizer getInstance() {
        return INSTANCE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private ReflectionObjectSizer() {
    }
}

