/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;

public class WellKnownClassSizer {
    private static final int BYTE_ARRAY_OVERHEAD;
    private static final int STRING_OVERHEAD;

    public static int sizeof(Object o) {
        int size2 = 0;
        if (o instanceof byte[]) {
            size2 = BYTE_ARRAY_OVERHEAD + ((byte[])o).length;
        } else if (o instanceof String) {
            size2 = STRING_OVERHEAD + ((String)o).length() * 2;
        } else {
            return 0;
        }
        size2 = (int)ReflectionSingleObjectSizer.roundUpSize(size2);
        return size2;
    }

    static {
        try {
            ReflectionSingleObjectSizer objSizer = new ReflectionSingleObjectSizer();
            BYTE_ARRAY_OVERHEAD = (int)objSizer.sizeof(new byte[0], false);
            STRING_OVERHEAD = (int)(ReflectionSingleObjectSizer.sizeof(String.class) + objSizer.sizeof(new char[0], false));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

