/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.statistics;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.statistics.StatisticId;
import com.gemstone.gemfire.internal.statistics.StatisticNotFoundException;
import com.gemstone.gemfire.internal.statistics.StatisticsNotification;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class MapBasedStatisticsNotification
implements StatisticsNotification {
    private final long millisTimeStamp;
    private final StatisticsNotification.Type type;
    private final Map<StatisticId, Number> stats;

    protected MapBasedStatisticsNotification(long millisTimeStamp, StatisticsNotification.Type type, Map<StatisticId, Number> stats) {
        this.millisTimeStamp = millisTimeStamp;
        this.type = type;
        this.stats = Collections.unmodifiableMap(stats);
    }

    @Override
    public long getTimeStamp() {
        return this.millisTimeStamp;
    }

    @Override
    public StatisticsNotification.Type getType() {
        return this.type;
    }

    @Override
    public Iterator<StatisticId> iterator() {
        return this.stats.keySet().iterator();
    }

    @Override
    public Iterator<StatisticId> iterator(StatisticDescriptor statDesc) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Iterator<StatisticId> iterator(Statistics statistics) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Iterator<StatisticId> iterator(StatisticsType statisticsType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Number getValue(StatisticId statId) throws StatisticNotFoundException {
        Number value2 = this.stats.get(statId);
        if (value2 == null) {
            throw new StatisticNotFoundException(statId.getStatisticDescriptor().getName() + " not found in notification");
        }
        return value2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("millisTimeStamp=").append(this.millisTimeStamp);
        sb.append(", type=").append((Object)this.type);
        sb.append(", stats=").append(this.stats);
        sb.append("}");
        return sb.toString();
    }
}

