/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.statistics;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.StatArchiveWriter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.ManagerLogWriter;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterAppender;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterAppenders;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;
import com.gemstone.gemfire.internal.statistics.ResourceInstance;
import com.gemstone.gemfire.internal.statistics.ResourceType;
import com.gemstone.gemfire.internal.statistics.SampleCollector;
import com.gemstone.gemfire.internal.statistics.SampleHandler;
import com.gemstone.gemfire.internal.statistics.StatArchiveDescriptor;
import com.gemstone.gemfire.internal.statistics.StatArchiveHandlerConfig;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class StatArchiveHandler
implements SampleHandler {
    private static final Logger logger = LogService.getLogger();
    private final StatArchiveHandlerConfig config;
    private final SampleCollector collector;
    private volatile boolean disabledArchiving = false;
    private StatArchiveWriter archiver = null;
    private File archiveDir = null;
    private int mainArchiveId = -1;
    private int archiveId = -1;

    public StatArchiveHandler(StatArchiveHandlerConfig config, SampleCollector sampleCollector) {
        this.config = config;
        this.collector = sampleCollector;
    }

    public void initialize(long nanosTimeStamp) {
        this.changeArchiveFile(false, nanosTimeStamp);
        this.assertInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws GemFireException {
        StatArchiveHandler statArchiveHandler = this;
        synchronized (statArchiveHandler) {
            if (this.archiver != null) {
                this.archiver.close();
            }
        }
    }

    private void handleArchiverException(GemFireException ex) {
        block4: {
            if (this.archiver.getSampleCount() > 0) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter((Writer)sw, true));
                logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.HostStatSampler_STATISTIC_ARCHIVER_SHUTTING_DOWN_BECAUSE__0, sw));
            }
            try {
                this.archiver.close();
            }
            catch (GemFireException ignore) {
                if (this.archiver.getSampleCount() <= 0) break block4;
                logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.HostStatSampler_STATISIC_ARCHIVER_SHUTDOWN_FAILED_BECAUSE__0, ignore.getMessage()));
            }
        }
        if (this.archiver.getSampleCount() == 0 && this.archiveId != -1) {
            --this.archiveId;
        }
        this.archiver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampled(long nanosTimeStamp, List<ResourceInstance> resourceInstances) {
        StatArchiveHandler statArchiveHandler = this;
        synchronized (statArchiveHandler) {
            if (logger.isTraceEnabled(LogMarker.STATISTICS)) {
                logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#sampled resourceInstances={}", resourceInstances);
            }
            if (this.archiver != null) {
                long bytesWritten;
                long byteLimit;
                try {
                    this.archiver.sampled(nanosTimeStamp, resourceInstances);
                    if (this.archiver.getSampleCount() == 1) {
                        logger.info(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_ARCHIVING_STATISTICS_TO__0_, this.archiver.getArchiveName()));
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.warn(LogMarker.STATISTICS, "Use of java.lang.System.nanoTime() resulted in a non-positive timestamp delta. Skipping archival of statistics sample.", (Throwable)e);
                }
                catch (GemFireException ex) {
                    this.handleArchiverException(ex);
                }
                if (this.archiver != null && (byteLimit = this.config.getArchiveFileSizeLimit()) != 0L && (bytesWritten = this.archiver.bytesWritten()) > byteLimit) {
                    try {
                        this.changeArchiveFile(true, nanosTimeStamp);
                    }
                    catch (GemFireIOException ignore) {}
                }
            } else if (!this.config.getArchiveFileName().getPath().equals("")) {
                try {
                    this.changeArchiveFile(true, nanosTimeStamp);
                }
                catch (GemFireIOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    void assertInitialized() {
        if (this.archiver == null && !this.config.getArchiveFileName().getPath().equals("")) {
            throw new IllegalStateException("This " + this + " was not initialized");
        }
    }

    @Override
    public void allocatedResourceType(ResourceType resourceType) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS)) {
            logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#allocatedResourceType resourceType={}", resourceType);
        }
        if (this.archiver != null) {
            try {
                this.archiver.allocatedResourceType(resourceType);
            }
            catch (GemFireException ex) {
                this.handleArchiverException(ex);
            }
        }
    }

    @Override
    public void allocatedResourceInstance(ResourceInstance resourceInstance) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS)) {
            logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#allocatedResourceInstance resourceInstance={}", resourceInstance);
        }
        if (this.archiver != null) {
            try {
                this.archiver.allocatedResourceInstance(resourceInstance);
            }
            catch (GemFireException ex) {
                this.handleArchiverException(ex);
            }
        }
    }

    @Override
    public void destroyedResourceInstance(ResourceInstance resourceInstance) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS)) {
            logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#destroyedResourceInstance resourceInstance={}", resourceInstance);
        }
        if (this.archiver != null) {
            try {
                this.archiver.destroyedResourceInstance(resourceInstance);
            }
            catch (GemFireException ex) {
                this.handleArchiverException(ex);
            }
        }
    }

    public StatArchiveHandlerConfig getStatArchiveHandlerConfig() {
        return this.config;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("config=").append(this.config);
        sb.append(", archiveDir=").append(this.archiveDir);
        sb.append(", mainArchiveId=").append(this.mainArchiveId);
        sb.append(", archiveId=").append(this.archiveId);
        sb.append(", archiver=").append(this.archiver);
        sb.append("}");
        return sb.toString();
    }

    protected void changeArchiveFile(File newFile, long nanosTimeStamp) {
        this.changeArchiveFile(newFile, true, nanosTimeStamp);
    }

    protected boolean isArchiving() {
        return this.archiver != null && this.archiver.bytesWritten() > 0L;
    }

    private void changeArchiveFile(boolean resetHandler, long nanosTimeStamp) {
        this.changeArchiveFile(this.config.getArchiveFileName(), resetHandler, nanosTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeArchiveFile(File newFile, boolean resetHandler, long nanosTimeStamp) {
        StatArchiveHandler statArchiveHandler;
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#changeArchiveFile newFile={}, nanosTimeStamp={}", newFile, nanosTimeStamp);
        }
        StatArchiveWriter newArchiver = null;
        boolean archiveClosed = false;
        if (newFile.getPath().equals("")) {
            if (!this.disabledArchiving) {
                this.disabledArchiving = true;
                logger.info(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_DISABLING_STATISTIC_ARCHIVAL));
            }
        } else {
            this.disabledArchiving = false;
            if (this.config.getArchiveFileSizeLimit() != 0L && this.archiver != null) {
                archiveClosed = true;
                statArchiveHandler = this;
                synchronized (statArchiveHandler) {
                    if (resetHandler) {
                        if (isDebugEnabled_STATISTICS) {
                            logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#changeArchiveFile removing handler");
                        }
                        this.collector.removeSampleHandler(this);
                    }
                    try {
                        this.archiver.close();
                    }
                    catch (GemFireException ignore) {
                        logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_STATISTIC_ARCHIVE_CLOSE_FAILED_BECAUSE__0, ignore.getMessage()));
                    }
                }
            }
            if (newFile.exists()) {
                File oldFile = this.config.getArchiveFileSizeLimit() != 0L ? this.getRollingArchiveName(newFile, archiveClosed) : StatArchiveHandler.getRenameArchiveName(newFile);
                if (!newFile.renameTo(oldFile)) {
                    logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_COULD_NOT_RENAME_0_TO_1, new Object[]{newFile, oldFile}));
                } else {
                    logger.info(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_RENAMED_OLD_EXISTING_ARCHIVE_TO__0_, oldFile));
                }
            } else {
                if (!newFile.getAbsoluteFile().getParentFile().equals(this.archiveDir)) {
                    this.archiveDir = newFile.getAbsoluteFile().getParentFile();
                    if (!this.archiveDir.exists()) {
                        this.archiveDir.mkdirs();
                    }
                }
                if (this.config.getArchiveFileSizeLimit() != 0L) {
                    this.initMainArchiveId(newFile);
                }
            }
            try {
                StatArchiveDescriptor archiveDescriptor = new StatArchiveDescriptor.Builder().setArchiveName(newFile.getPath()).setSystemId(this.config.getSystemId()).setSystemStartTime(this.config.getSystemStartTime()).setSystemDirectoryPath(this.config.getSystemDirectoryPath()).setProductDescription(this.config.getProductDescription()).build();
                newArchiver = new StatArchiveWriter(archiveDescriptor);
                newArchiver.initialize(nanosTimeStamp);
            }
            catch (GemFireIOException ex) {
                logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_COULD_NOT_OPEN_STATISTIC_ARCHIVE_0_CAUSE_1, new Object[]{newFile, ex.getLocalizedMessage()}));
                throw ex;
            }
        }
        statArchiveHandler = this;
        synchronized (statArchiveHandler) {
            if (archiveClosed) {
                if (this.archiver != null) {
                    StatArchiveHandler.removeOldArchives(newFile, this.config.getArchiveDiskSpaceLimit());
                }
            } else {
                if (resetHandler) {
                    if (isDebugEnabled_STATISTICS) {
                        logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#changeArchiveFile removing handler");
                    }
                    this.collector.removeSampleHandler(this);
                }
                if (this.archiver != null) {
                    try {
                        this.archiver.close();
                    }
                    catch (GemFireException ignore) {
                        logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_STATISTIC_ARCHIVE_CLOSE_FAILED_BECAUSE__0, ignore.getMessage()));
                    }
                    StatArchiveHandler.removeOldArchives(newFile, this.config.getArchiveDiskSpaceLimit());
                }
            }
            this.archiver = newArchiver;
            if (resetHandler && newArchiver != null) {
                if (isDebugEnabled_STATISTICS) {
                    logger.trace(LogMarker.STATISTICS, "StatArchiveHandler#changeArchiveFile adding handler");
                }
                this.collector.addSampleHandler(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getRollingArchiveName(File archive, boolean archiveClosed) {
        File marker;
        StringBuffer buf;
        int dotIdx;
        String markerName;
        StringBuffer buf2;
        if (this.mainArchiveId == -1) {
            File logDir;
            this.archiveDir = archive.getAbsoluteFile().getParentFile();
            LogWriterAppender lwa = LogWriterAppenders.getAppender(LogWriterAppenders.Identifier.MAIN);
            boolean mainArchiveIdCalculated = false;
            if (lwa != null && this.archiveDir.equals(logDir = lwa.getLogDir())) {
                this.mainArchiveId = lwa.getMainLogId();
                if (this.mainArchiveId > 1 && lwa.useChildLogging()) {
                    --this.mainArchiveId;
                }
                mainArchiveIdCalculated = true;
            }
            if (!mainArchiveIdCalculated) {
                if (!this.archiveDir.exists()) {
                    this.archiveDir.mkdirs();
                }
                this.mainArchiveId = ManagerLogWriter.calcNextMainId(this.archiveDir, false);
                mainArchiveIdCalculated = true;
            }
            if (this.mainArchiveId == 0) {
                this.mainArchiveId = 1;
            }
            this.archiveId = ManagerLogWriter.calcNextChildId(archive, this.mainArchiveId);
            if (this.archiveId > 0) {
                --this.archiveId;
            }
        }
        File result = null;
        do {
            ++this.archiveId;
            buf2 = new StringBuffer(archive.getPath());
            int insertIdx = buf2.lastIndexOf(".");
            if (insertIdx == -1) {
                buf2.append(ManagerLogWriter.formatId(this.mainArchiveId)).append(ManagerLogWriter.formatId(this.archiveId));
                continue;
            }
            buf2.insert(insertIdx, ManagerLogWriter.formatId(this.archiveId));
            buf2.insert(insertIdx, ManagerLogWriter.formatId(this.mainArchiveId));
        } while ((result = new File(buf2.toString())).exists());
        if (this.archiveId == 1) {
            markerName = archive.getPath();
            dotIdx = markerName.lastIndexOf(".");
            if (dotIdx != -1) {
                markerName = markerName.substring(0, dotIdx);
            }
            buf = new StringBuffer(markerName);
            buf.append(ManagerLogWriter.formatId(this.mainArchiveId)).append(ManagerLogWriter.formatId(0)).append(".marker");
            marker = new File(buf.toString());
            if (!marker.exists() || !marker.delete()) {
                // empty if block
            }
        }
        if (archiveClosed) return result;
        ++this.mainArchiveId;
        this.archiveId = 0;
        markerName = archive.getPath();
        dotIdx = markerName.lastIndexOf(".");
        if (dotIdx != -1) {
            markerName = markerName.substring(0, dotIdx);
        }
        buf = new StringBuffer(markerName);
        buf.append(ManagerLogWriter.formatId(this.mainArchiveId)).append(ManagerLogWriter.formatId(0)).append(".marker");
        marker = new File(buf.toString());
        if (marker.exists()) return result;
        try {
            if (marker.createNewFile()) return result;
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initMainArchiveId(File archive) {
        File logDir;
        if (this.mainArchiveId != -1) {
            return;
        }
        this.archiveDir = archive.getAbsoluteFile().getParentFile();
        LogWriterAppender lwa = LogWriterAppenders.getAppender(LogWriterAppenders.Identifier.MAIN);
        boolean mainArchiveIdCalculated = false;
        if (lwa != null && this.archiveDir.equals(logDir = lwa.getLogDir())) {
            this.mainArchiveId = lwa.getMainLogId();
            mainArchiveIdCalculated = true;
        }
        if (!mainArchiveIdCalculated) {
            if (!this.archiveDir.exists()) {
                this.archiveDir.mkdirs();
            }
            this.mainArchiveId = ManagerLogWriter.calcNextMainId(this.archiveDir, false);
            ++this.mainArchiveId;
            mainArchiveIdCalculated = true;
        }
        if (this.mainArchiveId == 0) {
            this.mainArchiveId = 1;
        }
        this.archiveId = 0;
        String markerName = archive.getPath();
        int dotIdx = markerName.lastIndexOf(".");
        if (dotIdx != -1) {
            markerName = markerName.substring(0, dotIdx);
        }
        StringBuffer buf = new StringBuffer(markerName);
        buf.append(ManagerLogWriter.formatId(this.mainArchiveId)).append(ManagerLogWriter.formatId(0)).append(".marker");
        File marker = new File(buf.toString());
        if (marker.exists()) return;
        try {
            if (marker.createNewFile()) return;
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private static File getRenameArchiveName(File archive) {
        StringBuffer buf;
        File dir = archive.getAbsoluteFile().getParentFile();
        int previousMainId = ManagerLogWriter.calcNextMainId(dir, false);
        if (previousMainId == 0) {
            previousMainId = 1;
        }
        --previousMainId;
        File result = null;
        do {
            ++previousMainId;
            buf = new StringBuffer(archive.getPath());
            int insertIdx = buf.lastIndexOf(".");
            if (insertIdx == -1) {
                buf.append(ManagerLogWriter.formatId(previousMainId)).append(ManagerLogWriter.formatId(1));
                continue;
            }
            buf.insert(insertIdx, ManagerLogWriter.formatId(1));
            buf.insert(insertIdx, ManagerLogWriter.formatId(previousMainId));
        } while ((result = new File(buf.toString())).exists());
        return result;
    }

    private static void removeOldArchives(File archiveFile, long spaceLimit) {
        if (spaceLimit == 0L || archiveFile == null || archiveFile.getPath().equals("")) {
            return;
        }
        File archiveDir = archiveFile.getAbsoluteFile().getParentFile();
        ManagerLogWriter.checkDiskSpace("archive", archiveFile, spaceLimit, archiveDir, StatArchiveHandler.getArchivePattern(archiveFile.getName()), StatArchiveHandler.getOrCreateLogWriter());
    }

    private static InternalLogWriter getOrCreateLogWriter() {
        InternalLogWriter lw = InternalDistributedSystem.getStaticInternalLogWriter();
        if (lw == null) {
            lw = LogWriterLogger.create(logger);
        }
        return lw;
    }

    private static Pattern getArchivePattern(String name) {
        int dashIdx;
        String ext = "";
        int extIdx = name.lastIndexOf(46);
        if (extIdx != -1) {
            ext = "\\Q" + name.substring(extIdx) + "\\E";
            name = name.substring(0, extIdx);
        }
        if ((dashIdx = name.indexOf(45)) != -1) {
            name = name.substring(0, dashIdx);
        }
        name = "\\Q" + name + "\\E" + "-\\d+-\\d+" + ext;
        return Pattern.compile(name);
    }
}

