/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.statistics;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.StatisticDescriptorImpl;
import com.gemstone.gemfire.internal.statistics.MapBasedStatisticsNotification;
import com.gemstone.gemfire.internal.statistics.ResourceInstance;
import com.gemstone.gemfire.internal.statistics.ResourceType;
import com.gemstone.gemfire.internal.statistics.SimpleStatisticId;
import com.gemstone.gemfire.internal.statistics.StatisticId;
import com.gemstone.gemfire.internal.statistics.StatisticsMonitor;
import com.gemstone.gemfire.internal.statistics.StatisticsNotification;
import java.util.HashMap;
import java.util.List;

public final class ValueMonitor
extends StatisticsMonitor {
    private final CopyOnWriteHashSet<Statistics> statistics = new CopyOnWriteHashSet();

    @Override
    public ValueMonitor addStatistic(StatisticId statId) {
        super.addStatistic(statId);
        return this;
    }

    @Override
    public ValueMonitor removeStatistic(StatisticId statId) {
        super.removeStatistic(statId);
        return this;
    }

    public ValueMonitor addStatistics(Statistics statistics) {
        if (statistics == null) {
            throw new NullPointerException("Statistics is null");
        }
        this.statistics.add(statistics);
        return this;
    }

    public ValueMonitor removeStatistics(Statistics statistics) {
        if (statistics == null) {
            throw new NullPointerException("Statistics is null");
        }
        this.statistics.remove(statistics);
        return this;
    }

    @Override
    protected void monitor(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        super.monitor(millisTimeStamp, resourceInstances);
        this.monitorStatistics(millisTimeStamp, resourceInstances);
    }

    protected void monitorStatistics(long millisTimeStamp, List<ResourceInstance> resourceInstances) {
        if (!this.statistics.isEmpty()) {
            HashMap<StatisticId, Number> stats = new HashMap<StatisticId, Number>();
            for (ResourceInstance resource : resourceInstances) {
                if (!this.statistics.contains(resource.getStatistics())) continue;
                ResourceType resourceType = resource.getResourceType();
                StatisticDescriptor[] sds = resourceType.getStatisticDescriptors();
                int[] updatedStats = resource.getUpdatedStats();
                for (int i = 0; i < updatedStats.length; ++i) {
                    int idx = updatedStats[i];
                    StatisticDescriptorImpl sdi = (StatisticDescriptorImpl)sds[idx];
                    SimpleStatisticId statId = new SimpleStatisticId(sdi, resource.getStatistics());
                    long rawbits = resource.getLatestStatValues()[idx];
                    stats.put(statId, sdi.getNumberForRawBits(rawbits));
                }
            }
            if (!stats.isEmpty()) {
                MapBasedStatisticsNotification notification = new MapBasedStatisticsNotification(millisTimeStamp, StatisticsNotification.Type.VALUE_CHANGED, stats);
                this.notifyListeners(notification);
            }
        }
    }

    @Override
    protected StringBuilder appendToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("statistics=").append(this.statistics);
        return sb;
    }

    public static enum Type {
        CHANGE,
        MATCH,
        DIFFER;

    }
}

