/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream
implements DataInput,
Externalizable {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public ByteBufferInputStream() {
    }

    protected ByteBufferInputStream(ByteBufferInputStream copy) {
        this.buffer = copy.buffer.duplicate();
    }

    public final void setBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this.buffer = buffer;
    }

    @Override
    public final int read() {
        return this.buffer.get() & 0xFF;
    }

    @Override
    public final int read(byte[] b, int off, int len) {
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    public int position() {
        return this.buffer.position();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int limit) {
        this.buffer.mark();
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= Integer.MAX_VALUE) {
            return this.skipBytes((int)n);
        }
        return super.skip(n);
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.get() != 0;
    }

    public boolean readBoolean(int pos) {
        return this.buffer.get(pos) != 0;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    public byte readByte(int pos) {
        return this.buffer.get(pos);
    }

    @Override
    public char readChar() {
        return this.buffer.getChar();
    }

    public char readChar(int pos) {
        return this.buffer.getChar(pos);
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    public double readDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    public float readFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    @Override
    public void readFully(byte[] b) {
        this.buffer.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this.buffer.get(b, off, len);
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    public int readInt(int pos) {
        return this.buffer.getInt(pos);
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    public long readLong(int pos) {
        return this.buffer.getLong(pos);
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    public short readShort(int pos) {
        return this.buffer.getShort(pos);
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.get() & 0xFF;
    }

    public int readUnsignedByte(int pos) {
        return this.buffer.get(pos) & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public int readUnsignedShort(int pos) {
        return this.buffer.getShort(pos) & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) {
        int newPosition = this.buffer.position() + n;
        if (newPosition > this.buffer.limit()) {
            newPosition = this.buffer.limit();
            n = newPosition - this.buffer.position();
        }
        this.buffer.position(newPosition);
        return n;
    }

    public int size() {
        return this.buffer.limit();
    }

    public byte get(int idx) {
        return this.buffer.get(idx);
    }

    public short getShort(int idx) {
        return this.buffer.getShort(idx);
    }

    public int getInt(int idx) {
        return this.buffer.getInt(idx);
    }

    public void position(int absPos) {
        this.buffer.position(absPos);
    }

    public void sendTo(DataOutput out) throws IOException {
        int offset;
        byte[] bytes;
        int len = this.size();
        if (this.buffer.hasArray()) {
            bytes = this.buffer.array();
            offset = this.buffer.arrayOffset();
        } else {
            this.buffer.position(0);
            bytes = new byte[len];
            offset = 0;
            this.buffer.get(bytes);
        }
        out.write(bytes, offset, len);
    }

    public void sendTo(ByteBuffer out) {
        this.buffer.position(0);
        out.put(this.buffer);
    }

    public ByteBuffer slice() {
        return this.buffer.slice();
    }

    public ByteBuffer slice(int startOffset, int endOffset) {
        ByteBuffer bb = this.buffer.duplicate();
        bb.position(startOffset);
        bb.limit(endOffset);
        return bb.slice();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            out.writeInt(this.buffer.capacity());
            out.writeInt(this.buffer.limit());
            out.writeInt(this.buffer.position());
            for (int i = 0; i < this.buffer.capacity(); ++i) {
                out.write(this.buffer.get(i));
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasBuffer = in.readBoolean();
        if (hasBuffer) {
            int capacity = in.readInt();
            int limit = in.readInt();
            int position = in.readInt();
            byte[] bytes = new byte[capacity];
            int bytesRead = in.read(bytes);
            if (bytesRead != capacity) {
                throw new IOException("Expected to read " + capacity + " bytes but only read " + bytesRead + " bytes.");
            }
            this.buffer = ByteBuffer.wrap(bytes, position, limit - position);
        } else {
            this.buffer = null;
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

