/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.tcp.Connection;
import com.gemstone.gemfire.internal.tcp.ConnectionException;
import com.gemstone.gemfire.internal.tcp.ReenteredConnectException;
import com.gemstone.gemfire.internal.tcp.Stub;
import com.gemstone.gemfire.internal.tcp.TCPConduit;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public class ConnectionTable {
    private static final Logger logger = LogService.getLogger();
    private static boolean ulimitWarningIssued;
    private static ThreadLocal threadWantsOwnResources;
    protected final Map orderedConnectionMap = new ConcurrentHashMap();
    private final ThreadLocal threadOrderedConnMap;
    private final List threadConnMaps;
    private SystemTimer idleConnTimer;
    private ConcurrentMap threadConnectionMap;
    protected final Map unorderedConnectionMap = new ConcurrentHashMap();
    private final List receivers = new ArrayList();
    protected final TCPConduit owner;
    private volatile boolean closed = false;
    private static final AtomicReference lastInstance;
    private Map connectingSockets = new HashMap();

    public static void threadWantsSharedResources() {
        threadWantsOwnResources.set(Boolean.FALSE);
    }

    public static void threadWantsOwnResources() {
        threadWantsOwnResources.set(Boolean.TRUE);
    }

    boolean threadOwnsResources() {
        DM d = this.getDM();
        if (d != null) {
            return d.getSystem().threadOwnsResources() && !AlertAppender.isThreadAlerting();
        }
        return false;
    }

    public static Boolean getThreadOwnsResourcesRegistration() {
        return (Boolean)threadWantsOwnResources.get();
    }

    private ConnectionTable(TCPConduit c) throws IOException {
        this.owner = c;
        this.idleConnTimer = this.owner.idleConnectionTimeout != 0 ? new SystemTimer(c.getDM().getSystem(), true) : null;
        this.threadOrderedConnMap = new ThreadLocal();
        this.threadConnMaps = new ArrayList();
        this.threadConnectionMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptConnection(Socket sock) throws IOException, ConnectionException {
        Object connection = null;
        InetAddress connAddress = sock.getInetAddress();
        boolean finishedConnecting = false;
        Connection conn = null;
        try {
            conn = Connection.createReceiver(this, sock);
            this.owner.getCancelCriterion().checkCancelInProgress(null);
            finishedConnecting = true;
        }
        catch (IOException ex) {
            this.owner.getCancelCriterion().checkCancelInProgress(ex);
            logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectionTable_FAILED_TO_ACCEPT_CONNECTION_FROM_0_BECAUSE_1, new Object[]{connAddress != null ? connAddress : "unavailable address", ex}));
            throw ex;
        }
        catch (ConnectionException ex) {
            this.owner.getCancelCriterion().checkCancelInProgress(ex);
            logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectionTable_FAILED_TO_ACCEPT_CONNECTION_FROM_0_BECAUSE_1, new Object[]{connAddress != null ? connAddress : "unavailable address", ex}));
            throw ex;
        }
        finally {
            if (conn != null && !finishedConnecting) {
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CANCEL_AFTER_ACCEPT.toLocalizedString(), conn);
                conn = null;
            }
        }
        if (conn != null) {
            List list = this.receivers;
            synchronized (list) {
                this.owner.stats.incReceivers();
                if (this.closed) {
                    ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_NO_LONGER_IN_USE.toLocalizedString(), conn);
                    return;
                }
                this.receivers.add(conn);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Accepted {} myAddr={} theirAddr={}", conn, this.getConduit().getLocalAddress(), conn.remoteAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection handleNewPendingConnection(Stub id, boolean sharedResource, boolean preserveOrder, Map m, PendingConnection pc, long startTime, long ackThreshold, long ackSAThreshold) throws IOException, DistributedSystemDisconnectedException {
        Map map;
        Connection con = null;
        try {
            con = Connection.createSender(this.owner.getMembershipManager(), this, preserveOrder, id, this.owner.getMemberForStub(id, false), sharedResource, startTime, ackThreshold, ackSAThreshold);
            this.owner.stats.incSenders(sharedResource, preserveOrder);
        }
        finally {
            if (con == null) {
                this.owner.stats.incFailedConnect();
                map = m;
                synchronized (map) {
                    Object rmObj = m.remove(id);
                    if (rmObj != pc && rmObj != null) {
                        m.put(id, rmObj);
                    }
                }
                pc.notifyWaiters(null);
            }
        }
        map = m;
        synchronized (map) {
            Object e = m.get(id);
            if (e == pc) {
                m.put(id, con);
            } else if (e == null) {
                con.requestClose(LocalizedStrings.ConnectionTable_PENDING_CONNECTION_CANCELLED.toLocalizedString());
                con = null;
            } else if (e instanceof Connection) {
                Connection newCon = (Connection)e;
                if (!newCon.connected) {
                    if (con != null) {
                        con.requestClose(LocalizedStrings.ConnectionTable_PENDING_CONNECTION_CLOSED.toLocalizedString());
                        con = null;
                    }
                } else {
                    if (con != null) {
                        con.requestClose(LocalizedStrings.ConnectionTable_SOMEONE_ELSE_CREATED_THE_CONNECTION.toLocalizedString());
                    }
                    con = newCon;
                }
            }
        }
        pc.notifyWaiters(con);
        if (con != null && logger.isDebugEnabled()) {
            logger.debug("handleNewPendingConnection {} myAddr={} theirAddr={}", con, this.getConduit().getLocalAddress(), con.remoteAddr);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getUnorderedOrConserveSockets(Stub id, boolean threadOwnsResources, boolean preserveOrder, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        Connection result = null;
        Map m = preserveOrder ? this.orderedConnectionMap : this.unorderedConnectionMap;
        PendingConnection pc = null;
        Object mEntry = null;
        Map map = m;
        synchronized (map) {
            mEntry = m.get(id);
            if (mEntry != null && mEntry instanceof Connection) {
                Connection existingCon = mEntry;
                if (!existingCon.connected) {
                    mEntry = null;
                }
            }
            if (mEntry == null) {
                pc = new PendingConnection(preserveOrder, id);
                m.put(id, pc);
            }
        }
        if (pc != null) {
            result = this.handleNewPendingConnection(id, true, preserveOrder, m, pc, startTime, ackTimeout, ackSATimeout);
            if (!preserveOrder && threadOwnsResources) {
                this.scheduleIdleTimeout(result);
            }
        } else if (mEntry instanceof PendingConnection) {
            result = ((PendingConnection)mEntry).waitForConnect(this.owner.getMembershipManager(), startTime, ackTimeout, ackSATimeout);
            if (logger.isDebugEnabled()) {
                if (result != null) {
                    logger.debug("getUnorderedOrConserveSockets {} myAddr={} theirAddr={}", result, this.getConduit().getLocalAddress(), result.remoteAddr);
                } else {
                    logger.debug("getUnorderedOrConserveSockets: Connect failed");
                }
            }
        } else {
            result = mEntry;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getOrderedAndOwned(Stub id, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        ArrayList o;
        Object object;
        Connection result = null;
        HashMap<Stub, Connection> m = (HashMap<Stub, Connection>)this.threadOrderedConnMap.get();
        if (m == null) {
            m = new HashMap<Stub, Connection>();
            object = this.threadConnMaps;
            synchronized (object) {
                if (this.closed) {
                    this.owner.getCancelCriterion().checkCancelInProgress(null);
                    throw new DistributedSystemDisconnectedException(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_IS_CLOSED.toLocalizedString());
                }
                Iterator it = this.threadConnMaps.iterator();
                while (it.hasNext()) {
                    Reference r = (Reference)it.next();
                    if (r.get() != null) continue;
                    it.remove();
                }
                this.threadConnMaps.add(new WeakReference(m));
            }
            this.threadOrderedConnMap.set(m);
        } else {
            object = m;
            synchronized (object) {
                result = (Connection)m.get(id);
            }
            if (result != null && result.timedOut) {
                result = null;
            }
        }
        if (result != null) {
            return result;
        }
        result = Connection.createSender(this.owner.getMembershipManager(), this, true, id, this.owner.getMemberForStub(id, false), false, startTime, ackTimeout, ackSATimeout);
        if (logger.isDebugEnabled()) {
            logger.debug("ConnectionTable: created an ordered connection: {}", result);
        }
        this.owner.stats.incSenders(false, true);
        if (this.threadConnectionMap == null) {
            ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), result);
            return null;
        }
        ArrayList<Connection> al = (ArrayList<Connection>)this.threadConnectionMap.get(id);
        if (al == null && (o = this.threadConnectionMap.putIfAbsent(id, al = new ArrayList<Connection>())) != null) {
            al = o;
        }
        Cloneable cloneable = al;
        synchronized (cloneable) {
            al.add(result);
        }
        cloneable = m;
        synchronized (cloneable) {
            m.put(id, result);
        }
        this.scheduleIdleTimeout(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIdleTimeout(Connection conn) {
        if (conn == null) {
            return;
        }
        if (this.owner.idleConnectionTimeout != 0) {
            try {
                ConnectionTable connectionTable = this;
                synchronized (connectionTable) {
                    if (!this.closed) {
                        IdleConnTT task = new IdleConnTT(conn);
                        conn.setIdleTimeoutTask(task);
                        this.getIdleConnTimer().scheduleAtFixedRate(task, this.owner.idleConnectionTimeout, this.owner.idleConnectionTimeout);
                    }
                }
            }
            catch (IllegalStateException e) {
                if (conn.isClosing()) {
                    return;
                }
                logger.debug("Got an illegal state exception: {}", e.getMessage(), e);
                this.owner.getCancelCriterion().checkCancelInProgress(null);
                Exception cause = this.owner.getShutdownCause();
                if (cause == null) {
                    cause = e;
                }
                throw new DistributedSystemDisconnectedException(LocalizedStrings.ConnectionTable_THE_DISTRIBUTED_SYSTEM_IS_SHUTTING_DOWN.toLocalizedString(), cause);
            }
        }
    }

    protected Connection get(Stub id, boolean preserveOrder, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        if (this.closed) {
            this.owner.getCancelCriterion().checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_IS_CLOSED.toLocalizedString());
        }
        Connection result = null;
        boolean threadOwnsResources = this.threadOwnsResources();
        result = !preserveOrder || !threadOwnsResources ? this.getUnorderedOrConserveSockets(id, threadOwnsResources, preserveOrder, startTime, ackTimeout, ackSATimeout) : this.getOrderedAndOwned(id, startTime, ackTimeout, ackSATimeout);
        if (result != null) {
            Assert.assertTrue(result.preserveOrder == preserveOrder);
        }
        return result;
    }

    protected synchronized void fileDescriptorsExhausted() {
        if (!ulimitWarningIssued) {
            ulimitWarningIssued = true;
            logger.fatal(LocalizedMessage.create(LocalizedStrings.ConnectionTable_OUT_OF_FILE_DESCRIPTORS_USING_SHARED_CONNECTION));
            InternalDistributedSystem.getAnyInstance().setShareSockets(true);
            threadWantsOwnResources = new ThreadLocal();
        }
    }

    protected final TCPConduit getConduit() {
        return this.owner;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static void closeCon(String reason, Object c) {
        ConnectionTable.closeCon(reason, c, false);
    }

    private static void closeCon(String reason, Object c, boolean beingSick) {
        if (c == null) {
            return;
        }
        if (c instanceof Connection) {
            ((Connection)c).closePartialConnect(reason, beingSick);
        } else {
            ((PendingConnection)c).notifyWaiters(null);
        }
    }

    protected synchronized SystemTimer getIdleConnTimer() {
        if (this.closed) {
            return null;
        }
        if (this.idleConnTimer == null) {
            this.idleConnTimer = new SystemTimer(this.getDM().getSystem(), true);
        }
        return this.idleConnTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Iterator<Object> it;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Object object = this;
        synchronized (object) {
            if (this.idleConnTimer != null) {
                this.idleConnTimer.cancel();
            }
        }
        object = this.orderedConnectionMap;
        synchronized (object) {
            it = this.orderedConnectionMap.values().iterator();
            while (it.hasNext()) {
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), it.next());
            }
            this.orderedConnectionMap.clear();
        }
        object = this.unorderedConnectionMap;
        synchronized (object) {
            it = this.unorderedConnectionMap.values().iterator();
            while (it.hasNext()) {
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), it.next());
            }
            this.unorderedConnectionMap.clear();
        }
        if (this.threadConnectionMap != null) {
            this.threadConnectionMap = null;
        }
        if (this.threadConnMaps != null) {
            object = this.threadConnMaps;
            synchronized (object) {
                for (Reference r : this.threadConnMaps) {
                    Map m = (Map)r.get();
                    if (m == null) continue;
                    Map map = m;
                    synchronized (map) {
                        Iterator mit = m.values().iterator();
                        while (mit.hasNext()) {
                            ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), mit.next());
                        }
                    }
                }
                this.threadConnMaps.clear();
            }
        }
        this.closeReceivers(false);
        Map m = (Map)this.threadOrderedConnMap.get();
        if (m != null) {
            Map map = m;
            synchronized (map) {
                m.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeReceivers(boolean beingSick) {
        List list = this.receivers;
        synchronized (list) {
            Iterator it = this.receivers.iterator();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                if (beingSick && !con.preserveOrder) continue;
                ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_CONNECTION_TABLE_BEING_DESTROYED.toLocalizedString(), con, beingSick);
                it.remove();
            }
            SocketCreator sc = SocketCreator.getDefaultInstance();
            Map map = this.connectingSockets;
            synchronized (map) {
                Iterator it2 = this.connectingSockets.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = it2.next();
                    try {
                        ((Socket)entry.getKey()).close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    it2.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReceiver(Object con) {
        List list = this.receivers;
        synchronized (list) {
            this.receivers.remove(con);
        }
    }

    protected boolean isEndpointShuttingDown(Stub stub) {
        return this.owner.getMemberForStub(stub, true) == null;
    }

    protected void removeEndpoint(Stub stub, String reason) {
        this.removeEndpoint(stub, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEndpoint(Stub stub, String reason, boolean notifyDisconnect) {
        Object al;
        Map cm;
        if (this.closed) {
            return;
        }
        boolean needsRemoval = false;
        Map map = this.orderedConnectionMap;
        synchronized (map) {
            if (this.orderedConnectionMap.get(stub) != null) {
                needsRemoval = true;
            }
        }
        if (!needsRemoval) {
            map = this.unorderedConnectionMap;
            synchronized (map) {
                if (this.unorderedConnectionMap.get(stub) != null) {
                    needsRemoval = true;
                }
            }
        }
        if (!needsRemoval && (cm = this.threadConnectionMap) != null) {
            al = (ArrayList)cm.get(stub);
            boolean bl = needsRemoval = al != null && ((ArrayList)al).size() > 0;
        }
        if (needsRemoval) {
            cm = this.orderedConnectionMap;
            synchronized (cm) {
                ConnectionTable.closeCon(reason, this.orderedConnectionMap.remove(stub));
            }
            cm = this.unorderedConnectionMap;
            synchronized (cm) {
                ConnectionTable.closeCon(reason, this.unorderedConnectionMap.remove(stub));
            }
            cm = this.threadConnectionMap;
            if (cm != null && (al = (ArrayList)cm.remove(stub)) != null) {
                ArrayList arrayList = al;
                synchronized (arrayList) {
                    Iterator it2 = ((ArrayList)al).iterator();
                    while (it2.hasNext()) {
                        ConnectionTable.closeCon(reason, it2.next());
                    }
                    ((ArrayList)al).clear();
                }
            }
            HashSet<Object> toRemove = new HashSet<Object>();
            al = this.connectingSockets;
            synchronized (al) {
                Iterator iterator = this.connectingSockets.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ConnectingSocketInfo info = (ConnectingSocketInfo)entry.getValue();
                    if (!info.peerAddress.equals(stub.getInetAddress())) continue;
                    toRemove.add(entry.getKey());
                    iterator.remove();
                }
            }
            for (Socket socket : toRemove) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("caught exception while trying to close connecting socket for {}", stub, e);
                }
            }
            toRemove.clear();
            List it3 = this.receivers;
            synchronized (it3) {
                Iterator iterator = this.receivers.iterator();
                while (iterator.hasNext()) {
                    Connection con = (Connection)iterator.next();
                    if (!stub.equals(con.getRemoteId())) continue;
                    iterator.remove();
                    toRemove.add(con);
                }
            }
            for (Connection connection : toRemove) {
                ConnectionTable.closeCon(reason, connection);
            }
            if (notifyDisconnect) {
                this.owner.getMemberForStub(stub, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasReceiversFor(Stub endPoint) {
        List list = this.receivers;
        synchronized (list) {
            for (Connection con : this.receivers) {
                if (!endPoint.equals(con.getRemoteId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromThreadConMap(ConcurrentMap cm, Stub stub, Connection c) {
        ArrayList al;
        if (cm != null && (al = (ArrayList)cm.get(stub)) != null) {
            ArrayList arrayList = al;
            synchronized (arrayList) {
                al.remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThreadConnection(Stub stub, Connection c) {
        ConnectionTable.removeFromThreadConMap(this.threadConnectionMap, stub, c);
        Map m = (Map)this.threadOrderedConnMap.get();
        if (m != null) {
            Map map = m;
            synchronized (map) {
                if (m.get(stub) == c) {
                    m.remove(stub);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSharedConnection(String reason, Stub stub, boolean ordered, Connection c) {
        if (this.closed) {
            return;
        }
        if (ordered) {
            Map map = this.orderedConnectionMap;
            synchronized (map) {
                if (this.orderedConnectionMap.get(stub) == c) {
                    ConnectionTable.closeCon(reason, this.orderedConnectionMap.remove(stub));
                }
            }
        }
        Map map = this.unorderedConnectionMap;
        synchronized (map) {
            if (this.unorderedConnectionMap.get(stub) == c) {
                ConnectionTable.closeCon(reason, this.unorderedConnectionMap.remove(stub));
            }
        }
    }

    public static void loadEmergencyClasses() {
    }

    public static void emergencyClose() {
        ConnectionTable ct = (ConnectionTable)lastInstance.get();
        if (ct == null) {
            return;
        }
        lastInstance.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndCloseThreadOwnedSockets() {
        Map m = (Map)this.threadOrderedConnMap.get();
        if (m != null) {
            Map map = m;
            synchronized (map) {
                Iterator it = m.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    Stub stub = (Stub)me.getKey();
                    Connection c = (Connection)me.getValue();
                    ConnectionTable.removeFromThreadConMap(this.threadConnectionMap, stub, c);
                    it.remove();
                    ConnectionTable.closeCon(LocalizedStrings.ConnectionTable_THREAD_FINALIZATION.toLocalizedString(), c);
                }
            }
        }
    }

    public static void releaseThreadsSockets() {
        ConnectionTable ct = (ConnectionTable)lastInstance.get();
        if (ct == null) {
            return;
        }
        ct.removeAndCloseThreadOwnedSockets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getThreadOwnedOrderedConnectionState(Stub member, HashMap result) {
        ArrayList al;
        ConcurrentMap cm = this.threadConnectionMap;
        if (cm != null && (al = (ArrayList)cm.get(member)) != null) {
            ArrayList arrayList = al;
            synchronized (arrayList) {
                al = new ArrayList(al);
            }
            for (Connection conn : al) {
                if (conn.isSharedResource() || !conn.getOriginatedHere() || !conn.getPreserveOrder()) continue;
                result.put(conn.getUniqueId(), conn.getMessagesSent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForThreadOwnedOrderedConnectionState(Stub member, HashMap connectionStates) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        ArrayList r = null;
        List list = this.receivers;
        synchronized (list) {
            r = new ArrayList(this.receivers);
        }
        for (Connection con : r) {
            Long state;
            if (con.stopped || con.isClosing() || con.getOriginatedHere() || !con.getPreserveOrder() || !member.equals(con.getRemoteId()) || (state = (Long)connectionStates.remove(con.getUniqueId())) == null) continue;
            long count = state;
            while (!con.stopped && !con.isClosing() && con.getMessagesReceived() < count) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for connection {}/{} currently={} need={}", con.getRemoteId(), con.getUniqueId(), con.getMessagesReceived(), count);
                }
                Thread.sleep(100L);
            }
        }
        if (connectionStates.size() > 0 && logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(1000);
            sb.append("These connections from ");
            sb.append(member);
            sb.append("could not be located during waitForThreadOwnedOrderedConnectionState: ");
            Iterator it = connectionStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append('(').append(entry.getValue()).append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            logger.debug(sb);
        }
    }

    protected DM getDM() {
        return this.owner.getDM();
    }

    public static ConnectionTable create(TCPConduit conduit) throws IOException {
        ConnectionTable ct = new ConnectionTable(conduit);
        lastInstance.set(ct);
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectingSocket(Socket socket, InetAddress addr) {
        Map map = this.connectingSockets;
        synchronized (map) {
            this.connectingSockets.put(socket, new ConnectingSocketInfo(addr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectingSocket(Socket socket) {
        Map map = this.connectingSockets;
        synchronized (map) {
            this.connectingSockets.remove(socket);
        }
    }

    static {
        threadWantsOwnResources = new ThreadLocal();
        lastInstance = new AtomicReference();
    }

    private static class ConnectingSocketInfo {
        InetAddress peerAddress;
        Thread connectingThread;

        public ConnectingSocketInfo(InetAddress addr) {
            this.peerAddress = addr;
            this.connectingThread = Thread.currentThread();
        }
    }

    private static class IdleConnTT
    extends SystemTimer.SystemTimerTask {
        private Connection c;

        IdleConnTT(Connection c) {
            this.c = c;
        }

        @Override
        public boolean cancel() {
            this.c = null;
            return super.cancel();
        }

        @Override
        public void run2() {
            Connection con = this.c;
            if (con != null && con.checkForIdleTimeout()) {
                this.cancel();
            }
        }
    }

    private class PendingConnection {
        private boolean pending = true;
        private Connection conn = null;
        private final boolean preserveOrder;
        private final Stub id;
        private final Thread connectingThread;

        public PendingConnection(boolean preserveOrder, Stub id) {
            this.preserveOrder = preserveOrder;
            this.id = id;
            this.connectingThread = Thread.currentThread();
        }

        public synchronized void notifyWaiters(Connection c) {
            if (!this.pending) {
                return;
            }
            this.conn = c;
            this.pending = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying waiters that pending {} connection to {} is ready; {}", this.preserveOrder ? "ordered" : "unordered", this.id, this);
            }
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Connection waitForConnect(MembershipManager mgr, long startTime, long ackTimeout, long ackSATimeout) throws IOException {
            if (this.connectingThread == Thread.currentThread()) {
                throw new ReenteredConnectException("This thread is already trying to connect");
            }
            Map m = this.preserveOrder ? ConnectionTable.this.orderedConnectionMap : ConnectionTable.this.unorderedConnectionMap;
            boolean severeAlertIssued = false;
            boolean suspected = false;
            InternalDistributedMember targetMember = null;
            if (ackSATimeout > 0L) {
                targetMember = ((JGroupMembershipManager)mgr).getMemberForStub(this.id, false);
            }
            while (this.pending) {
                Object e;
                ConnectionTable.this.getConduit().getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException ignore) {
                    interrupted = true;
                    ConnectionTable.this.getConduit().getCancelCriterion().checkCancelInProgress(ignore);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!this.pending) break;
                long now = System.currentTimeMillis();
                if (!severeAlertIssued && ackSATimeout > 0L && startTime + ackTimeout < now) {
                    if (startTime + ackTimeout + ackSATimeout < now) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.ConnectionTable_UNABLE_TO_FORM_A_TCPIP_CONNECTION_TO_0_IN_OVER_1_SECONDS, new Object[]{targetMember, (ackSATimeout + ackTimeout) / 1000L}));
                        severeAlertIssued = true;
                    } else if (!suspected) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.ConnectionTable_UNABLE_TO_FORM_A_TCPIP_CONNECTION_TO_0_IN_OVER_1_SECONDS, new Object[]{this.id, ackTimeout / 1000L}));
                        ((JGroupMembershipManager)mgr).suspectMember(targetMember, "Unable to form a TCP/IP connection in a reasonable amount of time");
                        suspected = true;
                    }
                }
                if ((e = m.get(this.id)) == this) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Waiting for pending connection to complete: {} connection to {}; {}", this.preserveOrder ? "ordered" : "unordered", this.id, this);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Pending connection changed to {} unexpectedly", e);
                }
                if (e == null) {
                    this.notifyWaiters(null);
                    break;
                }
                if (e instanceof Connection) {
                    this.notifyWaiters((Connection)e);
                    break;
                }
                return ((PendingConnection)e).waitForConnect(mgr, startTime, ackTimeout, ackSATimeout);
            }
            return this.conn;
        }
    }
}

