/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;

public class Stub
implements Externalizable,
DataSerializable {
    private InetAddress inAddr;
    private int port;
    private int viewID;

    public Stub() {
    }

    public Stub(InetAddress addr, int port, int vmViewID) {
        this.viewID = vmViewID;
        this.inAddr = addr;
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Stub) {
            Stub s = (Stub)o;
            boolean result = this.inAddr == null ? s.inAddr == null : this.inAddr.equals(s.inAddr);
            boolean bl = result = result && this.port == s.port;
            if (this.viewID != 0 && s.viewID != 0) {
                result = result && this.viewID == s.viewID;
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        return result += this.port;
    }

    public void setViewID(int viewID) {
        this.viewID = viewID;
    }

    public int getPort() {
        return this.port;
    }

    public int getViewID() {
        return this.viewID;
    }

    public InetAddress getInetAddress() {
        return this.inAddr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("tcp://");
        if (this.inAddr == null) {
            sb.append("<null>");
        } else {
            sb.append(this.inAddr.toString());
        }
        if (this.viewID != 0) {
            sb.append("<v" + this.viewID + ">");
        }
        sb.append(":" + this.port);
        return sb.toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeInetAddress(this.inAddr, out);
        out.writeInt(this.port);
        out.writeInt(this.viewID);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.inAddr = DataSerializer.readInetAddress(in);
        this.port = in.readInt();
        this.viewID = in.readInt();
    }

    public static Stub createFromData(DataInput in) throws IOException, ClassNotFoundException {
        Stub result = new Stub();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.toData(os);
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        this.fromData(is);
    }
}

