/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.LonerDistributionManager;
import com.gemstone.gemfire.distributed.internal.direct.DirectChannel;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.tcp.Connection;
import com.gemstone.gemfire.internal.tcp.ConnectionException;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import com.gemstone.gemfire.internal.tcp.Stub;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.Logger;

public class TCPConduit
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private static int LISTENER_CLOSE_TIMEOUT;
    private static int BACKLOG;
    static boolean useSSL;
    private static boolean USE_NIO;
    static boolean useDirectBuffers;
    private volatile boolean inhibitNewConnections;
    private MembershipManager membershipManager;
    private boolean useNIO;
    public int tcpBufferSize = 32768;
    public int idleConnectionTimeout = 60000;
    private int port;
    private int[] tcpPortRange = new int[]{1024, 65535};
    private InternalDistributedMember localAddr;
    private final InetAddress address;
    private final boolean isBindAddress;
    private final DirectChannel directChannel;
    DMStats stats;
    DistributionConfig config;
    private Stub id;
    protected volatile boolean stopped;
    private Thread thread;
    private ServerSocketChannel channel;
    private ServerSocket socket;
    private ConnectionTable conTable;
    private ThreadPoolExecutor hsPool;
    private volatile Exception shutdownCause;
    private static final int HANDSHAKE_POOL_SIZE;
    private static final long HANDSHAKE_POOL_KEEP_ALIVE_TIME;
    private final Stopper stopper = new Stopper();

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public static int getBackLog() {
        return BACKLOG;
    }

    public static void init() {
        useSSL = Boolean.getBoolean("p2p.useSSL");
        USE_NIO = !useSSL && !Boolean.getBoolean("p2p.oldIO");
        useDirectBuffers = USE_NIO && !Boolean.getBoolean("p2p.nodirectBuffers");
        LISTENER_CLOSE_TIMEOUT = Integer.getInteger("p2p.listenerCloseTimeout", 60000);
        BACKLOG = Integer.getInteger("p2p.backlog", HANDSHAKE_POOL_SIZE + 1);
    }

    public TCPConduit(MembershipManager mgr, int port, InetAddress address, boolean isBindAddress, DirectChannel receiver, Properties props) throws ConnectionException {
        this.parseProperties(props);
        this.address = address;
        this.isBindAddress = isBindAddress;
        this.port = port;
        this.directChannel = receiver;
        this.stats = null;
        this.config = null;
        this.membershipManager = mgr;
        if (this.directChannel != null) {
            this.stats = this.directChannel.getDMStats();
            this.config = this.directChannel.getDMConfig();
        }
        if (this.stats == null) {
            this.stats = new LonerDistributionManager.DummyDMStats();
        }
        try {
            this.conTable = ConnectionTable.create(this);
        }
        catch (IOException io) {
            throw new ConnectionException(LocalizedStrings.TCPConduit_UNABLE_TO_INITIALIZE_CONNECTION_TABLE.toLocalizedString(), io);
        }
        this.useNIO = USE_NIO;
        if (this.useNIO) {
            String os;
            InetAddress addr = address;
            if (addr == null) {
                try {
                    addr = SocketCreator.getLocalHost();
                }
                catch (UnknownHostException e) {
                    throw new ConnectionException("Unable to resolve localHost address", e);
                }
            }
            if (addr instanceof Inet6Address && (os = System.getProperty("os.name")) != null && os.indexOf("Windows") != -1) {
                this.useNIO = false;
            }
        }
        this.startAcceptor();
    }

    private void parseProperties(Properties p) {
        if (p != null) {
            String s = p.getProperty("p2p.tcpBufferSize", "" + this.tcpBufferSize);
            try {
                this.tcpBufferSize = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_EXCEPTION_PARSING_P2PTCPBUFFERSIZE), (Throwable)e);
            }
            if (this.tcpBufferSize < Connection.SMALL_BUFFER_SIZE) {
                this.tcpBufferSize = Connection.SMALL_BUFFER_SIZE;
            }
            s = p.getProperty("p2p.idleConnectionTimeout", "" + this.idleConnectionTimeout);
            try {
                this.idleConnectionTimeout = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_EXCEPTION_PARSING_P2PIDLECONNECTIONTIMEOUT), (Throwable)e);
            }
            s = p.getProperty("membership_port_range_start");
            try {
                this.tcpPortRange[0] = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_EXCEPTION_PARSING_TCPPORTRANGESTART), (Throwable)e);
            }
            s = p.getProperty("membership_port_range_end");
            try {
                this.tcpPortRange[1] = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_EXCEPTION_PARSING_TCPPORTRANGEEND), (Throwable)e);
            }
        }
    }

    public void setMaximumHandshakePoolSize(int maxSize) {
        if (this.hsPool != null && maxSize > HANDSHAKE_POOL_SIZE) {
            this.hsPool.setMaximumPoolSize(maxSize);
        }
    }

    private void startAcceptor() throws ConnectionException {
        int localPort;
        int p = this.port;
        InetAddress ba = this.address;
        ThreadPoolExecutor tmp_hsPool = null;
        String gName = "P2P-Handshaker " + ba + ":" + p;
        final LoggingThreadGroup socketThreadGroup = LoggingThreadGroup.createThreadGroup(gName, logger);
        ThreadFactory socketThreadFactory = new ThreadFactory(){
            int connNum = -1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(Runnable command) {
                int tnum;
                1 var3_2 = this;
                synchronized (var3_2) {
                    tnum = ++this.connNum;
                }
                String tName = socketThreadGroup.getName() + " Thread " + tnum;
                return new Thread(socketThreadGroup, command, tName);
            }
        };
        try {
            final SynchronousQueue<Runnable> bq = new SynchronousQueue<Runnable>();
            RejectedExecutionHandler reh = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor pool) {
                    try {
                        bq.put(r);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RejectedExecutionException(LocalizedStrings.TCPConduit_INTERRUPTED.toLocalizedString(), ex);
                    }
                }
            };
            tmp_hsPool = new ThreadPoolExecutor(1, HANDSHAKE_POOL_SIZE, HANDSHAKE_POOL_KEEP_ALIVE_TIME, TimeUnit.SECONDS, bq, socketThreadFactory, reh);
        }
        catch (IllegalArgumentException poolInitException) {
            throw new ConnectionException(LocalizedStrings.TCPConduit_WHILE_CREATING_HANDSHAKE_POOL.toLocalizedString(), poolInitException);
        }
        this.hsPool = tmp_hsPool;
        this.createServerSocket();
        try {
            localPort = this.socket.getLocalPort();
            this.id = new Stub(this.socket.getInetAddress(), localPort, 0);
            this.stopped = false;
            LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("P2P Listener Threads", logger);
            this.thread = new Thread(group, this, "P2P Listener Thread " + this.id);
            this.thread.setDaemon(true);
            try {
                this.thread.setPriority(this.thread.getThreadGroup().getMaxPriority());
            }
            catch (Exception e) {
                logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_UNABLE_TO_SET_LISTENER_PRIORITY__0, e.getMessage()));
            }
            if (!Boolean.getBoolean("p2p.test.inhibitAcceptor")) {
                this.thread.start();
            } else {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.TCPConduit_INHIBITACCEPTOR));
                this.socket.close();
                this.hsPool.shutdownNow();
            }
        }
        catch (IOException io) {
            String s = "While creating ServerSocket and Stub on port " + p;
            throw new ConnectionException(s, io);
        }
        this.port = localPort;
    }

    public void setVmViewID(int viewID) {
        this.id.setViewID(viewID);
    }

    private void createServerSocket() {
        int p = this.port;
        int b = BACKLOG;
        InetAddress ba = this.address;
        try {
            if (this.useNIO) {
                if (p <= 0) {
                    this.socket = SocketCreator.getDefaultInstance().createServerSocketUsingPortRange(ba, b, this.isBindAddress, this.useNIO, 0, this.tcpPortRange);
                } else {
                    ServerSocketChannel channl = ServerSocketChannel.open();
                    this.socket = channl.socket();
                    InetSocketAddress addr = new InetSocketAddress(this.isBindAddress ? ba : null, p);
                    this.socket.bind(addr, b);
                }
                if (this.useNIO) {
                    try {
                        this.socket.setReceiveBufferSize(this.tcpBufferSize);
                        int newSize = this.socket.getReceiveBufferSize();
                        if (newSize != this.tcpBufferSize) {
                            logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_0_IS_1_INSTEAD_OF_THE_REQUESTED_2, new Object[]{"Listener receiverBufferSize", newSize, this.tcpBufferSize}));
                        }
                    }
                    catch (SocketException ex) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_FAILED_TO_SET_LISTENER_RECEIVERBUFFERSIZE_TO__0, this.tcpBufferSize));
                    }
                }
                this.channel = this.socket.getChannel();
            } else {
                try {
                    this.socket = p <= 0 ? SocketCreator.getDefaultInstance().createServerSocketUsingPortRange(ba, b, this.isBindAddress, this.useNIO, this.tcpBufferSize, this.tcpPortRange) : SocketCreator.getDefaultInstance().createServerSocket(p, b, this.isBindAddress ? ba : null, this.tcpBufferSize);
                    int newSize = this.socket.getReceiveBufferSize();
                    if (newSize != this.tcpBufferSize) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_0_IS_1_INSTEAD_OF_THE_REQUESTED_2, new Object[]{"Listener receiverBufferSize", newSize, this.tcpBufferSize}));
                    }
                }
                catch (SocketException ex) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_FAILED_TO_SET_LISTENER_RECEIVERBUFFERSIZE_TO__0, this.tcpBufferSize));
                }
            }
            this.port = this.socket.getLocalPort();
        }
        catch (IOException io) {
            throw new ConnectionException(LocalizedStrings.TCPConduit_EXCEPTION_CREATING_SERVERSOCKET.toLocalizedString(p, ba), io);
        }
    }

    public static void loadEmergencyClasses() {
        ConnectionTable.loadEmergencyClasses();
    }

    public void emergencyClose() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        try {
            if (this.channel != null) {
                this.channel.close();
            } else if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ConnectionTable.emergencyClose();
        this.socket = null;
        this.thread = null;
        this.conTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Exception cause) {
        if (!this.stopped) {
            this.stopped = true;
            this.shutdownCause = cause;
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "Shutting down conduit");
            }
            try {
                long timeout = System.currentTimeMillis() + (long)LISTENER_CLOSE_TIMEOUT;
                Thread t = this.thread;
                if (this.channel != null) {
                    this.channel.close();
                } else {
                    ServerSocket s = this.socket;
                    if (s != null) {
                        s.close();
                    }
                    if (t != null) {
                        t.interrupt();
                    }
                }
                while ((t = this.thread) != null && t.isAlive()) {
                    t.join(200L);
                    if (timeout > System.currentTimeMillis()) continue;
                }
                if (t != null && t.isAlive()) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_UNABLE_TO_SHUT_DOWN_LISTENER_WITHIN_0_MS_UNABLE_TO_INTERRUPT_SOCKET_ACCEPT_DUE_TO_JDK_BUG_GIVING_UP, LISTENER_CLOSE_TIMEOUT));
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.hsPool.shutdownNow();
            }
            this.conTable.close();
            this.socket = null;
            this.thread = null;
            this.conTable = null;
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void restart() throws ConnectionException {
        if (!this.stopped) {
            return;
        }
        this.stats = null;
        if (this.directChannel != null) {
            this.stats = this.directChannel.getDMStats();
        }
        if (this.stats == null) {
            this.stats = new LonerDistributionManager.DummyDMStats();
        }
        try {
            this.conTable = ConnectionTable.create(this);
        }
        catch (IOException io) {
            throw new ConnectionException(LocalizedStrings.TCPConduit_UNABLE_TO_INITIALIZE_CONNECTION_TABLE.toLocalizedString(), io);
        }
        this.startAcceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConnectionTable.threadWantsSharedResources();
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "Starting P2P Listener on  {}", this.getId());
        }
        while (true) {
            block32: {
                SystemFailure.checkFailure();
                if (this.stopper.cancelInProgress() != null || this.stopped || Thread.currentThread().isInterrupted() || this.stopper.cancelInProgress() != null) break;
                Socket othersock = null;
                try {
                    if (this.useNIO) {
                        SocketChannel otherChannel = this.channel.accept();
                        othersock = otherChannel.socket();
                    } else {
                        try {
                            othersock = this.socket.accept();
                        }
                        catch (SSLException ex) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_STOPPING_P2P_LISTENER_DUE_TO_SSL_CONFIGURATION_PROBLEM), (Throwable)ex);
                            break;
                        }
                        SocketCreator.getDefaultInstance().configureServerSSLSocket(othersock);
                    }
                    if (this.stopped) {
                        try {
                            if (othersock == null) continue;
                            othersock.close();
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (this.inhibitNewConnections) {
                        if (logger.isTraceEnabled(LogMarker.QA)) {
                            logger.trace(LogMarker.QA, "Test hook: inhibiting acceptance of connection {}", othersock);
                        }
                        othersock.close();
                        while (this.inhibitNewConnections && !this.stopped) {
                            this.stopper.checkCancelInProgress(null);
                            boolean interrupted = Thread.interrupted();
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            finally {
                                if (!interrupted) continue;
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (logger.isTraceEnabled(LogMarker.QA)) {
                            logger.trace(LogMarker.QA, "Test hook: finished inhibiting acceptance of connections");
                        }
                        break block32;
                    }
                    this.acceptConnection(othersock);
                }
                catch (ClosedByInterruptException cbie) {
                }
                catch (ClosedChannelException e) {
                    break;
                }
                catch (CancelException e) {
                    break;
                }
                catch (Exception e) {
                    if (this.stopped) break block32;
                    if (e instanceof SocketException && "Socket closed".equalsIgnoreCase(e.getMessage())) {
                        if (this.socket.isClosed()) break block32;
                        logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_SERVERSOCKET_THREW_SOCKET_CLOSED_EXCEPTION_BUT_SAYS_IT_IS_NOT_CLOSED), (Throwable)e);
                        try {
                            this.socket.close();
                            this.createServerSocket();
                        }
                        catch (IOException ioe) {
                            logger.fatal(LocalizedMessage.create(LocalizedStrings.TCPConduit_UNABLE_TO_CLOSE_AND_RECREATE_SERVER_SOCKET), (Throwable)ioe);
                            try {
                                Thread.sleep(5000L);
                                break block32;
                            }
                            catch (InterruptedException ie) {
                                logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_INTERRUPTED_AND_EXITING_WHILE_TRYING_TO_RECREATE_LISTENER_SOCKETS));
                                return;
                            }
                        }
                    }
                    this.stats.incFailedAccept();
                    if (e instanceof IOException && "Too many open files".equals(e.getMessage())) {
                        this.getConTable().fileDescriptorsExhausted();
                    }
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (this.stopped || !this.socket.isClosed()) continue;
            logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_SERVERSOCKET_CLOSED_REOPENING));
            try {
                this.createServerSocket();
            }
            catch (ConnectionException ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.debug("Stopped P2P Listener on  {}", this.getId());
        }
    }

    private void acceptConnection(final Socket othersock) {
        try {
            this.hsPool.execute(new Runnable(){

                @Override
                public void run() {
                    TCPConduit.this.basicAcceptConnection(othersock);
                }
            });
        }
        catch (RejectedExecutionException rejected) {
            try {
                othersock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ConnectionTable getConTable() {
        ConnectionTable result = this.conTable;
        if (result == null) {
            this.stopper.checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException(LocalizedStrings.TCPConduit_TCP_LAYER_HAS_BEEN_SHUTDOWN.toLocalizedString());
        }
        return result;
    }

    protected void basicAcceptConnection(Socket othersock) {
        block7: {
            try {
                this.getConTable().acceptConnection(othersock);
            }
            catch (IOException io) {
                if (!this.stopped) {
                    this.stats.incFailedAccept();
                }
            }
            catch (ConnectionException ex) {
                if (!this.stopped) {
                    this.stats.incFailedAccept();
                }
            }
            catch (CancelException e) {
            }
            catch (Exception e) {
                if (this.stopped) break block7;
                this.stats.incFailedAccept();
                logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_FAILED_TO_ACCEPT_CONNECTION_FROM_0_BECAUSE_1, new Object[]{othersock.getInetAddress(), e}), (Throwable)e);
            }
        }
    }

    protected boolean useNIO() {
        return this.useNIO;
    }

    public void getThreadOwnedOrderedConnectionState(Stub member, HashMap result) {
        this.getConTable().getThreadOwnedOrderedConnectionState(member, result);
    }

    public void waitForThreadOwnedOrderedConnectionState(Stub member, HashMap channelState) throws InterruptedException {
        this.getConTable().waitForThreadOwnedOrderedConnectionState(member, channelState);
    }

    protected void messageReceived(Connection receiver, DistributionMessage message, int bytesRead) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} received {} from {}", this.id, message, receiver);
        }
        if (this.directChannel != null) {
            DistributionMessage msg = message;
            msg.setBytesRead(bytesRead);
            msg.setSender(receiver.getRemoteAddress());
            this.directChannel.receive(msg, bytesRead, receiver.getRemoteId());
        }
    }

    public Stub getId() {
        return this.id;
    }

    public int getPort() {
        return this.id.getPort();
    }

    public InternalDistributedMember getLocalAddress() {
        return this.localAddr;
    }

    public int getBindPort() {
        return this.port;
    }

    public DirectChannel getDirectChannel() {
        return this.directChannel;
    }

    public InternalDistributedMember getMemberForStub(Stub s, boolean validate) {
        return this.membershipManager.getMemberForStub(s, validate);
    }

    public void setLocalAddr(InternalDistributedMember addr) {
        this.localAddr = addr;
    }

    public InternalDistributedMember getLocalId() {
        return this.localAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(InternalDistributedMember memberAddress, Stub remoteId, boolean preserveOrder, boolean retry, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        if (this.stopped) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.TCPConduit_THE_CONDUIT_IS_STOPPED.toLocalizedString());
        }
        Connection conn = null;
        InternalDistributedMember memberInTrouble = null;
        boolean breakLoop = false;
        while (true) {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                Exception problem;
                block39: {
                    if (retry || conn != null) {
                        InternalDistributedMember m = this.membershipManager.getMemberForStub(remoteId, true);
                        if (m == null) {
                            throw new IOException(LocalizedStrings.TCPConduit_TCPIP_CONNECTION_LOST_AND_MEMBER_IS_NOT_IN_VIEW.toLocalizedString());
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            this.stopper.checkCancelInProgress(e);
                        }
                        m = this.membershipManager.getMemberForStub(remoteId, true);
                        if (m == null) {
                            throw new IOException(LocalizedStrings.TCPConduit_TCPIP_CONNECTION_LOST_AND_MEMBER_IS_NOT_IN_VIEW.toLocalizedString());
                        }
                        if (memberInTrouble == null) {
                            memberInTrouble = m;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_ATTEMPTING_TCPIP_RECONNECT_TO__0, memberInTrouble));
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Attempting TCP/IP reconnect to {}", memberInTrouble);
                        }
                        this.stats.incReconnectAttempts();
                        if (conn != null) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Closing old connection.  conn={} before retrying. remoteID={} memberInTrouble={}", conn, remoteId, memberInTrouble);
                                }
                                conn.closeForReconnect("closing before retrying");
                            }
                            catch (CancelException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    problem = null;
                    try {
                        boolean retryForOldConnection;
                        boolean debugRetry = false;
                        do {
                            retryForOldConnection = false;
                            conn = this.getConTable().get(remoteId, preserveOrder, startTime, ackTimeout, ackSATimeout);
                            if (conn == null) {
                                problem = new IOException(LocalizedStrings.TCPConduit_UNABLE_TO_RECONNECT_TO_SERVER_POSSIBLE_SHUTDOWN_0.toLocalizedString(remoteId));
                                continue;
                            }
                            if (!conn.isClosing() && conn.getRemoteAddress().equals(memberAddress)) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Got an old connection for {}: {}@{}", memberAddress, conn, conn.hashCode());
                            }
                            conn.closeOldConnection("closing old connection");
                            conn = null;
                            retryForOldConnection = true;
                            debugRetry = true;
                        } while (retryForOldConnection);
                        if (debugRetry && logger.isDebugEnabled()) {
                            logger.debug("Done removing old connections");
                        }
                    }
                    catch (ConnectionException e) {
                        problem = e;
                        breakLoop = true;
                    }
                    catch (IOException e) {
                        problem = e;
                        if (!AlertAppender.isThreadAlerting()) break block39;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Giving up connecting to alert listener {}", memberAddress);
                        }
                        breakLoop = true;
                    }
                }
                if (problem != null) {
                    InternalDistributedMember m = this.membershipManager.getMemberForStub(remoteId, true);
                    if (m == null) {
                        if (memberInTrouble != null) {
                            logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_ENDING_RECONNECT_ATTEMPT_BECAUSE_0_HAS_DISAPPEARED, memberInTrouble));
                        }
                        throw new IOException(LocalizedStrings.TCPConduit_PEER_HAS_DISAPPEARED_FROM_VIEW.toLocalizedString(remoteId));
                    }
                    if (this.membershipManager.shutdownInProgress()) {
                        if (memberInTrouble != null) {
                            logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_ENDING_RECONNECT_ATTEMPT_TO_0_BECAUSE_SHUTDOWN_HAS_STARTED, memberInTrouble));
                        }
                        this.stopper.checkCancelInProgress(null);
                        throw new DistributedSystemDisconnectedException(LocalizedStrings.TCPConduit_ABANDONED_BECAUSE_SHUTDOWN_IS_IN_PROGRESS.toLocalizedString());
                    }
                    if (memberInTrouble == null) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_ERROR_SENDING_MESSAGE_TO_0_WILL_REATTEMPT_1, new Object[]{m, problem}));
                        memberInTrouble = m;
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Error sending message to {}", m, problem);
                    }
                    if (!breakLoop) continue;
                    if (!problem.getMessage().startsWith("Cannot form connection to alert listener")) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.TCPConduit_THROWING_IOEXCEPTION_AFTER_FINDING_BREAKLOOP_TRUE), (Throwable)problem);
                    }
                    if (problem instanceof IOException) {
                        throw (IOException)problem;
                    }
                    IOException ioe = new IOException(LocalizedStrings.TCPConduit_PROBLEM_CONNECTING_TO_0.toLocalizedString(remoteId));
                    ioe.initCause(problem);
                    throw ioe;
                }
                if (memberInTrouble != null) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.TCPConduit_SUCCESSFULLY_RECONNECTED_TO_MEMBER_0, memberInTrouble));
                    if (logger.isTraceEnabled()) {
                        logger.trace("new connection is {} remoteId={} memberAddress={}", conn, remoteId, memberAddress);
                    }
                }
                Connection connection = conn;
                return connection;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public String toString() {
        return "" + this.id;
    }

    public boolean threadOwnsResources() {
        ConnectionTable ct = this.conTable;
        if (ct == null) {
            return false;
        }
        DM d = this.getDM();
        if (d != null) {
            return d.getSystem().threadOwnsResources();
        }
        return false;
    }

    public DM getDM() {
        return this.directChannel.getDM();
    }

    public void removeEndpoint(Stub stub, String reason) {
        this.removeEndpoint(stub, reason, true);
    }

    public void removeEndpoint(Stub stub, String reason, boolean notifyDisconnect) {
        ConnectionTable ct = this.conTable;
        if (ct == null) {
            return;
        }
        ct.removeEndpoint(stub, reason, notifyDisconnect);
    }

    public boolean hasReceiversFor(Stub endPoint) {
        ConnectionTable ct = this.conTable;
        return ct != null && ct.hasReceiversFor(endPoint);
    }

    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public Exception getShutdownCause() {
        return this.shutdownCause;
    }

    public boolean waitForMembershipCheck(InternalDistributedMember remoteId) {
        return this.membershipManager.waitForMembershipCheck(remoteId);
    }

    public void beSick() {
        this.inhibitNewConnections = true;
        this.conTable.closeReceivers(true);
    }

    public void beHealthy() {
        this.inhibitNewConnections = false;
    }

    static {
        TCPConduit.init();
        HANDSHAKE_POOL_SIZE = Integer.getInteger("p2p.HANDSHAKE_POOL_SIZE", 10);
        HANDSHAKE_POOL_KEEP_ALIVE_TIME = Long.getLong("p2p.HANDSHAKE_POOL_KEEP_ALIVE_TIME", 60L);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            DM dm = TCPConduit.this.getDM();
            if (dm == null) {
                return "no distribution manager";
            }
            if (TCPConduit.this.stopped) {
                return "Conduit has been stopped";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            DM dm = TCPConduit.this.getDM();
            if (dm == null) {
                return new DistributedSystemDisconnectedException("no distribution manager");
            }
            RuntimeException result = dm.getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            result = new DistributedSystemDisconnectedException("Conduit has been stopped");
            result.initCause(e);
            return result;
        }
    }
}

