/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.aggregator;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorException;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.SingleAggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandClient;
import java.util.ArrayList;
import java.util.HashMap;

public class Aggregator {
    private static HashMap allAggregatorsMap = new HashMap();
    private SingleAggregator thisAggregator;
    private SingleAggregator[] singleAggregators;
    private HashMap aggregatorMap = new HashMap(3);
    private long timeout = 30000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator(String commandRegionFullPath, String endpoints) {
        commandRegionFullPath = this.getCanonicalRegionPath(commandRegionFullPath);
        this.thisAggregator = new SingleAggregator(commandRegionFullPath, endpoints);
        HashMap hashMap = this.aggregatorMap;
        synchronized (hashMap) {
            this.singleAggregators = new SingleAggregator[1];
            this.singleAggregators[0] = this.thisAggregator;
            this.aggregatorMap.put(commandRegionFullPath, this.thisAggregator);
            allAggregatorsMap.put(commandRegionFullPath, new AggregatorCount(this.thisAggregator));
            Aggregator.incrementCount(commandRegionFullPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator(CommandClient commandClient) {
        this.thisAggregator = new SingleAggregator(commandClient);
        String commandRegionFullPath = commandClient.getOutboxRegionFullPath();
        HashMap hashMap = this.aggregatorMap;
        synchronized (hashMap) {
            this.singleAggregators = new SingleAggregator[1];
            this.singleAggregators[0] = this.thisAggregator;
            this.aggregatorMap.put(commandRegionFullPath, this.thisAggregator);
            allAggregatorsMap.put(commandRegionFullPath, new AggregatorCount(this.thisAggregator));
            Aggregator.incrementCount(commandRegionFullPath);
        }
    }

    private static int incrementCount(String commandRegionFullPath) {
        AggregatorCount ac = (AggregatorCount)allAggregatorsMap.get(commandRegionFullPath);
        if (ac == null) {
            return -1;
        }
        ++ac.count;
        return ac.count;
    }

    private static int decrementCount(String commandRegionFullPath) {
        AggregatorCount ac = (AggregatorCount)allAggregatorsMap.get(commandRegionFullPath);
        if (ac == null) {
            return -1;
        }
        --ac.count;
        if (ac.count <= 0) {
            allAggregatorsMap.remove(commandRegionFullPath);
        }
        return ac.count;
    }

    private static int getCount(String commandRegionFullPath) {
        AggregatorCount ac = (AggregatorCount)allAggregatorsMap.get(commandRegionFullPath);
        if (ac == null) {
            return 0;
        }
        return ac.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAggregator(String commandRegionFullPath, String endpoints) throws AggregatorException {
        if (this.isClosed()) {
            throw new AggregatorException("Aggregator closed. Unable to add the specified aggregator. Please create a new Aggregator first.");
        }
        HashMap hashMap = this.aggregatorMap;
        synchronized (hashMap) {
            commandRegionFullPath = this.getCanonicalRegionPath(commandRegionFullPath);
            SingleAggregator aggregator = (SingleAggregator)this.aggregatorMap.get(commandRegionFullPath);
            if (aggregator == null) {
                aggregator = new SingleAggregator(commandRegionFullPath, endpoints);
                this.aggregatorMap.put(commandRegionFullPath, aggregator);
                Aggregator.incrementCount(commandRegionFullPath);
                allAggregatorsMap.put(commandRegionFullPath, new AggregatorCount(aggregator));
                this.singleAggregators = this.aggregatorMap.values().toArray(new SingleAggregator[0]);
            }
        }
    }

    public void removeAggregator(String commandRegionFullPath) throws AggregatorException {
        commandRegionFullPath = this.getCanonicalRegionPath(commandRegionFullPath);
        if (this.thisAggregator.getCommandRegionFullPath().equals(commandRegionFullPath)) {
            throw new AggregatorException("Removing the primary (this) aggregator is not allowed. Please use close() instead.");
        }
        this.remove(commandRegionFullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String commandRegionFullPath) throws AggregatorException {
        HashMap hashMap = this.aggregatorMap;
        synchronized (hashMap) {
            SingleAggregator aggregator = (SingleAggregator)this.aggregatorMap.remove(commandRegionFullPath);
            if (aggregator != null) {
                Aggregator.decrementCount(commandRegionFullPath);
                if (Aggregator.getCount(commandRegionFullPath) <= 0) {
                    aggregator.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws AggregatorException {
        HashMap hashMap = this.aggregatorMap;
        synchronized (hashMap) {
            String[] paths = this.aggregatorMap.keySet().toArray(new String[0]);
            for (int i = 0; i < paths.length; ++i) {
                this.remove(paths[i]);
            }
            this.aggregatorMap.clear();
            this.singleAggregators = new SingleAggregator[0];
            this.thisAggregator = null;
        }
    }

    public boolean isClosed() {
        return this.thisAggregator == null;
    }

    public static void closeAll() {
        AggregatorCount[] acs = allAggregatorsMap.keySet().toArray(new AggregatorCount[0]);
        for (int i = 0; i < acs.length; ++i) {
            try {
                acs[i].aggregator.close();
                continue;
            }
            catch (AggregatorException aggregatorException) {
                // empty catch block
            }
        }
        allAggregatorsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object aggregate(AggregateFunction function, String regionFullPath) throws AggregatorException {
        if (this.isClosed()) {
            throw new AggregatorException("Aggregator closed. Unable to aggregate. Please create a new Aggregator.");
        }
        SingleAggregator[] aggregators = this.singleAggregators;
        if (aggregators.length == 1) {
            return aggregators[0].aggregate(function, regionFullPath);
        }
        ArrayList resultsList = new ArrayList();
        ArrayList exceptionList = new ArrayList();
        long count = aggregators.length;
        int i = 0;
        while ((long)i < count) {
            new Thread(new DSAggregator(function, aggregators[i], regionFullPath, resultsList, exceptionList)).start();
            ++i;
        }
        boolean allResponded = false;
        long startTime = System.currentTimeMillis();
        do {
            try {
                this.wait(this.timeout);
                ArrayList arrayList = resultsList;
                synchronized (arrayList) {
                    boolean bl = allResponded = (long)resultsList.size() == count;
                    if (!allResponded && !exceptionList.isEmpty()) {
                        break;
                    }
                }
                if (allResponded || System.currentTimeMillis() - startTime < this.timeout) continue;
                break;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!allResponded);
        if (!allResponded) {
            if (!exceptionList.isEmpty()) {
                throw new AggregatorException("Distributed System Error. Errors from " + exceptionList.size() + " distributed system(s). See getClientExceptions()", exceptionList.toArray(new Throwable[0]));
            }
            throw new AggregatorException("The aggregate operation timed out. Not all distributed systems responded within the timeout period of " + this.timeout + " msec.");
        }
        Object[] results = resultsList.toArray();
        return function.aggregateDistributedSystems(results);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getCommandRegionFullPath() {
        return this.thisAggregator.getCommandRegionFullPath();
    }

    public String getEndpoints() {
        return this.thisAggregator.getEndpoints();
    }

    private String getCanonicalRegionPath(String regionPath) {
        if (!(regionPath = regionPath.trim()).startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        return regionPath;
    }

    private synchronized void notifyResults() {
        this.notify();
    }

    static class AggregatorCount {
        public int count = 0;
        public SingleAggregator aggregator;

        AggregatorCount(SingleAggregator aggregator) {
            this.aggregator = aggregator;
        }
    }

    class DSAggregator
    implements Runnable {
        private AggregateFunction function;
        private SingleAggregator aggregator;
        private ArrayList resultsList;
        private ArrayList exceptionList;
        private String regionFullPath;

        DSAggregator(AggregateFunction function, SingleAggregator aggregator2, String regionFullPath, ArrayList resultsList, ArrayList exceptionList) {
            this.function = function;
            this.aggregator = aggregator2;
            this.regionFullPath = regionFullPath;
            this.resultsList = resultsList;
            this.exceptionList = exceptionList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object results = this.aggregator.aggregate(this.function, this.regionFullPath);
                ArrayList arrayList = this.resultsList;
                synchronized (arrayList) {
                    this.resultsList.add(results);
                }
                Aggregator.this.notifyResults();
            }
            catch (AggregatorException ex) {
                ArrayList arrayList = this.resultsList;
                synchronized (arrayList) {
                    this.exceptionList.add(ex);
                }
                Aggregator.this.notifyResults();
            }
        }
    }
}

