/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.index;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EntryMap
extends HashMap<DataSerializable, Object>
implements DataSerializable {
    private boolean keysOnly = false;

    public EntryMap() {
    }

    public EntryMap(int size2) {
        super(size2);
    }

    public EntryMap(int size2, float loadfactor) {
        this(size2, loadfactor, false);
    }

    public EntryMap(int size2, float loadfactor, boolean keysOnly) {
        super(size2, loadfactor);
        this.keysOnly = keysOnly;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.keysOnly = in.readBoolean();
        int size2 = in.readInt();
        if (this.keysOnly) {
            for (int i = 0; i < size2; ++i) {
                DataSerializable key2 = (DataSerializable)DataSerializer.readObject(in);
                this.put(key2, key2);
            }
        } else {
            for (int i = 0; i < size2; ++i) {
                DataSerializable key3 = (DataSerializable)DataSerializer.readObject(in);
                DataSerializable value2 = (DataSerializable)DataSerializer.readObject(in);
                this.put(key3, value2);
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.keysOnly);
        out.writeInt(this.size());
        if (this.keysOnly) {
            for (Map.Entry e : this.entrySet()) {
                DataSerializer.writeObject(e.getKey(), out);
            }
        } else {
            for (Map.Entry e : this.entrySet()) {
                DataSerializer.writeObject(e.getKey(), out);
                out.write(((CachedDeserializable)e.getValue()).getSerializedValue());
            }
        }
    }
}

