/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PartitionedRegionAttributeTask
implements CommandTask {
    private static final long serialVersionUID = 1L;
    private String regionPath;

    @Override
    public CommandResults runTask(Object userData) {
        CommandResults results = new CommandResults();
        try {
            PartitionAttributeInfo pai = PartitionedRegionAttributeTask.getPartitionAttributeInfo(this.regionPath);
            if (pai == null) {
                results.setCode((byte)-1);
                results.setCodeMessage(this.regionPath + " is not partitioned regon");
            }
        }
        catch (Exception ex) {
            results.setCode((byte)-1);
            results.setCodeMessage(ex.getMessage());
            results.setException(ex);
        }
        return results;
    }

    private static PartitionAttributeInfo getPartitionAttributeInfo(String regionPath) throws AdminException {
        Cache cache = CacheFactory.getAnyInstance();
        DistributedSystem ds = cache.getDistributedSystem();
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem(ds, null);
        AdminDistributedSystem adminSystem = AdminDistributedSystemFactory.getDistributedSystem(config);
        try {
            adminSystem.connect();
        }
        catch (Exception ex) {
            // empty catch block
        }
        SystemMember[] members = adminSystem.getSystemMemberApplications();
        boolean isPR = true;
        int redundantCopies = 0;
        int totalNumBuckets = 0;
        PartitionAttributeInfo pai = new PartitionAttributeInfo();
        for (int i = 0; i < members.length; ++i) {
            SystemMemberCache scache = members[i].getCache();
            if (scache == null) continue;
            SystemMemberRegion region = scache.getRegion(regionPath);
            PartitionAttributes pa = region.getPartitionAttributes();
            if (pa == null) {
                isPR = false;
                break;
            }
            PartitionAttributeInfo.Partition part = new PartitionAttributeInfo.Partition();
            part.localMaxMemory = region.getPartitionAttributes().getLocalMaxMemory();
            part.toalMaxMemory = region.getPartitionAttributes().getTotalMaxMemory();
            pai.addPartition(part);
            redundantCopies = region.getPartitionAttributes().getRedundantCopies();
            totalNumBuckets = region.getPartitionAttributes().getTotalNumBuckets();
        }
        if (isPR) {
            pai.redundantCopies = redundantCopies;
            pai.regionPath = regionPath;
            pai.totalNumBuckets = totalNumBuckets;
        } else {
            pai = null;
        }
        return pai;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionPath = in.readUTF();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeUTF(this.regionPath);
    }

    public static class PartitionAttributeInfo
    implements DataSerializable {
        private static final long serialVersionUID = 1L;
        private String regionPath;
        private int redundantCopies;
        private int totalNumBuckets;
        private List partitionList = new ArrayList();

        public void addPartition(Partition partition) {
            this.partitionList.add(partition);
        }

        public List getPartitionList() {
            return this.partitionList;
        }

        public String getRegionPath() {
            return this.regionPath;
        }

        public int getRedundantCopies() {
            return this.redundantCopies;
        }

        public int getTotalNumBuckets() {
            return this.totalNumBuckets;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.regionPath = in.readUTF();
            this.redundantCopies = in.readInt();
            this.totalNumBuckets = in.readInt();
            this.partitionList = new ArrayList();
            int size2 = in.readInt();
            for (int i = 0; i < size2; ++i) {
                Partition part = new Partition();
                part.memberName = in.readUTF();
                part.localMaxMemory = in.readInt();
                part.toalMaxMemory = in.readLong();
                this.partitionList.add(part);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            out.writeUTF(this.regionPath);
            out.writeInt(this.redundantCopies);
            out.writeInt(this.totalNumBuckets);
            int size2 = this.partitionList.size();
            out.writeInt(size2);
            for (int i = 0; i < size2; ++i) {
                Partition part = (Partition)this.partitionList.get(i);
                out.writeUTF(part.memberName);
                out.writeInt(part.localMaxMemory);
                out.writeLong(part.toalMaxMemory);
            }
        }

        public static class Partition {
            private String memberName;
            private int localMaxMemory;
            private long toalMaxMemory;

            public String getMemberName() {
                return this.memberName;
            }

            public int getLocalMaxMemory() {
                return this.localMaxMemory;
            }

            public long getToalMaxMemory() {
                return this.toalMaxMemory;
            }
        }
    }
}

