/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.GfshResultsBag;
import com.gemstone.gemfire.internal.tools.gfsh.command.AbstractCommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class QueryTask
extends AbstractCommandTask {
    private static final long serialVersionUID = 1L;
    private static boolean priorTo6011AndNot57;
    public static final byte ERROR_NONE = 0;
    public static final byte ERROR_QUERY = 1;
    private static final String REGION_NAME_RESULTS = "qr";
    private static int UUID_TIMEOUT;
    private static String staticUuid;
    private transient String uuid;
    private String queryString;
    private boolean nextEnabled;
    private int fetchSize = 1000;
    private boolean isPRLocalData;
    private boolean keysOnly;

    static boolean isPriorTo6011AndNot57() {
        String gemfireVersion = GemFireVersion.getGemFireVersion();
        String[] split = gemfireVersion.split("\\.");
        int major = 0;
        int minor = 0;
        int update = 0;
        int update2 = 0;
        block12: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    major = Integer.parseInt(split[i]);
                    continue block12;
                }
                case 1: {
                    try {
                        minor = Integer.parseInt(split[i]);
                    }
                    catch (NumberFormatException ex) {
                        minor = Integer.parseInt(split[i].substring(0, 1));
                    }
                    continue block12;
                }
                case 2: {
                    try {
                        update = Integer.parseInt(split[i]);
                    }
                    catch (NumberFormatException e) {
                        update = 0;
                    }
                    continue block12;
                }
                case 3: {
                    try {
                        update2 = Integer.parseInt(split[i]);
                        continue block12;
                    }
                    catch (NumberFormatException e) {
                        update2 = 0;
                    }
                }
            }
        }
        if (major < 6) {
            return false;
        }
        if (minor > 0) {
            return false;
        }
        if (update < 1) {
            return true;
        }
        if (update > 1) {
            return false;
        }
        return update2 <= 0;
    }

    public QueryTask() {
    }

    public QueryTask(String queryString) {
        this(queryString, 1000, true, false, false);
    }

    public QueryTask(String queryString, int fetchSize, boolean nextEnabled) {
        this(queryString, fetchSize, nextEnabled, true);
    }

    public QueryTask(String queryString, int fetchSize, boolean nextEnabled, boolean isPRLocalData) {
        this(queryString, fetchSize, nextEnabled, isPRLocalData, false);
    }

    public QueryTask(String queryString, int fetchSize, boolean nextEnabled, boolean isPRLocalData, boolean keysOnly) {
        this.queryString = queryString;
        this.fetchSize = fetchSize;
        this.nextEnabled = nextEnabled;
        this.isPRLocalData = isPRLocalData;
        this.keysOnly = keysOnly;
    }

    @Override
    public CommandResults runTask(Object userData) {
        CommandResults results = this.execute(this.queryString);
        return results;
    }

    private Region getResultRegion() {
        Region<Object, Object> resultRegion = super.getCommandRegion().getSubregion(REGION_NAME_RESULTS);
        if (resultRegion == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setStatisticsEnabled(true);
            factory.setScope(Scope.LOCAL);
            factory.setDataPolicy(DataPolicy.NORMAL);
            factory.setEntryIdleTimeout(new ExpirationAttributes(UUID_TIMEOUT, ExpirationAction.LOCAL_DESTROY));
            try {
                resultRegion = super.getCommandRegion().createSubregion(REGION_NAME_RESULTS, factory.create());
            }
            catch (Exception ex) {
                resultRegion = super.getCommandRegion().getSubregion(REGION_NAME_RESULTS);
            }
        }
        return resultRegion;
    }

    protected CommandResults execute(String queryString) {
        CommandResults results = new CommandResults();
        Cache cache = CacheFactory.getAnyInstance();
        Region resultRegion = this.getResultRegion();
        try {
            Object obj = null;
            int returnedSize = 0;
            int actualSize = 0;
            boolean isPR = false;
            if (queryString == null) {
                ResultsContainer container = (ResultsContainer)resultRegion.get(this.uuid);
                if (container != null) {
                    isPR = container.isPR;
                    obj = container.getSubsetResults(this.getFetchSize());
                    actualSize = container.getActualSize();
                    returnedSize = container.getReturnedSize();
                    if (!container.hasNext()) {
                        resultRegion.remove(this.uuid);
                    }
                }
            } else {
                String lowercase;
                if (this.nextEnabled) {
                    resultRegion.remove(this.uuid);
                }
                if ((lowercase = queryString.trim().toLowerCase()).startsWith("select ")) {
                    Query query = cache.getQueryService().newQuery(queryString);
                    obj = query.execute();
                    if (obj instanceof SelectResults) {
                        SelectResults sr = (SelectResults)obj;
                        actualSize = sr.size();
                        if (this.fetchSize != -1) {
                            if (sr.size() <= this.fetchSize) {
                                if (QueryTask.isPriorTo6011AndNot57()) {
                                    if (sr instanceof ResultsBag) {
                                        SelectResultsContainer srContainer = new SelectResultsContainer(sr);
                                        obj = srContainer.getSubsetResults(this.getFetchSize());
                                    } else {
                                        obj = sr;
                                    }
                                } else {
                                    obj = sr;
                                }
                                returnedSize = sr.size();
                            } else {
                                SelectResultsContainer srContainer = new SelectResultsContainer(sr);
                                obj = srContainer.getSubsetResults(this.getFetchSize());
                                returnedSize = srContainer.returnedSize;
                                if (this.nextEnabled) {
                                    resultRegion.put(this.uuid, srContainer);
                                }
                            }
                        } else {
                            returnedSize = sr.size();
                        }
                    }
                } else {
                    String regionPath = queryString;
                    Region region = cache.getRegion(regionPath);
                    if (region == null) {
                        results.setCode((byte)1);
                        results.setCodeMessage("Invalid region path. Unable to query data.");
                    } else {
                        isPR = region instanceof PartitionedRegion;
                        Set<Object> resultSet = null;
                        if (this.isPRLocalData && isPR) {
                            PartitionedRegion pr2 = (PartitionedRegion)region;
                            if (pr2.getDataStore() == null) {
                                results.setCodeMessage("No data store");
                                return results;
                            }
                            List bucketIdList = pr2.getDataStore().getLocalPrimaryBucketsListTestOnly();
                            resultSet = new HashSet();
                            for (Integer bucketId : bucketIdList) {
                                try {
                                    BucketRegion bucketRegion = pr2.getDataStore().getInitializedBucketForId(null, bucketId);
                                    Set set = this.keysOnly ? bucketRegion.keySet() : bucketRegion.entrySet();
                                    for (Object object : set) {
                                        resultSet.add(object);
                                    }
                                }
                                catch (ForceReattemptException e) {
                                }
                            }
                        } else {
                            Region r = region;
                            resultSet = this.keysOnly ? r.keySet() : r.entrySet();
                        }
                        actualSize = resultSet.size();
                        RegionContainer regionContainer = new RegionContainer(resultSet, this.keysOnly, isPR);
                        obj = regionContainer.getSubsetResults(this.getFetchSize());
                        returnedSize = regionContainer.getReturnedSize();
                        if (this.nextEnabled && regionContainer.hasNext()) {
                            resultRegion.put(this.uuid, regionContainer);
                        }
                    }
                }
            }
            results.setDataObject(new QueryResults(obj, actualSize, this.fetchSize, returnedSize, isPR));
        }
        catch (QueryException e) {
            cache.getLogger().warning(e);
            results.setCode((byte)1);
            results.setCodeMessage("Unable to execute command task. Invalid query.");
            results.setException(e);
        }
        return results;
    }

    public String getQuery() {
        return this.queryString;
    }

    public void setQuery(String queryString) {
        this.queryString = queryString;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        super.fromData(input);
        this.uuid = DataSerializer.readString(input);
        this.queryString = DataSerializer.readString(input);
        this.nextEnabled = input.readBoolean();
        this.isPRLocalData = input.readBoolean();
        this.fetchSize = input.readInt();
        this.keysOnly = input.readBoolean();
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        super.toData(output);
        DataSerializer.writeString(staticUuid, output);
        DataSerializer.writeString(this.queryString, output);
        output.writeBoolean(this.nextEnabled);
        output.writeBoolean(this.isPRLocalData);
        output.writeInt(this.fetchSize);
        output.writeBoolean(this.keysOnly);
    }

    static {
        staticUuid = UUID.randomUUID().toString();
        priorTo6011AndNot57 = false;
        priorTo6011AndNot57 = QueryTask.isPriorTo6011AndNot57();
        UUID_TIMEOUT = Integer.getInteger("QueryTask.uuidTimeout", 30);
    }

    class RegionContainer
    extends ResultsContainer {
        Set resultSet;
        Iterator iterator;
        int returnedSize;
        boolean keysOnly;

        RegionContainer(Set resultSet, boolean keysOnly, boolean isPR) {
            this.returnedSize = 0;
            this.resultSet = resultSet;
            this.keysOnly = keysOnly;
            this.isPR = isPR;
            this.iterator = resultSet.iterator();
        }

        @Override
        protected Object getSubsetResults(int fetchSize) {
            Cloneable retval;
            int count;
            if (this.keysOnly) {
                ArrayList list = new ArrayList();
                for (count = 0; count < fetchSize && this.iterator.hasNext(); ++count) {
                    Object key2 = this.iterator.next();
                    list.add(key2);
                }
                retval = list;
            } else {
                HashMap map = new HashMap();
                while (count < fetchSize && this.iterator.hasNext()) {
                    Region.Entry entry = (Region.Entry)this.iterator.next();
                    map.put(entry.getKey(), entry.getValue());
                    ++count;
                }
                retval = map;
            }
            this.returnedSize += count;
            return retval;
        }

        @Override
        protected boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        protected int getActualSize() {
            return this.resultSet.size();
        }

        @Override
        protected int getReturnedSize() {
            return this.returnedSize;
        }
    }

    class SelectResultsContainer
    extends ResultsContainer {
        SelectResults sr;
        Iterator iterator;
        int returnedSize;

        SelectResultsContainer(SelectResults sr) {
            this.returnedSize = 0;
            this.sr = sr;
            this.iterator = sr.iterator();
        }

        @Override
        protected Object getSubsetResults(int fetchSize) {
            int count;
            CollectionType type = this.sr.getCollectionType();
            ObjectType elementType = type.getElementType();
            AbstractCollection sr2 = elementType.isStructType() ? new StructBag() : (QueryTask.isPriorTo6011AndNot57() ? new GfshResultsBag() : new ResultsBag());
            sr2.setElementType(elementType);
            for (count = 0; count < fetchSize && this.iterator.hasNext(); ++count) {
                Object object = this.iterator.next();
                sr2.add(object);
            }
            this.returnedSize += count;
            return sr2;
        }

        @Override
        protected boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        protected int getActualSize() {
            return this.sr.size();
        }

        @Override
        protected int getReturnedSize() {
            return this.returnedSize;
        }
    }

    abstract class ResultsContainer {
        boolean isPR = false;

        ResultsContainer() {
        }

        protected abstract Object getSubsetResults(int var1);

        protected abstract boolean hasNext();

        protected abstract int getActualSize();

        protected abstract int getReturnedSize();
    }
}

