/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RegionClearTask
implements CommandTask {
    private static final long serialVersionUID = 1L;
    public static final byte ERROR_REGION_CLEAR = 1;
    private String regionFullPath;

    public RegionClearTask() {
    }

    public RegionClearTask(String regionFullPath) {
        this.regionFullPath = regionFullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResults runTask(Object userData) {
        CommandResults results;
        block6: {
            results = new CommandResults();
            MemberInfo memberInfo = new MemberInfo();
            try {
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(this.regionFullPath);
                DistributedMember member = cache.getDistributedSystem().getDistributedMember();
                memberInfo.setHost(member.getHost());
                memberInfo.setMemberId(member.getId());
                memberInfo.setMemberName(cache.getName());
                memberInfo.setPid(member.getProcessId());
                results.setDataObject(memberInfo);
                if (region == null) {
                    results.setCode((byte)1);
                    results.setCodeMessage("Region undefined: " + this.regionFullPath);
                    break block6;
                }
                Region region2 = region;
                synchronized (region2) {
                    region.clear();
                }
            }
            catch (Exception ex) {
                results.setCode((byte)1);
                results.setCodeMessage(ex.getMessage());
                results.setException(ex);
            }
        }
        return results;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.regionFullPath = DataSerializer.readString(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        DataSerializer.writeString(this.regionFullPath, output);
    }
}

