/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.RegionAttributeInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.DataSerializerEx;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RegionCreateTask
implements CommandTask {
    private static final long serialVersionUID = 1L;
    public static final byte SUCCESS_CREATED = 0;
    public static final byte ERROR_REGION_NOT_CREATED = 1;
    public static final byte ERROR_REGION_ALREADY_EXIST = 2;
    public static final byte ERROR_REGION_PARENT_DOES_NOT_EXIST = 3;
    public static final byte ERROR_REGION_INVALID_PATH = 4;
    private String regionFullPath;
    private RegionAttributeInfo attrInfo;

    public RegionCreateTask() {
    }

    public RegionCreateTask(String regionFullPath) {
        this(regionFullPath, null);
    }

    public RegionCreateTask(String regionFullPath, RegionAttributeInfo attrInfo) {
        this.regionFullPath = regionFullPath;
        this.attrInfo = attrInfo;
    }

    @Override
    public CommandResults runTask(Object userData) {
        return this.createRegion();
    }

    private CommandResults createRegion() {
        CommandResults results = new CommandResults();
        results.setCode((byte)0);
        Cache cache = CacheFactory.getAnyInstance();
        MemberInfo memberInfo = new MemberInfo();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        memberInfo.setHost(member.getHost());
        memberInfo.setMemberId(member.getId());
        memberInfo.setMemberName(cache.getName());
        memberInfo.setPid(member.getProcessId());
        results.setDataObject(memberInfo);
        if (this.regionFullPath == null) {
            results.setCode((byte)4);
            results.setCodeMessage("Invalid region path: " + this.regionFullPath);
            return results;
        }
        int index2 = this.regionFullPath.lastIndexOf("/");
        if (index2 == this.regionFullPath.length() - 1) {
            results.setCode((byte)4);
            results.setCodeMessage("Invalid region path: " + this.regionFullPath);
            return results;
        }
        String regionName = this.regionFullPath.substring(index2 + 1);
        try {
            Region<Object, Object> region = cache.getRegion(this.regionFullPath);
            if (region != null) {
                results.setCode((byte)2);
                results.setCodeMessage("Region already exist: " + this.regionFullPath);
            } else {
                Region parentRegion = RegionUtil.getParentRegion(this.regionFullPath);
                if (parentRegion == null) {
                    if (this.regionFullPath.split("/").length > 2) {
                        results.setCode((byte)3);
                        results.setCodeMessage("Parent region does not exist: " + this.regionFullPath);
                    } else {
                        region = this.attrInfo == null ? cache.createRegion(regionName, new AttributesFactory().create()) : cache.createRegion(regionName, this.attrInfo.createRegionAttributes());
                        if (region == null) {
                            results.setCode((byte)1);
                            results.setCodeMessage("Unable create region: " + this.regionFullPath);
                        } else {
                            results.setCodeMessage("Region created: " + region.getFullPath());
                        }
                    }
                } else {
                    region = this.attrInfo == null ? parentRegion.createSubregion(regionName, new AttributesFactory().create()) : parentRegion.createSubregion(regionName, this.attrInfo.createRegionAttributes());
                    if (region == null) {
                        results.setCode((byte)1);
                        results.setCodeMessage("Unable create region: " + this.regionFullPath);
                    } else {
                        results.setCodeMessage("Region created: " + region.getFullPath());
                    }
                }
            }
        }
        catch (CacheException ex) {
            results.setCode((byte)1);
            results.setException(ex);
        }
        return results;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.regionFullPath = DataSerializerEx.readUTF(input);
        this.attrInfo = (RegionAttributeInfo)DataSerializer.readObject(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        DataSerializerEx.writeUTF(this.regionFullPath, output);
        DataSerializer.writeObject(this.attrInfo, output);
    }
}

