/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RegionPathTask
implements CommandTask {
    private static final long serialVersionUID = 1L;
    private boolean regionsInDistributedSystem = false;
    private boolean recursive = true;
    private String parentRegionPath = null;

    public RegionPathTask() {
    }

    public RegionPathTask(boolean regionsInDistributedSystem, boolean recursive) {
        this(regionsInDistributedSystem, recursive, null);
    }

    public RegionPathTask(boolean regionsInDistributedSystem, boolean recursive, String parentRegionPath) {
        this.regionsInDistributedSystem = regionsInDistributedSystem;
        this.recursive = recursive;
        this.parentRegionPath = parentRegionPath;
    }

    @Override
    public CommandResults runTask(Object userData) {
        Region region;
        String[] regionPaths = null;
        Cache cache = CacheFactory.getAnyInstance();
        if (this.regionsInDistributedSystem) {
            if (this.parentRegionPath == null) {
                regionPaths = RegionUtil.getAllRegionPaths(CacheFactory.getAnyInstance(), this.recursive);
            } else {
                region = cache.getRegion(this.parentRegionPath);
                if (region != null) {
                    regionPaths = RegionUtil.getAllRegionPaths(region, this.recursive);
                }
            }
        } else if (this.parentRegionPath == null) {
            regionPaths = RegionUtil.getAllRegionPathsInDistributedSystem(cache.getDistributedSystem(), this.recursive);
        } else {
            region = cache.getRegion(this.parentRegionPath);
            if (region != null) {
                regionPaths = RegionUtil.getAllRegionPaths(region, this.recursive);
            }
        }
        CommandResults results = new CommandResults(regionPaths);
        return results;
    }

    public boolean isRegionsInDistributedSystem() {
        return this.regionsInDistributedSystem;
    }

    public void setRegionsInDistributedSystem(boolean regionsInDistributedSystem) {
        this.regionsInDistributedSystem = regionsInDistributedSystem;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getParentRegionPath() {
        return this.parentRegionPath;
    }

    public void setParentRegionPath(String parentRegionPath) {
        this.parentRegionPath = parentRegionPath;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.regionsInDistributedSystem = input.readBoolean();
        this.recursive = input.readBoolean();
        this.parentRegionPath = input.readUTF();
        if (this.parentRegionPath.equals("\u0000")) {
            this.parentRegionPath = null;
        }
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        output.writeBoolean(this.regionsInDistributedSystem);
        output.writeBoolean(this.recursive);
        if (this.parentRegionPath == null) {
            output.writeUTF("\u0000");
        } else {
            output.writeUTF(this.parentRegionPath);
        }
    }
}

