/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.MapMessage;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RegionSizeTask
implements CommandTask {
    private static final long serialVersionUID = 1L;
    private String regionFullPath;

    public RegionSizeTask() {
    }

    public RegionSizeTask(String regionFullPath) {
        this.regionFullPath = regionFullPath;
    }

    @Override
    public CommandResults runTask(Object userData) {
        CommandResults results = new CommandResults();
        try {
            Cache cache = CacheFactory.getAnyInstance();
            MapMessage message = new MapMessage();
            message.put("MemberId", cache.getDistributedSystem().getDistributedMember().getId());
            message.put("MemberName", cache.getDistributedSystem().getName());
            message.put("Host", cache.getDistributedSystem().getDistributedMember().getHost());
            message.put("Pid", cache.getDistributedSystem().getDistributedMember().getProcessId());
            Region region = cache.getRegion(this.regionFullPath);
            if (region == null) {
                results.setCode((byte)-1);
                results.setCodeMessage("Undefined region: " + this.regionFullPath);
            } else {
                message.put("RegionSize", region.size());
                results.setDataObject(message);
            }
            return results;
        }
        catch (CacheException ex) {
            results.setCode((byte)-1);
            results.setCodeMessage(ex.getMessage());
            results.setException(ex);
            return results;
        }
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.regionFullPath = DataSerializer.readString(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        DataSerializer.writeString(this.regionFullPath, output);
    }
}

