/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RegionAttributeInfo
implements DataSerializable {
    private static final long serialVersionUID = 1L;
    public static final String CONCURRENCY_LEVEL = "concurrency-level";
    public static final String DATA_POLICY = "data-policy";
    public static final String EARLY_ACK = "early-ack";
    public static final String ENABLE_ASYNC_CONFLATION = "enable-async-conflation";
    public static final String ENABLE_GATEWAY = "enable-gateway";
    public static final String ENABLE_SUBSCRIPTION_CONFLATION = "enable-subscription-conflation";
    public static final String HUB_ID = "hub-id";
    public static final String IGNORE_JTA = "ignore-jta";
    public static final String INDEX_UPDATE_TYPE = "index-update-type";
    public static final String INITIAL_CAPACITY = "initial-capacity";
    public static final String IS_LOCK_GRANTOR = "is-lock-grantor";
    public static final String LOAD_FACTOR = "load-factor";
    public static final String MULTICAST_ENABLED = "multicast-enabled";
    public static final String PUBLISHER = "publisher";
    public static final String SCOPE = "scope";
    public static final String STATISTICS_ENABLED = "statistics-enabled";
    public static final String REGION_TIME_TO_LIVE_TIMEOUT = "region-time-to-live.timeout";
    public static final String REGION_TIME_TO_LIVE_ACTION = "region-time-to-live.action";
    public static final String REGION_IDLE_TIME_TIMEOUT = "region-idle-time.timeout";
    public static final String REGION_IDLE_TIME_ACTION = "region-idle-time.action";
    public static final String ENTRY_TIME_TO_LIVE_TIMEOUT = "entry-time-to-live.timeout";
    public static final String ENTRY_TIME_TO_LIVE_ACTION = "entry-time-to-live.action";
    public static final String ENTRY_IDLE_TIME_TIMEOUT = "entry-idle-time.timeout";
    public static final String ENTRY_IDLE_TIME_ACTION = "entry-idle-time.action";
    public static final String DISK_DIRS_DISK_DIR = "disk-dirs.disk-dir";
    public static final String DISK_WRITE_ATTRIBUTES_MAX_OPLOG_SIZE = "disk-write-attributes.max-oplog-size";
    public static final String DISK_WRITE_ATTRIBUTES_ROLL_OPLOGS = "disk-write-attributes.roll-oplogs";
    public static final String DISK_WRITE_ATTRIBUTES_ASYNCHRONOUS_WRITES_TIME_INTERVAL = "disk-write-attributes.asynchronous-writes.time-interval";
    public static final String DISK_WRITE_ATTRIBUTES_ASYNCHRONOUS_WRITES_BYTES_THRESHOLD = "disk-write-attributes.asynchronous-writes.bytes-threshold";
    public static final String DISK_WRITE_ATTRIBUTES_SYNCHRONOUS_WRITES = "disk-write-attributes.synchronous-writes";
    public static final String MEMBERSHIP_ATTRIBUTES_LOSS_ACTION = "membership-attributes.loss-action";
    public static final String MEMBERSHIP_ATTRIBUTES_RESUMPTION_ACTION = "membership-attributes.resumption-action";
    public static final String MEMBERSHIP_ATTRIBUTES_REQUIRED_ROLE = "membership-attributes.resumption-action";
    public static final String SUBSCRIPTION_ATTRIBUTES_INTEREST_POLICY = "subscription-attributes.interest-policy";
    public static final String EVICTION_ATTRIBUTES_LRU_ENTRY_COUNT_ACTION = "eviction-attributes.lru-entry-count.action";
    public static final String EVICTION_ATTRIBUTES_LRU_ENTRY_COUNT_MAXIMUM = "eviction-attributes.lru-entry-count.maximum";
    public static final String EVICTION_ATTRIBUTES_LRU_MEMORY_SIZE_ACTION = "eviction-attributes.lru-memory-size.action";
    public static final String EVICTION_ATTRIBUTES_LRU_MEMORY_SIZE_MAXIMUM = "eviction-attributes.lru-memory-size.maximum";
    public static final String EVICTION_ATTRIBUTES_LRU_MEMORY_SIZE_CLASS_NAME = "eviction-attributes.lru-memory-size.class-name";
    public static final String EVICTION_ATTRIBUTES_LRU_MEMORY_SIZE_PARAMETER = "eviction-attributes.lru-memory-size.parameter";
    public static final String EVICTION_ATTRIBUTES_LRU_MEMORY_SIZE_PARAMETER_STRING = "eviction-attributes.lru-memory-size.parameter.string";
    public static final String EVICTION_ATTRIBUTES_LRU_MEMORY_SIZE_PARAMETER_DECLARABLE = "eviction-attributes.lru-memory-size.parameter.declarable";
    public static final String EVICTION_ATTRIBUTES_LRU_HEAP_PERCENTAGE_ACTION = "eviction-attributes.lru-heap-percentage.action";
    public static final String EVICTION_ATTRIBUTES_LRU_HEAP_PERCENTAGE_CLASS_NAME = "eviction-attributes.lru-heap-percentage.class-name";
    public static final String EVICTION_ATTRIBUTES_LRU_HEAP_PERCENTAGE_PARAMETER = "eviction-attributes.lru-heap-percentage.parameter";
    public static final String EVICTION_ATTRIBUTES_LRU_HEAP_PERCENTAGE_PARAMETER_STRING = "eviction-attributes.lru-heap-percentage.parameter.string";
    public static final String EVICTION_ATTRIBUTES_LRU_HEAP_PERCENTAGE_PARAMETER_DECLARABLE = "eviction-attributes.lru-heap-percentage.parameter.declarable";
    public static final String KEY_CONTRATINT = "key-constraint";
    public static final String VALUE_CONTRATINT = "value-constraint";
    public static final String CACHE_LISTENER_CLASS_NAME = "cache-listener.class-name";
    public static final String CACHE_LISTENER_PARAMETER_NAME = "cache-listener.parameter.name";
    public static final String CACHE_LISTENER_PARAMETER_STRING = "cache-listener.parameter.string";
    public static final String CACHE_LISTENER_PARAMETER_DECLARABLE_CLASS_NAME = "cache-listener.parameter.declarable.class-name";
    public static final String CACHE_LISTENER_PARAMETER_DECLARABLE_PARAMETER_NAME = "cache-listener.parameter.declarable.parameter.name";
    public static final String CACHE_LISTENER_PARAMETER_DECLARABLE_PARAMETER_STRING = "cache-listener.parameter.declarable.parameter.string";
    public static final String LOCAL_MAX_MEMORY = "local-max-memory";
    public static final String REDUNDANT_COPIES = "redundant-copies";
    public static final String TOTAL_MAX_MEMORY = "total-max-memory";
    public static final String TOTAL_NUM_BUCKETS = "total-num-buckets";
    private int versionId = 1;
    private HashMap attrProperties = new HashMap();

    public RegionAttributeInfo() {
    }

    public RegionAttributeInfo(Properties attrProperties) {
        this.attrProperties.putAll(attrProperties);
    }

    public void setAttribute(String attributeName, String value2) {
        this.attrProperties.put(attributeName, value2);
    }

    public String getAttribute(String attributeName) {
        return (String)this.attrProperties.get(attributeName);
    }

    public RegionAttributes createRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory partitionAttrFactory = null;
        Set entrySet = this.attrProperties.entrySet();
        for (Map.Entry entry : entrySet) {
            String action;
            int timeout;
            String attr = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            value2 = value2.replace('-', '_');
            if (attr.equals(CONCURRENCY_LEVEL)) {
                factory.setConcurrencyLevel(Integer.parseInt(value2));
                continue;
            }
            if (attr.equals(DATA_POLICY)) {
                if (value2.equalsIgnoreCase(DataPolicy.EMPTY.toString())) {
                    factory.setDataPolicy(DataPolicy.EMPTY);
                    continue;
                }
                if (value2.equalsIgnoreCase(DataPolicy.NORMAL.toString())) {
                    factory.setDataPolicy(DataPolicy.NORMAL);
                    continue;
                }
                if (value2.equalsIgnoreCase(DataPolicy.PARTITION.toString())) {
                    factory.setDataPolicy(DataPolicy.PARTITION);
                    continue;
                }
                if (value2.equalsIgnoreCase(DataPolicy.PERSISTENT_REPLICATE.toString())) {
                    factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    continue;
                }
                if (value2.equalsIgnoreCase(DataPolicy.PRELOADED.toString())) {
                    factory.setDataPolicy(DataPolicy.PRELOADED);
                    continue;
                }
                if (!value2.equalsIgnoreCase(DataPolicy.REPLICATE.toString())) continue;
                factory.setDataPolicy(DataPolicy.REPLICATE);
                continue;
            }
            if (attr.equals(EARLY_ACK)) {
                factory.setEarlyAck(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(ENABLE_ASYNC_CONFLATION)) {
                factory.setEnableAsyncConflation(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(ENABLE_GATEWAY)) {
                factory.setEnableGateway(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(ENABLE_SUBSCRIPTION_CONFLATION)) {
                factory.setEnableSubscriptionConflation(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(HUB_ID)) {
                factory.setGatewayHubId(value2);
                continue;
            }
            if (attr.equals(IGNORE_JTA)) {
                factory.setIgnoreJTA(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(INDEX_UPDATE_TYPE)) {
                factory.setIndexMaintenanceSynchronous(value2.equals("asynchronous"));
                continue;
            }
            if (attr.equals(INITIAL_CAPACITY)) {
                factory.setInitialCapacity(Integer.parseInt(value2));
                continue;
            }
            if (attr.equals(IS_LOCK_GRANTOR)) {
                factory.setLockGrantor(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(LOAD_FACTOR)) {
                factory.setLoadFactor(Float.parseFloat(value2));
                continue;
            }
            if (attr.equals(MULTICAST_ENABLED)) {
                factory.setMulticastEnabled(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(PUBLISHER)) {
                factory.setPublisher(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(SCOPE)) {
                if (value2.equalsIgnoreCase(Scope.DISTRIBUTED_ACK.toString())) {
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    continue;
                }
                if (value2.equalsIgnoreCase(Scope.DISTRIBUTED_NO_ACK.toString())) {
                    factory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    continue;
                }
                if (value2.equalsIgnoreCase(Scope.GLOBAL.toString())) {
                    factory.setScope(Scope.GLOBAL);
                    continue;
                }
                if (!value2.equalsIgnoreCase(Scope.LOCAL.toString())) continue;
                factory.setScope(Scope.LOCAL);
                continue;
            }
            if (attr.equals(STATISTICS_ENABLED)) {
                factory.setStatisticsEnabled(Boolean.parseBoolean(value2));
                continue;
            }
            if (attr.equals(LOCAL_MAX_MEMORY)) {
                if (partitionAttrFactory == null) {
                    partitionAttrFactory = new PartitionAttributesFactory();
                }
                partitionAttrFactory.setLocalMaxMemory(Integer.parseInt(value2));
                continue;
            }
            if (attr.equals(REDUNDANT_COPIES)) {
                if (partitionAttrFactory == null) {
                    partitionAttrFactory = new PartitionAttributesFactory();
                }
                partitionAttrFactory.setRedundantCopies(Integer.parseInt(value2));
                continue;
            }
            if (attr.equals(TOTAL_MAX_MEMORY)) {
                if (partitionAttrFactory == null) {
                    partitionAttrFactory = new PartitionAttributesFactory();
                }
                partitionAttrFactory.setTotalMaxMemory(Integer.parseInt(value2));
                continue;
            }
            if (attr.equals(TOTAL_NUM_BUCKETS)) {
                if (partitionAttrFactory == null) {
                    partitionAttrFactory = new PartitionAttributesFactory();
                }
                partitionAttrFactory.setTotalNumBuckets(Integer.parseInt(value2));
                continue;
            }
            if (attr.equals(ENTRY_IDLE_TIME_TIMEOUT)) {
                timeout = Integer.parseInt(value2);
                action = (String)this.attrProperties.get(ENTRY_IDLE_TIME_ACTION);
                factory.setEntryIdleTimeout(new ExpirationAttributes(timeout, this.getExpirationAction(action)));
                continue;
            }
            if (attr.equals(ENTRY_TIME_TO_LIVE_TIMEOUT)) {
                timeout = Integer.parseInt(value2);
                action = (String)this.attrProperties.get(ENTRY_TIME_TO_LIVE_ACTION);
                factory.setEntryTimeToLive(new ExpirationAttributes(timeout, this.getExpirationAction(action)));
                continue;
            }
            if (attr.equals(REGION_IDLE_TIME_TIMEOUT)) {
                timeout = Integer.parseInt(value2);
                action = (String)this.attrProperties.get(REGION_IDLE_TIME_ACTION);
                factory.setRegionIdleTimeout(new ExpirationAttributes(timeout, this.getExpirationAction(action)));
                continue;
            }
            if (!attr.equals(REGION_TIME_TO_LIVE_TIMEOUT)) continue;
            timeout = Integer.parseInt(value2);
            action = (String)this.attrProperties.get(REGION_TIME_TO_LIVE_ACTION);
            factory.setRegionTimeToLive(new ExpirationAttributes(timeout, this.getExpirationAction(action)));
        }
        if (partitionAttrFactory != null) {
            factory.setPartitionAttributes(partitionAttrFactory.create());
        }
        return factory.create();
    }

    private ExpirationAction getExpirationAction(String action) {
        if (action == null) {
            return ExpirationAttributes.DEFAULT.getAction();
        }
        if ((action = action.replace('-', '_')).equalsIgnoreCase(ExpirationAction.DESTROY.toString())) {
            return ExpirationAction.DESTROY;
        }
        if (action.equalsIgnoreCase(ExpirationAction.INVALIDATE.toString())) {
            return ExpirationAction.INVALIDATE;
        }
        if (action.equalsIgnoreCase(ExpirationAction.LOCAL_DESTROY.toString())) {
            return ExpirationAction.LOCAL_DESTROY;
        }
        if (action.equalsIgnoreCase(ExpirationAction.LOCAL_INVALIDATE.toString())) {
            return ExpirationAction.LOCAL_INVALIDATE;
        }
        return ExpirationAttributes.DEFAULT.getAction();
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.versionId = in.readInt();
        this.attrProperties = (HashMap)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.versionId);
        DataSerializer.writeObject(this.attrProperties, out);
    }
}

