/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;

public class cd
implements CommandExecutable {
    private Gfsh gfsh;
    private String previousPath;

    public cd(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("cd [-] | [-?] <region path>");
        this.gfsh.println("     Change region path.");
        this.gfsh.println("     - Change region path to the previous path.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("cd -?")) {
            this.help();
        } else if (command.equals("cd -")) {
            this.cd_prev();
        } else {
            this.cd(command);
        }
    }

    private void cd_prev() {
        this.chdir(this.previousPath);
    }

    private void cd(String command) {
        int index2 = command.indexOf(" ");
        if (index2 == -1) {
            this.chdir("/");
        } else {
            String newPath = command.substring(index2).trim();
            this.chdir(newPath);
        }
    }

    private void chdir(String newPath) {
        if (newPath == null) {
            return;
        }
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(newPath, currentPath);
        if (fullPath == null) {
            this.gfsh.println("Error: invalid region path");
        } else if (fullPath.equals("/")) {
            this.gfsh.setCurrentRegion(null);
            this.gfsh.setCurrentPath(fullPath);
            this.previousPath = currentPath;
        } else {
            Region currentRegion = this.gfsh.getCache().getRegion(fullPath);
            if (currentRegion == null) {
                this.gfsh.println("Error: undefined region path " + fullPath);
                return;
            }
            this.gfsh.setCurrentPath(fullPath);
            this.gfsh.setCurrentRegion(currentRegion);
            this.previousPath = currentPath;
        }
    }
}

