/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.MapMessage;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandClient;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionClearTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.util.LinkedList;
import java.util.List;

public class clear
implements CommandExecutable {
    private Gfsh gfsh;

    public clear(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("clear [-a|-g|-s] [<region path>] | [-?]");
        this.gfsh.println("     Clear the local region. If <region path> is not specified");
        this.gfsh.println("     then it clears the current region. The region path");
        this.gfsh.println("     can be absolute or relative.");
        this.gfsh.println("     -a Clear both the local region and the server region.");
        this.gfsh.println("        The region clear will be distributed to other caches if the");
        this.gfsh.println("        scope is not Scope.LOCAL.");
        this.gfsh.println("     -g Clear globally. Clear the local region and all server");
        this.gfsh.println("        regions regardless of scope. This option also clears server");
        this.gfsh.println("        regions with Scope.LOCAL. Use this option to clear partioned");
        this.gfsh.println("        regions. GFE 5.7 partitioned region is not supported.");
        this.gfsh.println("     -s Clear only the server region. The local region is not cleared.");
        this.gfsh.println("        The region clear will be distributed to other caches if the");
        this.gfsh.println("        scope is not Scope.LOCAL.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("clear -?")) {
            this.help();
        } else if (command.startsWith("clear -a")) {
            this.clear_a(command);
        } else if (command.startsWith("clear -g")) {
            this.clear_g(command);
        } else if (command.startsWith("clear -s")) {
            this.clear_s(command);
        } else {
            this.clear_local(command);
        }
    }

    private void clear_local(String command) {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        regionPath = list.size() > 1 ? (String)list.get(1) : this.gfsh.getCurrentPath();
        this.clearLocalRegion(regionPath);
    }

    private void clearLocalRegion(String regionPath) {
        Region region = this.gfsh.getCache().getRegion(regionPath);
        if (region == null) {
            this.gfsh.println("Error: Undefined region path " + regionPath);
        } else {
            region.localClear();
            this.gfsh.println("Local region cleared: " + region.getFullPath());
        }
    }

    private void clear_a(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        regionPath = list.size() > 2 ? (String)list.get(2) : this.gfsh.getCurrentPath();
        this.clear_server(regionPath, false);
        this.clearLocalRegion(regionPath);
    }

    private void clear_g(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        regionPath = list.size() > 2 ? (String)list.get(2) : this.gfsh.getCurrentPath();
        this.clear_server(regionPath, true);
        this.clearLocalRegion(regionPath);
    }

    private void clear_s(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        regionPath = list.size() > 2 ? (String)list.get(2) : this.gfsh.getCurrentPath();
        this.clear_server(regionPath, false);
    }

    private void clear_server(String regionPath, boolean global) throws Exception {
        if (regionPath == null) {
            return;
        }
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        if (fullPath == null) {
            this.gfsh.println("Error: invalid region path");
        } else if (fullPath.equals("/")) {
            this.gfsh.println("Error: cannot clear top level");
        } else {
            String confirmation = this.gfsh.getLine("This command will clear the region " + fullPath + " from the server(s). \nDo you want to proceed? (yes|no): ");
            if (!confirmation.equalsIgnoreCase("yes")) {
                this.gfsh.println("Command aborted.");
                return;
            }
            if (global) {
                Aggregator aggregator = this.gfsh.getAggregator();
                List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("clear", fullPath, null), this.gfsh.getAggregateRegionPath());
                int i = 1;
                for (AggregateResults aggregateResults : results) {
                    MapMessage message;
                    GfshData data = (GfshData)aggregateResults.getDataObject();
                    if (data.getDataObject() != null && (message = (MapMessage)data.getDataObject()).getBoolean("IsPeerClient")) continue;
                    MemberInfo memberInfo = data.getMemberInfo();
                    this.gfsh.print(i + ". " + memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                    if (aggregateResults.getCode() == -1) {
                        this.gfsh.println("error - " + aggregateResults.getCodeMessage());
                        if (this.gfsh.isDebug() && aggregateResults.getException() != null) {
                            aggregateResults.getException().printStackTrace();
                        }
                    } else {
                        Region region = RegionUtil.getRegion(fullPath, Scope.LOCAL, DataPolicy.NORMAL, null);
                        this.gfsh.println("region cleared: " + region.getFullPath());
                    }
                    ++i;
                }
            } else {
                CommandClient commandClient = this.gfsh.getCommandClient();
                CommandResults commandResults = commandClient.execute(new RegionClearTask(fullPath));
                MemberInfo memberInfo = (MemberInfo)commandResults.getDataObject();
                this.gfsh.print(memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                if (commandResults.getCode() == 1) {
                    this.gfsh.println("error - " + commandResults.getCodeMessage());
                    if (this.gfsh.isDebug() && commandResults.getException() != null) {
                        commandResults.getException().printStackTrace();
                    }
                } else {
                    Region region = RegionUtil.getRegion(regionPath, Scope.LOCAL, DataPolicy.NORMAL, null);
                    this.gfsh.println("region cleared: " + region.getFullPath());
                }
            }
        }
    }
}

