/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;

public class connect
implements CommandExecutable {
    private Gfsh gfsh;

    public connect(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("connect [-s <host:port> | -l <host:port> [<server group>]] | [-?]");
        this.gfsh.println("     -s <host:port>  Connect to the specified cache servers.");
        this.gfsh.println("     -l <host:port> [<server group>] Connect to the specified locator");
        this.gfsh.println("           and the server group if specified.");
        this.gfsh.println("     -t <readTimeout>  readTimeout in msec.");
        this.gfsh.println("            The default value is 300000 ms (5 min).");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("connect -?")) {
            this.help();
        } else {
            this.connect(command);
            if (this.gfsh.isConnected()) {
                this.gfsh.execute("refresh");
            }
        }
    }

    private void connect(String command) {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 3) {
            this.gfsh.println("Error: incomplete command.");
            return;
        }
        String endpoints = null;
        String locators = null;
        String serverGroup = null;
        int readTimeout = 300000;
        try {
            for (int i = 1; i < list.size(); ++i) {
                String token = (String)list.get(i);
                if (token.equals("-s")) {
                    endpoints = (String)list.get(++i);
                    continue;
                }
                if (token.equals("-l")) {
                    locators = (String)list.get(++i);
                    if (i >= list.size() - 1 || ((String)list.get(i + 1)).startsWith("-")) continue;
                    serverGroup = (String)list.get(++i);
                    continue;
                }
                if (!token.equals("-t")) continue;
                readTimeout = Integer.parseInt((String)list.get(++i));
            }
        }
        catch (Exception ex) {
            this.gfsh.println("Error: invalid command - " + command);
            return;
        }
        if (endpoints != null && locators != null) {
            this.gfsh.println("Error: invalid command. -s and -l are not allowed together.");
        }
        if (endpoints != null) {
            this.gfsh.setEndpoints(endpoints, false, null, readTimeout);
            this.connect();
        }
        if (locators != null) {
            this.gfsh.setEndpoints(locators, true, serverGroup, readTimeout);
            this.connect();
        }
    }

    @SuppressFBWarnings(value={"NM_METHOD_CONSTRUCTOR_CONFUSION"}, justification="This is method and not constructor")
    private void connect() {
        block4: {
            try {
                this.gfsh.reconnect();
                this.gfsh.setCurrentPath("/");
                this.gfsh.setCurrentRegion(null);
                if (this.gfsh.isConnected()) {
                    this.gfsh.println("connected: " + this.gfsh.getEndpoints());
                } else {
                    this.gfsh.println("Error: Endpoints set but unable to connect: " + this.gfsh.getEndpoints());
                }
            }
            catch (Exception ex) {
                this.gfsh.println(this.gfsh.getCauseMessage(ex));
                if (!this.gfsh.isDebug()) break block4;
                ex.printStackTrace();
            }
        }
    }
}

