/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class deploy
implements CommandExecutable {
    private Gfsh gfsh;
    private static int BUFFER_SIZE = 10000;

    public deploy(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("deploy [-jar <jar paths>]");
        this.gfsh.println("       [-dir [-r] <directory>]");
        this.gfsh.println("       [-?]");
        this.gfsh.println("   Deploys the specified jar or class files to all of the servers.");
        this.gfsh.println("     -jar <jar paths> Load all classes in the jar paths. The jar paths");
        this.gfsh.println("            can be separated by ',', ';', or ':'. The jar paths");
        this.gfsh.println("            can be relative or absolute.");
        this.gfsh.println("     -dir [-r] <directory> Load all jar files in the directory.");
        this.gfsh.println("            '-r' recursively loads all jar files including sub-directories.");
        this.gfsh.println("            The directory path can be relative or absolute.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("deploy -?")) {
            this.help();
        } else if (command.startsWith("deploy -dir")) {
            this.deploy_dir(command);
        } else if (command.startsWith("deploy -jar")) {
            this.deploy_jar(command);
        } else {
            this.gfsh.println("Error: invalid command - " + command);
        }
    }

    private byte[] readJar(File file) throws FileNotFoundException, IOException {
        byte[] buffer;
        int bytesRead;
        FileInputStream fis = new FileInputStream(file);
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        int lastBytesRead = 0;
        do {
            if ((bytesRead = fis.read(buffer = new byte[BUFFER_SIZE])) == -1) continue;
            lastBytesRead = bytesRead;
            byteList.add(buffer);
        } while (bytesRead != -1);
        fis.close();
        int lastIndex = byteList.size() - 1;
        int bufferLength = lastIndex * BUFFER_SIZE + lastBytesRead;
        int destPos = 0;
        buffer = new byte[bufferLength];
        for (int j = 0; j < lastIndex; ++j) {
            byte[] srcBuffer = (byte[])byteList.get(j);
            destPos = j * BUFFER_SIZE;
            System.arraycopy(srcBuffer, 0, buffer, destPos, srcBuffer.length);
        }
        if (lastIndex >= 0) {
            byte[] srcBuffer = (byte[])byteList.get(lastIndex);
            destPos = lastIndex * BUFFER_SIZE;
            System.arraycopy(srcBuffer, 0, buffer, destPos, lastBytesRead);
        }
        return buffer;
    }

    private void deploy(String[] jarPaths) {
        block8: {
            if (jarPaths == null || jarPaths.length == 0) {
                this.gfsh.println("Error: must specify the jar path(s)");
                return;
            }
            try {
                String[] jarNames = new String[jarPaths.length];
                byte[][] payloadBuffers = new byte[jarPaths.length][];
                for (int i = 0; i < jarPaths.length; ++i) {
                    String path = jarPaths[i];
                    if (path == null) continue;
                    path = path.trim();
                    File file = new File(path);
                    jarNames[i] = file.getName();
                    payloadBuffers[i] = this.readJar(file);
                }
                long startTime = System.currentTimeMillis();
                List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("deploy", null, new Object[]{"-jar", jarNames, payloadBuffers}), this.gfsh.getAggregateRegionPath());
                long stopTime = System.currentTimeMillis();
                int i = 1;
                for (AggregateResults aggregateResults : results) {
                    GfshData data = (GfshData)aggregateResults.getDataObject();
                    MemberInfo memberInfo = data.getMemberInfo();
                    String message = (String)data.getDataObject();
                    this.gfsh.print(i + ". " + memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                    this.gfsh.println(message);
                    ++i;
                }
                this.gfsh.print("deployed files: ");
                for (i = 0; i < jarNames.length - 1; ++i) {
                    this.gfsh.print(jarNames[i] + ", ");
                }
                if (jarNames.length > 0) {
                    this.gfsh.println(jarNames[jarNames.length - 1]);
                }
                this.gfsh.println();
                if (this.gfsh.isShowTime()) {
                    this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
                }
            }
            catch (Exception ex) {
                this.gfsh.println("Error: " + ex.getClass().getSimpleName() + " - " + ex.getMessage());
                if (!this.gfsh.isDebug()) break block8;
                ex.printStackTrace();
            }
        }
    }

    private void deploy_jar(String command) {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 3) {
            this.gfsh.println("Error: must specify the jar path(s)");
            return;
        }
        String jarPaths = "";
        for (int i = 2; i < list.size(); ++i) {
            jarPaths = jarPaths + list.get(i);
        }
        jarPaths = jarPaths.trim();
        String pathSeparator = System.getProperty("path.separator");
        jarPaths = jarPaths.replace(pathSeparator.charAt(0), ',');
        String[] split = jarPaths.split(",");
        this.deploy(split);
    }

    private void deploy_dir(String command) {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 3) {
            this.gfsh.println("Error: must specify the directory path");
            return;
        }
        String dirPath = (String)list.get(2);
        if (dirPath == null) {
            return;
        }
        if ((dirPath = dirPath.trim()).length() == 0) {
            this.gfsh.println("Error: directory not specified");
            return;
        }
        File file = new File(dirPath);
        if (!file.exists()) {
            this.gfsh.println("Error: direcotry " + dirPath + " does not exist");
            return;
        }
        ArrayList<File> jarFileList = this.getJarFiles(file, false);
        if (jarFileList.size() == 0) {
            this.gfsh.println("jar files not found in directory " + dirPath);
            return;
        }
        String[] jarPaths = new String[jarFileList.size()];
        int i = 0;
        for (File file2 : jarFileList) {
            jarPaths[i++] = file2.getAbsolutePath();
        }
        this.deploy(jarPaths);
    }

    private ArrayList<File> getJarFiles(File dir, boolean recursive) {
        return this.getJarFiles(dir, new ArrayList<File>(), recursive);
    }

    private ArrayList<File> getJarFiles(File dir, ArrayList<File> fileList, boolean recursive) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() && pathname.getName().endsWith(".jar");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            fileList.add(files[i]);
        }
        if (recursive) {
            File[] dirs = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            for (int i = 0; i < dirs.length; ++i) {
                fileList = this.getJarFiles(dirs[i], fileList, recursive);
            }
        }
        return fileList;
    }
}

