/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import java.util.LinkedList;
import java.util.List;

public class gc
implements CommandExecutable {
    private Gfsh gfsh;

    public gc(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("gc [-g] [-m <member id>] | [-?]");
        this.gfsh.println("     Force gc on the connected server or all of the servers.");
        this.gfsh.println("     -g  Force gc globally on all servers.");
        this.gfsh.println("     -m <member id>  Force gc on the specified member. The member id can");
        this.gfsh.println("            be obtained by executing 'size -m' or 'ls -m'");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("gc -?")) {
            this.help();
        } else if (command.startsWith("gc -g")) {
            this.gc(command);
        } else if (command.startsWith("gc -m")) {
            this.gc(command);
        } else {
            this.gfsh.println("Error: invalid gc option.");
        }
    }

    private void gc(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        boolean isGlobal = false;
        String memberId = null;
        if (command.startsWith("gc -m")) {
            if (list.size() > 2) {
                memberId = (String)list.get(2);
            }
        } else if (command.startsWith("gc -g")) {
            isGlobal = true;
        }
        if (!isGlobal && memberId == null) {
            this.gfsh.println("Error: invalid option. 'gc -m' requires <member id>. Use 'size -m' or 'ls -m' to list member ids.");
            return;
        }
        String confirmation = this.gfsh.getLine("This command forc gc on the server(s).\nDo you want to proceed? (yes|no): ");
        if (!confirmation.equalsIgnoreCase("yes")) {
            this.gfsh.println("Command aborted.");
            return;
        }
        Aggregator aggregator = this.gfsh.getAggregator();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("gc", this.gfsh.getCurrentPath(), memberId), this.gfsh.getAggregateRegionPath());
        int i = 1;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            MemberInfo memberInfo = data.getMemberInfo();
            if (isGlobal || memberId != null && memberId.equals(memberInfo.getMemberId())) {
                this.gfsh.print(i + ". " + memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                if (aggregateResults.getCode() == -1) {
                    this.gfsh.println("error - " + aggregateResults.getCodeMessage());
                    if (this.gfsh.isDebug() && aggregateResults.getException() != null) {
                        aggregateResults.getException().printStackTrace();
                    }
                } else {
                    this.gfsh.println("GC forced");
                }
            }
            ++i;
        }
    }
}

