/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.ObjectUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class get
implements CommandExecutable {
    private Gfsh gfsh;

    public get(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("get [<query predicate>] | [-k <number list>] | [-?]");
        this.gfsh.println("     Get value from the current region.");
        this.gfsh.println("        <query predicate>: field=val1 and field2='val1' \\");
        this.gfsh.println("                           and field3=to_date('<date>', '<format>')");
        this.gfsh.println("     Data formats: primitives, String, and java.util.Date");
        this.gfsh.println("         <decimal>b|B - Byte      (e.g., 1b)");
        this.gfsh.println("         <decimal>c|C - Character (e.g., 1c)");
        this.gfsh.println("         <decimal>s|S - Short     (e.g., 12s)");
        this.gfsh.println("         <decimal>i|I - Integer   (e.g., 15 or 15i)");
        this.gfsh.println("         <decimal>l|L - Long      (e.g., 20l)");
        this.gfsh.println("         <decimal>f|F - Float     (e.g., 15.5 or 15.5f)");
        this.gfsh.println("         <decimal>d|D - Double    (e.g., 20.0d)");
        this.gfsh.println("         '<string with \\ delimiter>' (e.g., '\\'Wow!\\'!' Hello, world')");
        this.gfsh.println("         to_date('<date string>', '<simple date format>')");
        this.gfsh.println("                       (e.g., to_date('04/10/2009', 'MM/dd/yyyy')");
        this.gfsh.println("     -k <number list>   Get values from the current region using the");
        this.gfsh.println("                        enumerated keys. Use 'ls -k' to get the list");
        this.gfsh.println("                        of enumerated keys.");
        this.gfsh.println("     <number list> format: num1 num2 num3-num5 ... e.g., 'get -k 1 2 4 10-20'");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("get -?")) {
            this.help();
        } else if (command.startsWith("get -k")) {
            this.get_k(command);
        } else if (command.startsWith("get")) {
            this.get(command);
        }
    }

    private void get(String command) throws Exception {
        if (this.gfsh.getCurrentRegion() == null) {
            this.gfsh.println("Error: Region undefined. Use 'cd' to change region first before executing this command.");
            return;
        }
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.gfsh.println("Error: get requires a query predicate");
        } else {
            String input = (String)list.get(1);
            Object key2 = null;
            if (input.startsWith("'")) {
                int lastIndex = -1;
                lastIndex = !input.endsWith("'") ? input.length() : input.lastIndexOf("'");
                if (lastIndex <= 1) {
                    this.gfsh.println("Error: Invalid key. Empty string not allowed.");
                    return;
                }
                key2 = input.subSequence(1, lastIndex);
            } else {
                key2 = ObjectUtil.getPrimitive(this.gfsh, input, false);
                if (key2 == null) {
                    key2 = this.gfsh.getQueryKey(list, 1);
                }
            }
            if (key2 == null) {
                return;
            }
            long startTime = System.currentTimeMillis();
            Object value2 = this.gfsh.getCurrentRegion().get(key2);
            long stopTime = System.currentTimeMillis();
            if (value2 == null) {
                this.gfsh.println("Key not found.");
                return;
            }
            HashMap<Integer, Object> keyMap = new HashMap<Integer, Object>();
            keyMap.put(1, key2);
            PrintUtil.printEntries(this.gfsh.getCurrentRegion(), keyMap, null);
            if (this.gfsh.isShowTime()) {
                this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
            }
        }
    }

    private void get_k(String command) throws Exception {
        if (this.gfsh.getCurrentRegion() == null) {
            this.gfsh.println("Error: Region undefined. Use 'cd' to change region first before executing this command.");
            return;
        }
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 3) {
            this.gfsh.println("Error: get -k requires number(s)");
            return;
        }
        if (this.gfsh.getLsKeyList() == null) {
            this.gfsh.println("Error: No keys obtained. Execute 'ls -k' first to obtain the keys");
            return;
        }
        Map keyMap = this.gfsh.getKeyMap(list, 2);
        long startTime = System.currentTimeMillis();
        this.gfsh.getCurrentRegion().getAll(keyMap.values());
        long stopTime = System.currentTimeMillis();
        if (this.gfsh.isShowResults()) {
            PrintUtil.printEntries(this.gfsh.getCurrentRegion(), keyMap, null);
        } else {
            this.gfsh.println("Fetched: " + keyMap.size());
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }
}

