/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.command.index;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class index
implements CommandExecutable {
    private Gfsh gfsh;
    private static List<String> mappableKeyList = new ArrayList<String>();
    private static List<String> mappableStatsList;

    public index(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("index [-m <member id>|-g] -n <index name> -e <expression> -from <from clause>");
        this.gfsh.println("      [-i <imports>]");
        this.gfsh.println("      [-primary|-functional] ");
        this.gfsh.println("      [-r <region path>]");
        this.gfsh.println("      [-?]");
        this.gfsh.println("      Creates the specified index in the current or specified region.");
        this.gfsh.println("      -m <member id> Execute the index command on the specified member only");
        this.gfsh.println("      -g Execute the index command on all members");
        this.gfsh.println("      -n <index name> Unique index name.");
        this.gfsh.println("      -e Index expression.");
        this.gfsh.println("      -from <from clause>  From clause.");
        this.gfsh.println("      [-i <imports>] Import statments separated by ; in double quotes,");
        this.gfsh.println("                    e.g., -i \"import com.foo.ClassA;import com.fool.ClassB\"");
        this.gfsh.println("      [-primary|-functional] Create a primary index or a functional index.");
        this.gfsh.println("                    Default: -functional");
        this.gfsh.println("index [-m <member id>|-g] [-all] [-r <region path>]");
        this.gfsh.println("      List indexes created in the current or specified region. Default: -g");
        this.gfsh.println("      -stats Display index statistics along with index info.");
        this.gfsh.println("      -m <member id> Execute the index command on the specified member only");
        this.gfsh.println("      -g Execute the index command on all members");
        this.gfsh.println("      -all List indexes in all regions.");
        this.gfsh.println("      [-r <region path>] Region path. If not specified, the current region");
        this.gfsh.println("                         is used.");
        this.gfsh.println("index -stats [-m <member id>|-g] [-all] [-r <region path>]");
        this.gfsh.println("      Display index statistics in the current or specified region. Default: -g");
        this.gfsh.println("      -m <member id> Execute the index command on the specified member only");
        this.gfsh.println("      -g Execute the index command on all members");
        this.gfsh.println("      -all Display statistics for all indexes in all regions.");
        this.gfsh.println("index -d [-m <member id>|-g] -n <index name>|-region|-all [-r <region path>]");
        this.gfsh.println("      Delete the specified index in the current or specified region. Default: -g");
        this.gfsh.println("      -m <member id> Execute the index command on the specified member only");
        this.gfsh.println("      -g Execute the index command on all members");
        this.gfsh.println("      -all Delete indexes in all regions.");
        this.gfsh.println("      -n <index name> Delete the specified index in the current or specified region.");
        this.gfsh.println("      -region Delete all indexes in the current or specified region.");
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("index -?")) {
            this.help();
        } else {
            this.index(command);
        }
    }

    private void index(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        boolean all = false;
        boolean delete = false;
        boolean isRegion = false;
        String indexName = null;
        String expression = null;
        String fromClause = null;
        String imports = null;
        boolean global = false;
        String memberId = null;
        boolean isFunctionalIndex = true;
        boolean stats = false;
        for (int i = 1; i < list.size(); ++i) {
            String token = (String)list.get(i);
            if (token.equals("-all")) {
                all = true;
                continue;
            }
            if (token.equals("-d")) {
                delete = true;
                continue;
            }
            if (token.equals("-region")) {
                isRegion = true;
                continue;
            }
            if (token.equals("-r")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-r' requires region path");
                    return;
                }
                regionPath = (String)list.get(++i);
                continue;
            }
            if (token.equals("-n")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-n' requires index name");
                    return;
                }
                indexName = (String)list.get(++i);
                continue;
            }
            if (token.equals("-e")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-e' requires expression");
                    return;
                }
                expression = (String)list.get(++i);
                continue;
            }
            if (token.equals("-from")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-from' requires from-clause");
                    return;
                }
                fromClause = (String)list.get(++i);
                continue;
            }
            if (token.equals("-i")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-i' requires imports");
                    return;
                }
                imports = (String)list.get(++i);
                continue;
            }
            if (token.equals("-m")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-m' requires member Id");
                    return;
                }
                memberId = (String)list.get(++i);
                continue;
            }
            if (token.equals("-g")) {
                global = true;
                continue;
            }
            if (token.equals("-primary")) {
                isFunctionalIndex = false;
                continue;
            }
            if (token.equals("-functional")) {
                isFunctionalIndex = true;
                continue;
            }
            if (token.equals("-stats")) {
                stats = true;
                continue;
            }
            this.gfsh.println("Error: invalid directive '" + token + "'");
            return;
        }
        if (global && memberId != null) {
            this.gfsh.println("Error: only one option is allowed: '-g' or '-m'");
            return;
        }
        if (delete && stats) {
            this.gfsh.println("Error: only one option is allowed: '-d' or '-stats'");
            return;
        }
        TASK task = TASK.LIST;
        task = delete ? TASK.DELETE : (indexName == null ? TASK.LIST : (stats ? TASK.STATS : TASK.CREATE));
        switch (task) {
            case LIST: {
                this.listIndexes(regionPath, memberId, all, stats);
                break;
            }
            case CREATE: {
                this.createIndexes(regionPath, memberId, indexName, isFunctionalIndex, expression, fromClause, imports);
                break;
            }
            case DELETE: {
                if (indexName != null && (all || isRegion)) {
                    this.gfsh.println("Error: '-n' not allowed with '-region' or '-all'");
                    return;
                }
                if (indexName == null && !all && !isRegion) {
                    this.gfsh.println("Error: '-d' requires '-n', '-region' or '-all'");
                    return;
                }
                index.DeleteType deleteType = all ? index.DeleteType.DELETE_ALL_INDEXES : (isRegion ? index.DeleteType.DELETE_REGION_INDEXES : index.DeleteType.DELETE_INDEX);
                this.deleteIndexes(deleteType, regionPath, memberId, indexName);
            }
        }
    }

    private void listIndexes(String regionPath, String memberId, boolean isAll, boolean isStats) throws Exception {
        String currentPath = this.gfsh.getCurrentPath();
        if (regionPath == null) {
            regionPath = currentPath;
        }
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        Aggregator aggregator = this.gfsh.getAggregator();
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("index", fullPath, new Object[]{"-list", memberId, isAll, isStats}), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        int i = 0;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            if (data == null) continue;
            Object obj = data.getDataObject();
            if (obj instanceof List) {
                List mappableList = (List)data.getDataObject();
                if (mappableList == null) continue;
                this.gfsh.println(++i + ". " + data.getMemberInfo().getMemberId() + " (" + data.getMemberInfo().getMemberName() + "): ");
                if (mappableList.size() > 0) {
                    Mappable mappable = (Mappable)mappableList.get(0);
                    if (mappable.size() < mappableStatsList.size()) {
                        isStats = false;
                    }
                    if (isStats) {
                        PrintUtil.printMappableList(mappableList, "Name", mappableStatsList);
                    } else {
                        PrintUtil.printMappableList(mappableList, "Name", mappableKeyList);
                    }
                }
                this.gfsh.println();
                continue;
            }
            if (obj == null) continue;
            this.gfsh.println(++i + ". " + data.getMemberInfo().getMemberId() + " (" + data.getMemberInfo().getMemberName() + "): " + obj);
            this.gfsh.println();
        }
        if (i == 0) {
            this.gfsh.println("Indexes not found");
            this.gfsh.println();
        }
    }

    private void createIndexes(String regionPath, String memberId, String indexName, boolean isFunctionalIndex, String expression, String fromClause, String imports) throws Exception {
        if (indexName == null) {
            this.gfsh.println("Error: '-n' (index name) is not specified.");
            return;
        }
        if (expression == null) {
            this.gfsh.println("Error: '-e' (index expression) is not specified.");
            return;
        }
        if (fromClause == null) {
            this.gfsh.println("Error: '-from' (from clause) is not specified.");
            return;
        }
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        Aggregator aggregator = this.gfsh.getAggregator();
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("index", fullPath, new Object[]{"-create", memberId, indexName, isFunctionalIndex, expression, fromClause, imports}), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        int i = 0;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            if (data == null) {
                this.gfsh.println(++i + ". " + aggregateResults.getCodeMessage());
                continue;
            }
            MemberInfo memberInfo = data.getMemberInfo();
            Object value2 = data.getDataObject();
            if (value2 != null) {
                this.gfsh.println(++i + ". " + memberInfo.getMemberId() + " (" + memberInfo.getMemberName() + "): " + value2);
                continue;
            }
            if (aggregateResults.getCodeMessage() == null) continue;
            this.gfsh.print(++i + ". " + memberInfo.getMemberId() + " (" + memberInfo.getMemberName() + "): ");
            this.gfsh.println(aggregateResults.getCodeMessage());
        }
        this.gfsh.println();
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }

    private void deleteIndexes(index.DeleteType deleteType, String regionPath, String memberId, String indexName) throws Exception {
        String message = "";
        switch (deleteType) {
            case DELETE_INDEX: 
            case DELETE_REGION_INDEXES: {
                if (regionPath != null) break;
                regionPath = this.gfsh.getCurrentPath();
            }
        }
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        switch (deleteType) {
            case DELETE_INDEX: {
                message = "This command will remove the " + indexName + " index from the " + fullPath + "region. \nDo you want to proceed? (yes|no): ";
                break;
            }
            case DELETE_REGION_INDEXES: {
                message = "This command will remove all of the indexes in the " + fullPath + " region. \nDo you want to proceed? (yes|no): ";
                break;
            }
            case DELETE_ALL_INDEXES: {
                message = "This command will remove all of the indexes from all of the members. \nDo you want to proceed? (yes|no): ";
            }
        }
        String confirmation = this.gfsh.getLine(message);
        if (!confirmation.equalsIgnoreCase("yes")) {
            this.gfsh.println("Command aborted.");
            return;
        }
        Aggregator aggregator = this.gfsh.getAggregator();
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("index", fullPath, new Object[]{"-delete", deleteType, memberId, indexName}), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        int i = 0;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            if (data == null) {
                this.gfsh.println(++i + ". " + aggregateResults.getCodeMessage());
                continue;
            }
            MemberInfo memberInfo = data.getMemberInfo();
            Object value2 = data.getDataObject();
            if (value2 == null) continue;
            this.gfsh.print(++i + ". " + memberInfo.getMemberId() + " (" + memberInfo.getMemberName() + "): ");
            this.gfsh.println(value2);
        }
        this.gfsh.println();
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }

    static {
        Collections.addAll(mappableKeyList, "Name", "Type", "Expression", "From");
        mappableStatsList = new ArrayList<String>();
        Collections.addAll(mappableStatsList, "Name", "Type", "Expression", "From", "Keys", "Values", "Updates", "TotalUpdateTime", "TotalUses");
    }

    private static enum TASK {
        LIST,
        CREATE,
        DELETE,
        STATS;

    }
}

