/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.LinkedList;
import java.util.List;

public class key
implements CommandExecutable {
    private Gfsh gfsh;

    public key(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("key [-l] [<class name>] | [-?]");
        this.gfsh.println("     Set the key class to be used for the 'get', 'put' and 'query'");
        this.gfsh.println("     commands. Use the 'value' command to set the value class name.");
        this.gfsh.println("     -l List the last enumerated keys. These keys were obtained");
        this.gfsh.println("        by executing one of the following commands: ");
        this.gfsh.println("        " + this.gfsh.getEnumCommands());
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("key -?")) {
            this.help();
        } else if (command.startsWith("key -l")) {
            this.key_l();
        } else {
            this.key(command);
        }
    }

    private void key(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.gfsh.println("key = " + this.gfsh.getQueryKeyClassName());
            this.gfsh.println("   Use key <class name> to set the key class");
        } else if (list.size() > 1) {
            this.gfsh.setKeyClass((String)list.get(1));
        }
    }

    private void key_l() throws Exception {
        List keyList = this.gfsh.getLsKeyList();
        if (this.gfsh.getLsKeyList() == null) {
            this.gfsh.println("Error: Key list undefined. The folowing commands create the key list: ");
            this.gfsh.println("       " + this.gfsh.getEnumCommands());
            return;
        }
        PrintUtil.printList(keyList);
    }
}

