/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.functions.util.RegionCreateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionCreateTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.RegionAttributeInfo;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.util.LinkedList;
import java.util.List;

public class mkdir
implements CommandExecutable {
    private Gfsh gfsh;

    public mkdir(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("mkdir [-g|-s] | [-?] <region path> [<attributes>]");
        this.gfsh.println("      [data-policy=");
        this.gfsh.println("     Create a region remotely and/or locally (local only by default). The region path can be");
        this.gfsh.println("     absolute or relative.");
        this.gfsh.println("     -g Create a region for all peers.");
        this.gfsh.println("     -s Create a region for the connected server only.");
        this.gfsh.println("     Region attributes:");
        this.gfsh.println("        concurrency-level=<integer [16]>");
        this.gfsh.println("        data-policy=" + mkdir.getDataPolicyValues() + " [" + DataPolicy.NORMAL.toString().toLowerCase().replace('_', '-') + "]");
        this.gfsh.println("        early-ack=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        enable-async-conflation=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        enable-gateway=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        enable-subscription-conflation=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        hub-id=<string>");
        this.gfsh.println("        ignore-jta=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        index-update-type=" + mkdir.getIndexUpdateTypeValues() + " [asynchronous]");
        this.gfsh.println("        initial-capacity=<integer> [16]");
        this.gfsh.println("        is-lock-grantor=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        load-factor=<float> [0.75]");
        this.gfsh.println("        multicast-enabled=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        publisher=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        statistics-enabled=" + mkdir.getTrueFalseValues() + " [false]");
        this.gfsh.println("        scope=" + mkdir.getScopeValues() + " [" + Scope.DISTRIBUTED_NO_ACK.toString().toLowerCase().replace('_', '-') + "]");
        this.gfsh.println("     Partition attributes:");
        this.gfsh.println("        local-max-memory=<MB [90% of local heap]>");
        this.gfsh.println("        redundant-copies=<integer [0]>");
        this.gfsh.println("        total-max-memory=<MB>");
        this.gfsh.println("        total-num-buckets=<integer [113]>");
        this.gfsh.println("     Region attribute elements:");
        this.gfsh.println("        entry-idle-time.action=" + mkdir.getExpirationValues() + " [" + ExpirationAttributes.DEFAULT.getAction().toString().toLowerCase().replace('_', '-') + "]>");
        this.gfsh.println("        entry-idle-time.timeout=<integer [" + ExpirationAttributes.DEFAULT.getTimeout() + "]>");
        this.gfsh.println("        entry-time-to-live.action=" + mkdir.getExpirationValues() + " [" + ExpirationAttributes.DEFAULT.getAction().toString().toLowerCase().replace('_', '-') + "]>");
        this.gfsh.println("        entry-time-to-live.timeout=<integer [" + ExpirationAttributes.DEFAULT.getTimeout() + "]>");
        this.gfsh.println("        region-idle-time.action=" + mkdir.getExpirationValues() + " [" + ExpirationAttributes.DEFAULT.getAction().toString().toLowerCase().replace('_', '-') + "]>");
        this.gfsh.println("        region-idle-time.timeout=<integer [" + ExpirationAttributes.DEFAULT.getTimeout() + "]>");
        this.gfsh.println("        region-time-to-live.action=" + mkdir.getExpirationValues() + " [" + ExpirationAttributes.DEFAULT.getAction().toString().toLowerCase().replace('_', '-') + "]>");
        this.gfsh.println("        region-time-to-live.timeout=<integer [" + ExpirationAttributes.DEFAULT.getTimeout() + "]>");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("mkdir -?")) {
            this.help();
        } else if (command.startsWith("mkdir -g")) {
            this.mkdir_g(command);
        } else if (command.startsWith("mkdir -s")) {
            this.mkdir_s(command);
        } else {
            this.mkdir_local(command);
        }
    }

    private RegionAttributeInfo parseAttributes(String attributes) throws Exception {
        if (attributes == null) {
            return null;
        }
        if ((attributes = attributes.trim()).length() == 0) {
            return null;
        }
        RegionAttributeInfo attributeInfo = new RegionAttributeInfo();
        String[] split = attributes.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String[] pair = split[i].split("=");
            attributeInfo.setAttribute(pair[0], pair[1]);
        }
        return attributeInfo;
    }

    private void mkdir_g(String command) throws Exception {
        String fullPath;
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        RegionAttributeInfo attributeInfo = null;
        if (list.size() == 2) {
            fullPath = this.gfsh.getCurrentPath();
        } else {
            String regionPath = (String)list.get(2);
            String currentPath = this.gfsh.getCurrentPath();
            fullPath = this.gfsh.getFullPath(regionPath, currentPath);
            String attributes = "";
            for (int i = 3; i < list.size(); ++i) {
                attributes = attributes + list.get(i) + " ";
            }
            attributeInfo = this.parseAttributes(attributes);
        }
        if (fullPath.equals(this.gfsh.getCurrentPath())) {
            this.gfsh.println("Error: must define region path: mkdir [-g] <regionPath>");
        } else {
            List resultList = (List)this.gfsh.getAggregator().aggregate(new RegionCreateFunction(new RegionCreateTask(fullPath, attributeInfo)), this.gfsh.getAggregateRegionPath());
            int i = 1;
            for (CommandResults commandResults : resultList) {
                MemberInfo memberInfo = (MemberInfo)commandResults.getDataObject();
                this.gfsh.print(i + ". " + memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                if (commandResults.getCode() == 0) {
                    Region region = this.gfsh.isLocator() ? RegionUtil.getRegion(fullPath, Scope.LOCAL, DataPolicy.NORMAL, this.gfsh.getPool(), false) : RegionUtil.getRegion(fullPath, Scope.LOCAL, DataPolicy.NORMAL, this.gfsh.getEndpoints());
                    this.gfsh.println("region created: " + region.getFullPath());
                } else {
                    this.gfsh.println("error - " + commandResults.getCodeMessage());
                }
                ++i;
            }
        }
    }

    private void mkdir_s(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = "";
        RegionAttributeInfo attributeInfo = null;
        if (list.size() == 2) {
            regionPath = this.gfsh.getCurrentPath();
        } else {
            if (!"/".equals(this.gfsh.getCurrentPath())) {
                regionPath = this.gfsh.getCurrentPath();
            }
            regionPath = regionPath + "/" + (String)list.get(2);
            String attributes = "";
            for (int i = 3; i < list.size(); ++i) {
                attributes = attributes + list.get(i) + " ";
            }
            attributeInfo = this.parseAttributes(attributes);
        }
        if (regionPath.equals(this.gfsh.getCurrentPath())) {
            this.gfsh.println("Error: must define region path: mkdir [-s] <regionPath>");
        } else {
            CommandResults commandResults = this.gfsh.getCommandClient().execute(new RegionCreateTask(regionPath, attributeInfo));
            MemberInfo memberInfo = (MemberInfo)commandResults.getDataObject();
            this.gfsh.print(memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
            if (commandResults.getCode() == 0) {
                Region region = RegionUtil.getRegion(regionPath, Scope.LOCAL, DataPolicy.NORMAL, null);
                this.gfsh.println("region created: " + region.getFullPath());
            } else {
                this.gfsh.println("error - " + commandResults.getCodeMessage());
            }
        }
    }

    private void mkdir_local(String command) throws Exception {
        int index2 = command.indexOf(" ");
        if (index2 == -1) {
            this.gfsh.println("Current region: " + this.gfsh.getCurrentPath());
        } else {
            Cache cache = this.gfsh.getCache();
            String newPath = command.substring(index2).trim();
            String fullPath = this.gfsh.getFullPath(newPath, this.gfsh.getCurrentPath());
            if (fullPath == null) {
                this.gfsh.println("Error: region path must be provided. mkdir <regionPath>");
            } else {
                Region region = cache.getRegion(fullPath);
                if (region != null) {
                    this.gfsh.println("Region already exists: " + region.getFullPath());
                    return;
                }
                region = this.gfsh.isLocator() ? RegionUtil.getRegion(fullPath, Scope.LOCAL, DataPolicy.NORMAL, this.gfsh.getPool(), false) : RegionUtil.getRegion(fullPath, Scope.LOCAL, DataPolicy.NORMAL, this.gfsh.getEndpoints());
                this.gfsh.println("Region created: " + region.getFullPath());
            }
        }
    }

    private static String getDataPolicyValues() {
        String all = DataPolicy.EMPTY + "|" + DataPolicy.NORMAL + "|" + DataPolicy.PARTITION + "|" + DataPolicy.PERSISTENT_REPLICATE + "|" + DataPolicy.PRELOADED + "|" + DataPolicy.REPLICATE;
        return all.toLowerCase().replace('_', '-');
    }

    private static String getScopeValues() {
        String all = Scope.DISTRIBUTED_NO_ACK + "|" + Scope.DISTRIBUTED_ACK + "|" + Scope.GLOBAL + "|" + Scope.LOCAL;
        return all.toLowerCase().replace('_', '-');
    }

    private static String getTrueFalseValues() {
        return "true|false";
    }

    private static String getIndexUpdateTypeValues() {
        return "asynchronous|synchronous";
    }

    private static String getExpirationValues() {
        String all = ExpirationAction.DESTROY + "|" + ExpirationAction.INVALIDATE + "|" + ExpirationAction.LOCAL_DESTROY + "|" + ExpirationAction.LOCAL_INVALIDATE;
        return all.toLowerCase().replace('_', '-');
    }
}

