/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands.optional;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.Nextable;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.IndexInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.LookupService;
import com.gemstone.gemfire.internal.tools.gfsh.app.commands.next;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class look
implements CommandExecutable,
Nextable {
    private static LookupService lookupService;
    private Gfsh gfsh;

    public look(Gfsh gfsh) {
        this.gfsh = gfsh;
        gfsh.addEnumCommand("look");
    }

    @Override
    public void help() {
        this.gfsh.println("look [-i] | [-?] | [<query predicate>]");
        this.gfsh.println("     Execute the compound key lookup service. This command requires");
        this.gfsh.println("     the server to configure the gfcommand addon component,");
        this.gfsh.println("     com.gemstone.gemfire.internal.tools.gfsh.cache.index.IndexBuilder");
        this.gfsh.println("        <query predicate>: field=val1 and field2='val1'");
        this.gfsh.println("                          and field3=to_date('<date>', '<format>'");
        this.gfsh.println("           Primitives: no quotes");
        this.gfsh.println("           String: 'string value' (single quotes)");
        this.gfsh.println("           java.util.Date: to_date('<date>', '<format'>, i.e.,");
        this.gfsh.println("                           to_date('10/18/2008', 'MM/dd/yyyy'");
        this.gfsh.println("     -k Retrieve keys only. Values are not returned.");
        this.gfsh.println("     -i Print compound key index information.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("look -?")) {
            this.help();
        } else if (command.startsWith("look -i")) {
            this.look_i(command);
        } else if (command.startsWith("look")) {
            this.look(command);
        }
    }

    private LookupService getLookupService() {
        if (lookupService == null) {
            lookupService = new LookupService(this.gfsh.getCommandClient());
        }
        return lookupService;
    }

    private void look(String command) throws Exception {
        if (this.gfsh.getCurrentRegion() == null) {
            this.gfsh.println("Error: Region undefined. Use 'cd' to change region first before executing this command.");
            return;
        }
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        boolean keysOnly = false;
        String input = null;
        for (int i = 1; i < list.size(); ++i) {
            String token = (String)list.get(i);
            if (token.equals("-k")) {
                keysOnly = true;
                continue;
            }
            input = token;
        }
        if (input == null) {
            this.gfsh.println("Error: look requires query predicate");
        } else {
            Object key2 = null;
            key2 = keysOnly ? this.gfsh.getQueryKey(list, 2) : this.gfsh.getQueryKey(list, 1);
            long startTime = 0L;
            long stopTime = 0L;
            ArrayList keyList = new ArrayList();
            LookupService lookup = this.getLookupService();
            if (keysOnly) {
                startTime = System.currentTimeMillis();
                Set set = lookup.keySet(this.gfsh.getCurrentPath(), key2);
                stopTime = System.currentTimeMillis();
                if (this.gfsh.isShowResults()) {
                    PrintUtil.printSet(set, this.gfsh.getFetchSize(), keyList);
                } else {
                    this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
                    this.gfsh.println("   Results: " + set.size() + ", Returned: " + set.size() + "/" + set.size());
                }
            } else {
                startTime = System.currentTimeMillis();
                Map map = lookup.entryMap(this.gfsh.getCurrentPath(), key2);
                stopTime = System.currentTimeMillis();
                if (this.gfsh.isShowResults()) {
                    PrintUtil.printEntries(map, this.gfsh.getFetchSize(), keyList);
                } else {
                    this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
                    this.gfsh.println("   Results: " + map.size() + ", Returned: " + map.size() + "/" + map.size());
                }
            }
            this.gfsh.setLsKeyList(keyList);
            if (this.gfsh.isShowTime()) {
                this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
            }
            next n = (next)this.gfsh.getCommand("next");
            n.setCommand(this.getClass().getSimpleName());
        }
    }

    private void look_i(String command) throws Exception {
        if (this.gfsh.getCurrentRegion() == null) {
            this.gfsh.println("Error: Region undefined. Use 'cd' to change region first before executing this command.");
            return;
        }
        LookupService lookup = this.getLookupService();
        IndexInfo[] indexInfoArray = lookup.getIndexInfoArray(this.gfsh.getCurrentPath());
        if (indexInfoArray == null) {
            System.out.println("No index info available for " + this.gfsh.getCurrentPath());
        } else {
            for (int i = 0; i < indexInfoArray.length; ++i) {
                IndexInfo indexInfo = indexInfoArray[i];
                System.out.println(i + 1 + ". IndexInfo:");
                System.out.println("   indexListSize = " + indexInfo.indexListSize);
                System.out.println("   indexMapSize = " + indexInfo.indexMapSize);
                System.out.println("   minSetSize = " + indexInfo.minSetSize);
                System.out.println("   maxSetSize = " + indexInfo.maxSetSize);
                System.out.println("   minSetQueryKey = " + indexInfo.minSetQueryKey);
                System.out.println("   maxSetQueryKey = " + indexInfo.maxSetQueryKey);
                System.out.println();
            }
        }
    }

    @Override
    public List next(Object userData) throws Exception {
        this.gfsh.println("The command next is not supported for look.");
        return null;
    }
}

