/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands.optional;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import java.util.LinkedList;

public class perf
implements CommandExecutable {
    private static final String HIDDEN_REGION_NAME_PREFIX = "_";
    private Gfsh gfsh;

    public perf(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("perf [-threads <count>]");
        this.gfsh.println("     [-payload <size>]");
        this.gfsh.println("     [-type put|get|delete|putall|getall|deleteall <batch size>]");
        this.gfsh.println("     [-input random|sequence");
        this.gfsh.println("     [-size <total entry size or count>");
        this.gfsh.println("     [-key int|long|string|<class name>");
        this.gfsh.println("     [-loop <count>]");
        this.gfsh.println("     [-interval <count>]");
        this.gfsh.println("     [<region path>]");
        this.gfsh.println("     [-?]");
        this.gfsh.println("     Measure throughput rates and \"put\" latency.");
        this.gfsh.println("     -threads <count> The number of threads to concurrently put data into");
        this.gfsh.println("         the fabric. Default: 1");
        this.gfsh.println("     -payload <size> The payliod size in bytes. Perf puts byte arrays of the");
        this.gfsh.println("         specified size into the fabric. Default: 100 bytes.");
        this.gfsh.println("     -type put|get|delete|putall|getall|deleteall <batch size>");
        this.gfsh.println("         The operation type. <batch size> is for '*all' only. Default: put");
        this.gfsh.println("     -input  The input type. 'random' selects keys randomly from the range of");
        this.gfsh.println("        <total entry size>. 'sequnce' sequntial keys from 1 to <total entry size");
        this.gfsh.println("        and repeats until the loop count is exhausted. Default: random");
        this.gfsh.println("     -size   The total size of the cache. This option is only for '-type put'");
        this.gfsh.println("         and '-type putall'.");
        this.gfsh.println("     -key int|long|string|<class name>  The key type. The keys of the type");
        this.gfsh.println("         int or long are numerical values incremented in the loop. The keys");
        this.gfsh.println("         of type string are String values formed by the prefix and the numerical");
        this.gfsh.println("         values that are incremented in the loop. The default prefix is \"key\".");
        this.gfsh.println("         The keys of type <class name> are supplied by the class that implements");
        this.gfsh.println("         the com.gemstone.gemfire.addons.gfsh.data.PerfKey interface. The class");
        this.gfsh.println("         implements getKey(int keyNum) which returns a Serializable or preferrably");
        this.gfsh.println("         DataSerializable object.");
        this.gfsh.println("     -loop <count>  The number of iterations per thread. Each thread invokes");
        this.gfsh.println("         put() or putAll() per iteration. Default: 10000");
        this.gfsh.println("     -inteval <count> The display interval. Each thread prints the average");
        this.gfsh.println("         throughput and latency after each interval interation count. Default: 1000");
        this.gfsh.println("     <region path>  The region to put data into. Default: current region.");
        this.gfsh.println("     Default: perf -threads 1 -payload 100 -type put -input random -size 10000 -loop 10000 -interval 1000 ./");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("perf -?")) {
            this.help();
            return;
        }
        this.perf(command);
    }

    private void perf(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        int threadCount = 1;
        int payloadSize = 100;
        int putAllSize = 1;
        int loopCount = 10000;
        int interval = 1000;
        String regionPath = null;
        int listSize = list.size();
        for (int i = 1; i < listSize; ++i) {
            String arg = (String)list.get(i);
            if (arg.equals("-threads")) {
                if (++i >= listSize) {
                    this.gfsh.println("Error: '-threads' requires <count>");
                    return;
                }
                threadCount = Integer.parseInt((String)list.get(i));
                continue;
            }
            if (arg.equals("-payload")) {
                if (++i >= listSize) {
                    this.gfsh.println("Error: '-payload' requires <size>");
                    return;
                }
                payloadSize = Integer.parseInt((String)list.get(i));
                continue;
            }
            if (arg.equals("-putall")) {
                if (++i >= listSize) {
                    this.gfsh.println("Error: '-putall' requires <batch size>");
                    return;
                }
                putAllSize = Integer.parseInt((String)list.get(i));
                continue;
            }
            if (arg.equals("-loop")) {
                if (++i >= listSize) {
                    this.gfsh.println("Error: '-loop' requires <count>");
                    return;
                }
                loopCount = Integer.parseInt((String)list.get(i));
                continue;
            }
            if (arg.equals("-interval")) {
                if (++i >= listSize) {
                    this.gfsh.println("Error: '-interval' requires <count>");
                    return;
                }
                interval = Integer.parseInt((String)list.get(i));
                continue;
            }
            regionPath = (String)list.get(i);
        }
        if (regionPath == null) {
            regionPath = this.gfsh.getCurrentPath();
        }
        this.benchmark(threadCount, payloadSize, putAllSize, loopCount, interval, regionPath);
    }

    private void benchmark(int threadCount, int payloadSize, int putAllSize, int loopCount, int interval, String regionPath) {
    }
}

