/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import java.util.ArrayList;

public class property
implements CommandExecutable {
    private Gfsh gfsh;

    public property(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("property [<key>[=<value>]] | [-u <key>] | [?] ");
        this.gfsh.println("   Sets the property that can be used using ${key},");
        this.gfsh.println("   which gfsh expands with the matching value.");
        this.gfsh.println();
        this.gfsh.println("   -u <key> This option unsets (removes) the property.");
        this.gfsh.println("            'property <key>=' (with no value) also removes the");
        this.gfsh.println("             property (key).");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("property -?")) {
            this.help();
        } else if (command.startsWith("property -u")) {
            this.property_u(command);
        } else {
            this.property(command);
        }
    }

    private void property_u(String command) {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 3) {
            return;
        }
        String key2 = (String)list.get(2);
        this.gfsh.setProperty(key2, null);
    }

    private void property(String command) {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() == 1) {
            this.gfsh.printProperties();
            this.gfsh.println();
            return;
        }
        String prop = "";
        for (int i = 1; i < list.size(); ++i) {
            prop = prop + (String)list.get(i) + " ";
        }
        int index2 = (prop = prop.trim()).indexOf("=");
        if (index2 == -1) {
            String key2 = (String)list.get(1);
            String value2 = this.gfsh.getProperty(key2);
            this.gfsh.println(key2 + "=" + value2);
        } else {
            String key3 = prop.substring(0, index2);
            String value3 = prop.substring(index2 + 1);
            this.gfsh.setProperty(key3, value3);
        }
        this.gfsh.println();
    }
}

