/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.commands.db;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class show
implements CommandExecutable {
    private Gfsh gfsh;

    public show(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("show [-p [true|false]]");
        this.gfsh.println("     [-t [true|false]]");
        this.gfsh.println("     [-c|-k|-v]");
        this.gfsh.println("     [-table [true|false]");
        this.gfsh.println("     [-type [true|false]");
        this.gfsh.println("     [-col <collection entry print count>]");
        this.gfsh.println();
        this.gfsh.println("     [-?]");
        this.gfsh.println("     Show or toggle settings.");
        this.gfsh.println("     <no option> Show all current settings.");
        this.gfsh.println("     -p Toggle print. If enabled, results are printed to stdout.");
        this.gfsh.println("     -t Toggle the time taken to execute each command.");
        this.gfsh.println("     -c Show configuration");
        this.gfsh.println("     -k Show key class fields. Use the 'key' command to set key class.");
        this.gfsh.println("     -v Show value class fields. Use the 'value' command to set value class.");
        this.gfsh.println("     -table Set the print format to the tabular or catalog form. The");
        this.gfsh.println("         tabular form prints in a table with a column header. The catalog");
        this.gfsh.println("         form prints in each row in a data structure form.");
        this.gfsh.println("     -type Enable or disable printing the data type. This option is");
        this.gfsh.println("         valid only for the '-table false' option.");
        this.gfsh.println("     -col <collection entry print count> In the catalog mode, gfsh");
        this.gfsh.println("         prints the contents of Map and Collection objects. By default, it");
        this.gfsh.println("         prints 5 entries per object. Use this option to change the count.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("show -?")) {
            this.help();
        } else if (command.startsWith("show -table")) {
            this.show_table(command);
        } else if (command.startsWith("show -type")) {
            this.show_type(command);
        } else if (command.startsWith("show -col")) {
            this.show_count(command);
        } else if (command.startsWith("show -p")) {
            this.show_p(command);
        } else if (command.startsWith("show -t")) {
            this.show_t(command);
        } else if (command.startsWith("show -c")) {
            this.show_c();
        } else if (command.startsWith("show -k")) {
            this.show_k();
        } else if (command.startsWith("show -v")) {
            this.show_v();
        } else {
            this.show();
        }
    }

    private void show_table(String command) throws Exception {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() >= 3) {
            boolean enable = ((String)list.get(2)).equalsIgnoreCase("true");
            this.gfsh.setTableFormat(enable);
        } else {
            this.gfsh.setTableFormat(!this.gfsh.isTableFormat());
        }
        this.gfsh.println("show -table is " + (this.gfsh.isTableFormat() ? "true" : "false"));
    }

    private void show_type(String command) throws Exception {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() >= 3) {
            boolean enable = ((String)list.get(2)).equalsIgnoreCase("true");
            this.gfsh.setPrintType(enable);
        } else {
            this.gfsh.setPrintType(!this.gfsh.isPrintType());
        }
        this.gfsh.println("show -type is " + (this.gfsh.isPrintType() ? "true" : "false"));
    }

    private void show_count(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 3) {
            this.gfsh.println("Error: must specify <collection entry print count>. Current count is " + this.gfsh.getCollectionEntryPrintCount());
            return;
        }
        try {
            int count = Integer.parseInt((String)list.get(2));
            this.gfsh.setCollectionEntryPrintCount(count);
        }
        catch (Exception ex) {
            this.gfsh.println("Error: " + ex.getClass().getSimpleName() + " - " + ex.getMessage());
        }
    }

    public void show_p(String command) {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() >= 3) {
            boolean enable = ((String)list.get(2)).equalsIgnoreCase("true");
            this.gfsh.setShowResults(enable);
        } else {
            this.gfsh.setShowResults(!this.gfsh.isShowResults());
        }
        this.gfsh.println("show -p is " + (this.gfsh.isShowResults() ? "true" : "false"));
    }

    private void show_t(String command) throws Exception {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() >= 3) {
            boolean enable = ((String)list.get(2)).equalsIgnoreCase("true");
            this.gfsh.setShowResults(enable);
        } else {
            this.gfsh.setShowTime(!this.gfsh.isShowTime());
        }
        this.gfsh.println("show -t is " + (this.gfsh.isShowTime() ? "true" : "false"));
    }

    @SuppressFBWarnings(value={"NM_METHOD_CONSTRUCTOR_CONFUSION"}, justification="This is method and not constructor")
    public void show() {
        this.show_c();
        this.gfsh.println();
        this.show_k();
        this.gfsh.println();
        this.show_v();
    }

    public void show_c() {
        db dbCommand = (db)this.gfsh.getCommand("db");
        this.gfsh.println("     connected = " + this.gfsh.isConnected());
        if (dbCommand != null) {
            this.gfsh.println("            db = " + dbCommand.getDbInitCommand());
        }
        this.gfsh.println("          echo = " + this.gfsh.isEcho());
        if (this.gfsh.getEndpoints() == null && this.gfsh.getEndpoints() == null) {
            this.gfsh.println("      locators = null");
            this.gfsh.println("       servers = null");
        } else {
            if (this.gfsh.isLocator()) {
                this.gfsh.println("      locators = " + this.gfsh.getEndpoints());
                if (this.gfsh.getServerGroup() == null) {
                    this.gfsh.println("  server group = <undefined>");
                } else {
                    this.gfsh.println("  server group = " + this.gfsh.getServerGroup());
                }
            } else {
                this.gfsh.println("       servers = " + this.gfsh.getEndpoints());
            }
            this.gfsh.println("  read timeout = " + this.gfsh.getReadTimeout());
        }
        this.gfsh.println("  select limit = " + this.gfsh.getSelectLimit());
        this.gfsh.println("         fetch = " + this.gfsh.getFetchSize());
        this.gfsh.println("           key = " + this.gfsh.getQueryKeyClassName());
        this.gfsh.println("         value = " + this.gfsh.getValueClassName());
        this.gfsh.println("       show -p = " + this.gfsh.isShowResults());
        this.gfsh.println("       show -t = " + this.gfsh.isShowTime());
        this.gfsh.println("   show -table = " + this.gfsh.isTableFormat());
        this.gfsh.println("    show -type = " + this.gfsh.isPrintType());
        this.gfsh.println("     show -col = " + this.gfsh.getCollectionEntryPrintCount());
        this.gfsh.println("  zone (hours) = " + this.gfsh.getZoneDifference() / 3600000L);
    }

    public void show_k() {
        this.printClassSetters(this.gfsh.getQueryKeyClass(), "key");
    }

    public void show_v() {
        this.printClassSetters(this.gfsh.getValueClass(), "value");
    }

    private void printClassSetters(Class cls, String header) {
        if (cls == null) {
            this.gfsh.println(header + " class: undefined");
        } else {
            this.gfsh.println(header + " class " + cls.getName());
            this.gfsh.println("{");
            try {
                Map setterMap = ReflectionUtil.getAllSettersMap(cls);
                ArrayList list = new ArrayList(setterMap.keySet());
                Collections.sort(list);
                for (Object object : list) {
                    Method method = (Method)setterMap.get(object);
                    if (!this.isSupportedMethod(method)) continue;
                    this.gfsh.println("    " + method.getName().substring(3) + "::" + method.getParameterTypes()[0].getCanonicalName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.gfsh.println("}");
        }
    }

    private boolean isSupportedMethod(Method method) {
        return true;
    }
}

