/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.functions.util.LocalRegionInfoFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionSizeTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.StringUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class size
implements CommandExecutable {
    private Gfsh gfsh;

    public size(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("size [-m|-s] | [-?] <region path>");
        this.gfsh.println("     Display the local and server region sizes. If no option");
        this.gfsh.println("     is provided then it displays the local region size");
        this.gfsh.println("     -m List all server member region sizes.");
        this.gfsh.println("     -s Display the region size of the connected server.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("size -?")) {
            this.help();
        } else if (command.startsWith("size -m")) {
            this.size_m(command);
        } else if (command.startsWith("size -s")) {
            this.size_s(command);
        } else {
            this.size(command);
        }
    }

    private void size(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = list.size() == 1 ? this.gfsh.getCurrentPath() : (list.size() == 2 ? (String)list.get(1) : (String)list.get(2));
        regionPath = regionPath.trim();
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: Invalid path. Root path not allowed.");
            return;
        }
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        this.gfsh.println("            Region: " + regionPath);
        Cache cache = this.gfsh.getCache();
        Region region = cache.getRegion(regionPath);
        if (region == null) {
            this.gfsh.println("Error: region undefine - " + regionPath);
        } else {
            this.gfsh.println(" Local region size: " + region.size());
        }
    }

    private void size_m(String command) throws Exception {
        if (this.gfsh.getAggregateRegionPath() == null) {
            this.gfsh.println("Error: The aggregate region path is not specified. Use the command ");
            this.gfsh.println("'connect -a <region path>' to specify any existing partitioned region path in the server.");
            return;
        }
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = list.size() == 2 ? this.gfsh.getCurrentPath() : (String)list.get(2);
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: invalid region \"/\". Change to a valid region or specify the region path, i.e. size -a /foo");
            return;
        }
        long startTime = System.currentTimeMillis();
        List resultList = (List)this.gfsh.getAggregator().aggregate(new LocalRegionInfoFunction(regionPath), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        String memberIdHeader = "Member Id";
        String memberNameHeader = "Member Name";
        String regionSizeHeader = "Region Size";
        int memberIdMax = memberIdHeader.length();
        int memberNameMax = memberNameHeader.length();
        int regionSizeMax = regionSizeHeader.length();
        boolean isPR = false;
        boolean isPeerClient = false;
        String returnedRegionPath = null;
        HashMap<String, Mappable> infoMap = new HashMap<String, Mappable>();
        for (int i = 0; i < resultList.size(); ++i) {
            String val;
            String memberName;
            Mappable info = (Mappable)resultList.get(i);
            try {
                if (info.getByte("Code") == -1) {
                    this.gfsh.println("Error: " + info.getString("CodeMessage"));
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            isPR = info.getBoolean("IsPR");
            if (isPR) {
                try {
                    isPeerClient = info.getBoolean("IsPeerClient");
                }
                catch (Exception ex) {
                    continue;
                }
                if (isPeerClient) continue;
            }
            returnedRegionPath = info.getString("RegionPath");
            String memberId = info.getString("MemberId");
            if (memberIdMax < memberId.length()) {
                memberIdMax = memberId.length();
            }
            if ((memberName = info.getString("MemberName")) != null && memberNameMax < memberName.length()) {
                memberNameMax = memberName.length();
            }
            if (regionSizeMax < (val = Integer.toString(info.getInt("RegionSize"))).length()) {
                regionSizeMax = val.length();
            }
            infoMap.put(info.getString("MemberId"), info);
        }
        ArrayList keyList = new ArrayList(infoMap.keySet());
        Collections.sort(keyList);
        this.gfsh.println("     Region: " + returnedRegionPath);
        if (isPR) {
            this.gfsh.println("Region Type: Partitioned");
        } else {
            this.gfsh.println("Region Type: Replicated");
        }
        this.gfsh.print(StringUtil.getRightPaddedString(memberIdHeader, memberIdMax, ' '));
        this.gfsh.print("  ");
        this.gfsh.print(StringUtil.getRightPaddedString(memberNameHeader, memberNameMax, ' '));
        this.gfsh.print("  ");
        this.gfsh.println(regionSizeHeader);
        this.gfsh.print(StringUtil.getRightPaddedString("---------", memberIdMax, ' '));
        this.gfsh.print("  ");
        this.gfsh.print(StringUtil.getRightPaddedString("-----------", memberNameMax, ' '));
        this.gfsh.print("  ");
        this.gfsh.println(StringUtil.getRightPaddedString("-----------", regionSizeMax, ' '));
        int totalRegionSize = 0;
        for (int i = 0; i < keyList.size(); ++i) {
            Mappable info = (Mappable)infoMap.get(keyList.get(i));
            try {
                if (info.getByte("Code") == -1) {
                    this.gfsh.println("Error: " + info.getString("CodeMessage"));
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            isPR = info.getBoolean("IsPR");
            this.gfsh.print(StringUtil.getRightPaddedString(info.getString("MemberId"), memberIdMax, ' '));
            this.gfsh.print("  ");
            this.gfsh.print(StringUtil.getRightPaddedString(info.getString("MemberName"), memberNameMax, ' '));
            this.gfsh.print("  ");
            this.gfsh.println(StringUtil.getLeftPaddedString(Integer.toString(info.getInt("RegionSize")), regionSizeMax, ' '));
            totalRegionSize += info.getInt("RegionSize");
        }
        this.gfsh.println();
        if (isPR) {
            this.gfsh.print(StringUtil.getLeftPaddedString("Total: ", memberIdMax + memberNameMax + 4, ' '));
            this.gfsh.println(StringUtil.getLeftPaddedString(Integer.toString(totalRegionSize), regionSizeMax, ' '));
        }
        this.gfsh.println();
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }

    private void size_s(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = list.size() == 2 ? this.gfsh.getCurrentPath() : (String)list.get(2);
        regionPath = regionPath.trim();
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: Invalid path. Root path not allowed.");
            return;
        }
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        this.gfsh.println("            Region: " + regionPath);
        Cache cache = this.gfsh.getCache();
        Region region = cache.getRegion(regionPath);
        if (region == null) {
            this.gfsh.println("Error: region undefine - " + regionPath);
        } else {
            this.gfsh.println(" Local region size: " + region.size());
        }
        CommandResults results = this.gfsh.getCommandClient().execute(new RegionSizeTask(regionPath));
        Object obj = results.getDataObject();
        if (obj == null) {
            this.gfsh.println("Error: Unable to get size from the server - " + results.getCodeMessage());
        } else {
            ArrayList<Mappable> sizeList = new ArrayList<Mappable>(2);
            sizeList.add((Mappable)results.getDataObject());
            PrintUtil.printMappableList(sizeList);
        }
    }
}

