/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GfshData
implements DataSerializable {
    private static final long serialVersionUID = 1L;
    private MemberInfo memberInfo;
    private Object dataObject;
    private Object userData;

    public GfshData() {
    }

    public GfshData(Object dataObject) {
        Cache cache = CacheFactory.getAnyInstance();
        this.memberInfo = new MemberInfo();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        this.memberInfo.setHost(member.getHost());
        this.memberInfo.setMemberId(member.getId());
        this.memberInfo.setMemberName(cache.getName());
        this.memberInfo.setPid(member.getProcessId());
        this.dataObject = dataObject;
    }

    public GfshData(MemberInfo memberInfo, Object dataObject) {
        this.memberInfo = memberInfo;
        this.dataObject = dataObject;
    }

    public MemberInfo getMemberInfo() {
        return this.memberInfo;
    }

    public void setMemberInfo(MemberInfo memberInfo) {
        this.memberInfo = memberInfo;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberInfo = (MemberInfo)DataSerializer.readObject(in);
        this.dataObject = DataSerializer.readObject(in);
        this.userData = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberInfo, out);
        DataSerializer.writeObject(this.dataObject, out);
        DataSerializer.writeObject(this.userData, out);
    }
}

