/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.ServerExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GfshFunction
implements AggregateFunction,
DataSerializable {
    private static final long serialVersionUID = 1L;
    private String command;
    private String regionPath;
    private Object arg;

    public GfshFunction() {
    }

    public GfshFunction(String command, String regionPath, Object arg) {
        this.command = command;
        this.regionPath = regionPath;
        this.arg = arg;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Object getArg() {
        return this.arg;
    }

    public void setArg(Object arg) {
        this.arg = arg;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public void setRegionPath(String regionPath) {
        this.regionPath = regionPath;
    }

    @Override
    public AggregateResults run(FunctionContext context) {
        AggregateResults results = new AggregateResults();
        try {
            String[] split = this.command.split(" ");
            String className = split[0].trim();
            Class<?> clas = Class.forName("com.gemstone.gemfire.internal.tools.gfsh.app.function.command." + className);
            ServerExecutable se = (ServerExecutable)clas.newInstance();
            Object obj = se.execute(this.command, this.regionPath, this.arg);
            results.setDataObject(obj);
            results.setCode(se.getCode());
            results.setCodeMessage(se.getCodeMessage());
        }
        catch (Exception ex) {
            results.setCode((byte)-1);
            results.setCodeMessage(this.getCauseMessage(ex));
            results.setException(ex);
        }
        return results;
    }

    private String getCauseMessage(Throwable ex) {
        Throwable cause = ex.getCause();
        String causeMessage = null;
        if (cause != null) {
            causeMessage = this.getCauseMessage(cause);
        } else {
            causeMessage = ex.getClass().getSimpleName();
            causeMessage = causeMessage + " -- " + ex.getMessage();
        }
        return causeMessage;
    }

    @Override
    public synchronized Object aggregate(List list) {
        HashMap<String, AggregateResults> map = new HashMap<String, AggregateResults>();
        for (int i = 0; i < list.size(); ++i) {
            MemberInfo info;
            AggregateResults mapResults;
            AggregateResults results = (AggregateResults)list.get(i);
            GfshData data = (GfshData)results.getDataObject();
            if (data == null) {
                data = new GfshData(null);
            }
            if ((mapResults = (AggregateResults)map.get((info = data.getMemberInfo()).getMemberId())) == null) {
                map.put(info.getMemberId(), results);
                continue;
            }
            if (mapResults.getCode() == 0) continue;
            map.put(info.getMemberId(), results);
        }
        return new ArrayList(map.values());
    }

    @Override
    public synchronized Object aggregateDistributedSystems(Object[] results) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < results.length; ++i) {
            list.add(results[i]);
        }
        return list;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.command = DataSerializer.readString(input);
        this.regionPath = DataSerializer.readString(input);
        this.arg = DataSerializer.readObject(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        DataSerializer.writeString(this.command, output);
        DataSerializer.writeString(this.regionPath, output);
        DataSerializer.writeObject(this.arg, output);
    }
}

