/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function.command;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.tools.gfsh.app.ServerExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ClassFinder;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.SystemClassPathManager;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyType;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyTypeManager;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public class deploy
implements ServerExecutable {
    private static final String ENV_GEMFIRE_HOME = "GEMFIRE";
    private byte code = 0;
    private String codeMessage = null;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmm");

    @Override
    public Object execute(String command, String regionPath, Object arg) throws Exception {
        GfshData data = new GfshData(null);
        Cache cache = CacheFactory.getAnyInstance();
        Object[] args = (Object[])arg;
        String operationType2 = (String)args[0];
        if (operationType2.equals("-jar")) {
            block9: {
                String[] jarNames = (String[])args[1];
                byte[][] byteBuffers = (byte[][])args[2];
                try {
                    int i;
                    String home = System.getenv(ENV_GEMFIRE_HOME);
                    String classDir = home + "/gfsh/plugins";
                    File classDirFile = new File(classDir);
                    classDirFile.mkdirs();
                    String[] datedFilePaths = new String[jarNames.length];
                    for (i = 0; i < byteBuffers.length; ++i) {
                        String filePath;
                        datedFilePaths[i] = filePath = classDir + "/" + deploy.getDatedJarName(jarNames[i]);
                        File file = new File(filePath);
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write(byteBuffers[i]);
                        fos.close();
                    }
                    for (i = 0; i < datedFilePaths.length; ++i) {
                        File file = new File(datedFilePaths[i]);
                        SystemClassPathManager.addFile(file);
                    }
                    for (i = 0; i < datedFilePaths.length; ++i) {
                        Class[] classes = ClassFinder.getAllClasses(datedFilePaths[i]);
                        for (int j = 0; j < classes.length; ++j) {
                            Class cls = classes[j];
                            if (!KeyType.class.isAssignableFrom(cls) || !cls.getSimpleName().matches(".*_v\\d++$")) continue;
                            Method method = cls.getMethod("getKeyType", null);
                            KeyType fieldType = (KeyType)method.invoke((Object)cls, (Object[])null);
                            KeyTypeManager.registerSingleKeyType(fieldType);
                        }
                    }
                    this.codeMessage = "deployed to " + classDirFile.getAbsolutePath();
                }
                catch (Exception ex) {
                    while (ex.getCause() != null) {
                        ex = (Exception)ex.getCause();
                    }
                    this.codeMessage = ex.getMessage();
                    if (this.codeMessage != null) {
                        this.codeMessage = this.codeMessage.trim();
                    }
                    if (this.codeMessage != null && this.codeMessage.length() != 0) break block9;
                    this.codeMessage = ex.getClass().getSimpleName();
                }
            }
            data.setDataObject(this.codeMessage);
        }
        return data;
    }

    private static String getDatedJarName(String jarName) {
        String nameNoExtension = jarName.substring(0, jarName.lastIndexOf(".jar"));
        return nameNoExtension + ".v" + dateFormatter.format(new Date()) + ".jar";
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getCodeMessage() {
        return this.codeMessage;
    }
}

