/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function.command;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.internal.tools.gfsh.app.ServerExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.MapMessage;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import java.util.ArrayList;
import java.util.Collection;

public class index
implements ServerExecutable {
    private byte code = 0;
    private String codeMessage = null;

    @Override
    public Object execute(String command, String regionPath, Object arg) throws Exception {
        GfshData data = new GfshData(null);
        Cache cache = CacheFactory.getAnyInstance();
        Region region = null;
        if (regionPath != null) {
            region = cache.getRegion(regionPath);
        }
        String thisMemberId = cache.getDistributedSystem().getDistributedMember().getId();
        QueryService qs = cache.getQueryService();
        Object[] args = (Object[])arg;
        String memberId = null;
        String indexName = null;
        String operationType2 = (String)args[0];
        if (operationType2.equals("-create")) {
            block32: {
                memberId = (String)args[1];
                if (memberId != null && !memberId.equals(thisMemberId)) {
                    return data;
                }
                indexName = (String)args[2];
                boolean isFunctional = (Boolean)args[3];
                IndexType indexType = isFunctional ? IndexType.FUNCTIONAL : IndexType.PRIMARY_KEY;
                String indexExpression = (String)args[4];
                String fromClause = (String)args[5];
                String imports = (String)args[6];
                try {
                    Index index2 = qs.createIndex(indexName, indexType, indexExpression, fromClause, imports);
                    this.codeMessage = "index created: " + indexName;
                }
                catch (Exception ex) {
                    while (ex.getCause() != null) {
                        ex = (Exception)ex.getCause();
                    }
                    this.codeMessage = ex.getMessage();
                    if (this.codeMessage != null) {
                        this.codeMessage = this.codeMessage.trim();
                    }
                    if (this.codeMessage != null && this.codeMessage.length() != 0) break block32;
                    this.codeMessage = ex.getClass().getSimpleName();
                }
            }
            data.setDataObject(this.codeMessage);
        } else if (operationType2.equals("-delete")) {
            DeleteType deleteType = (DeleteType)((Object)args[1]);
            memberId = (String)args[2];
            if (memberId != null && !memberId.equals(thisMemberId)) {
                return data;
            }
            indexName = (String)args[3];
            switch (deleteType) {
                case DELETE_ALL_INDEXES: {
                    qs.removeIndexes();
                    this.codeMessage = "all indexes deleted from the member";
                    break;
                }
                case DELETE_REGION_INDEXES: {
                    try {
                        qs.removeIndexes(region);
                        this.codeMessage = "all indexes deleted from " + region.getFullPath();
                    }
                    catch (Exception ex) {
                        this.codeMessage = ex.getMessage();
                    }
                    break;
                }
                case DELETE_INDEX: {
                    Index index3 = qs.getIndex(region, indexName);
                    if (index3 == null) {
                        this.codeMessage = "index does not exist";
                        break;
                    }
                    try {
                        qs.removeIndex(index3);
                        this.codeMessage = "index deleted from " + region.getFullPath();
                        break;
                    }
                    catch (Exception ex) {
                        this.codeMessage = ex.getMessage();
                        if (this.codeMessage != null) {
                            this.codeMessage = this.codeMessage.trim();
                        }
                        if (this.codeMessage != null && this.codeMessage.length() != 0) break;
                        this.codeMessage = ex.getClass().getSimpleName();
                    }
                }
            }
            data.setDataObject(this.codeMessage);
        } else if (operationType2.equals("-list")) {
            memberId = (String)args[1];
            if (memberId != null && !memberId.equals(thisMemberId)) {
                return data;
            }
            boolean isAll = (Boolean)args[2];
            boolean isStats = (Boolean)args[3];
            Collection<Index> col = null;
            if (isAll) {
                col = qs.getIndexes();
            } else if (region != null) {
                col = qs.getIndexes(region);
            } else {
                this.codeMessage = "Invalid index command. Region path not specified.";
                data.setDataObject(this.codeMessage);
                return data;
            }
            ArrayList<MapMessage> mappableList = new ArrayList<MapMessage>();
            for (Index index4 : col) {
                indexName = index4.getName();
                String type = index4.getType().toString();
                String indexExpression = index4.getIndexedExpression();
                String fromClause = index4.getFromClause();
                MapMessage mapMessage = new MapMessage();
                mapMessage.put("Name", indexName);
                mapMessage.put("Type", type);
                mapMessage.put("Expression", indexExpression);
                mapMessage.put("From", fromClause);
                if (isStats) {
                    try {
                        IndexStatistics stats = index4.getStatistics();
                        mapMessage.put("Keys", stats.getNumberOfKeys());
                        mapMessage.put("Values", stats.getNumberOfValues());
                        mapMessage.put("Updates", stats.getNumUpdates());
                        mapMessage.put("TotalUpdateTime", stats.getTotalUpdateTime());
                        mapMessage.put("TotalUses", stats.getTotalUses());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                mappableList.add(mapMessage);
            }
            data.setDataObject(mappableList);
        }
        return data;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getCodeMessage() {
        return this.codeMessage;
    }

    public static enum DeleteType {
        DELETE_INDEX,
        DELETE_REGION_INDEXES,
        DELETE_ALL_INDEXES;

    }
}

