/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function.command;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.ServerExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

public class rebalance
implements ServerExecutable {
    private byte code = 0;
    private String codeMessage = null;

    @Override
    public Object execute(String command, String regionPath, Object arg) throws Exception {
        String thisMemberId;
        GfshData data = new GfshData(null);
        Cache cache = CacheFactory.getAnyInstance();
        Object[] args = (Object[])arg;
        boolean simulate = true;
        String memberId = null;
        if (args == null || args.length <= 0) {
            return data;
        }
        memberId = args[0].toString();
        if (args.length > 1 && args[1] instanceof Boolean) {
            simulate = (Boolean)args[1];
        }
        long timeout = 60000L;
        if (args.length > 2) {
            timeout = (Long)args[2];
        }
        if (!memberId.equals(thisMemberId = cache.getDistributedSystem().getDistributedMember().getId())) {
            return data;
        }
        try {
            Map map = null;
            map = simulate ? this.simulate() : this.rebalance(timeout);
            data.setDataObject(map);
        }
        catch (Exception ex) {
            this.code = (byte)-1;
            this.codeMessage = ex.getMessage();
        }
        return data;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getCodeMessage() {
        return this.codeMessage;
    }

    private Map rebalance(long timeout) throws CancellationException, InterruptedException {
        Cache cache = CacheFactory.getAnyInstance();
        ResourceManager manager = cache.getResourceManager();
        RebalanceOperation op = manager.createRebalanceFactory().start();
        try {
            RebalanceResults results = op.getResults(timeout, TimeUnit.MILLISECONDS);
            return this.convertToMap(results);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Map simulate() throws CancellationException, InterruptedException {
        Cache cache = CacheFactory.getAnyInstance();
        ResourceManager manager = cache.getResourceManager();
        RebalanceOperation op = manager.createRebalanceFactory().simulate();
        RebalanceResults results = op.getResults();
        Set<PartitionRebalanceInfo> set = results.getPartitionRebalanceDetails();
        return this.convertToMap(results);
    }

    private TreeMap convertToMap(RebalanceResults results) {
        TreeMap<String, Number> map = new TreeMap<String, Number>();
        map.put("TotalBucketCreateBytes", results.getTotalBucketCreateBytes());
        map.put("TotalBucketCreatesCompleted", results.getTotalBucketCreatesCompleted());
        map.put("TotalBucketCreateTime", results.getTotalBucketCreateTime());
        map.put("TotalBucketTransferBytes", results.getTotalBucketTransferBytes());
        map.put("TotalBucketTransfersCompleted", results.getTotalBucketTransfersCompleted());
        map.put("TotalBucketTransferTime", results.getTotalBucketTransferTime());
        map.put("TotalPrimaryTransfersCompleted", results.getTotalPrimaryTransfersCompleted());
        map.put("TotalPrimaryTransferTime", results.getTotalPrimaryTransferTime());
        map.put("TotalTime", results.getTotalTime());
        return map;
    }
}

